/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class FD_PROB
extends Protocol
implements Runnable {
    Address local_addr = null;
    Thread hb = null;
    long timeout = 3000L;
    long gossip_interval = 1000L;
    Vector members = null;
    final Hashtable counters = new Hashtable();
    final Hashtable invalid_pingers = new Hashtable();
    int max_tries = 2;

    public String getName() {
        return "FD_PROB";
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("gossip_interval")) != null) {
            this.gossip_interval = Long.parseLong(str);
            props.remove("gossip_interval");
        }
        if ((str = props.getProperty("max_tries")) != null) {
            this.max_tries = Integer.parseInt(str);
            props.remove("max_tries");
        }
        if (props.size() > 0) {
            System.err.println("FD_PROB.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void start() throws Exception {
        if (this.hb == null) {
            this.hb = new Thread((Runnable)this, "FD_PROB.HeartbeatThread");
            this.hb.setDaemon(true);
            this.hb.start();
        }
    }

    public void stop() {
        Thread tmp = null;
        if (this.hb != null && this.hb.isAlive()) {
            tmp = this.hb;
            this.hb = null;
            tmp.interrupt();
            try {
                tmp.join(this.timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.hb = null;
    }

    public void up(Event evt) {
        FdHeader hdr = null;
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof FdHeader)) {
                    this.updateCounter(msg.getSrc());
                    break;
                }
                hdr = (FdHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 1: {
                        if (!this.checkPingerValidity(msg.getSrc())) {
                            return;
                        }
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)("<-- HEARTBEAT from " + msg.getSrc()));
                        }
                        this.updateCounters(hdr);
                        return;
                    }
                    case 2: {
                        if (this.log.isWarnEnabled()) {
                            this.log.warn((Object)"NOT_MEMBER: I'm being shunned; exiting");
                        }
                        this.passUp(new Event(46));
                        return;
                    }
                }
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("FdHeader type " + hdr.type + " not known"));
                }
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.passDown(evt);
                FD_PROB fD_PROB = this;
                synchronized (fD_PROB) {
                    View v = (View)evt.getArg();
                    Vector excluded_mbrs = this.computeExcludedMembers(this.members, v.getMembers());
                    if (excluded_mbrs != null && excluded_mbrs.size() > 0) {
                        for (int i = 0; i < excluded_mbrs.size(); ++i) {
                            Address mbr = (Address)excluded_mbrs.elementAt(i);
                            FdEntry entry = (FdEntry)this.counters.get(mbr);
                            if (entry == null) continue;
                            entry.setExcluded(true);
                        }
                    }
                    Vector vector = this.members = v != null ? v.getMembers() : null;
                    if (this.members != null) {
                        int num_mbrs = this.members.size();
                        if (num_mbrs >= 2) {
                            if (this.hb == null) {
                                try {
                                    this.start();
                                }
                                catch (Exception ex) {
                                    if (this.log.isWarnEnabled()) {
                                        this.log.warn((Object)("exception when calling start(): " + ex));
                                    }
                                }
                            }
                        } else {
                            this.stop();
                        }
                    }
                    break;
                }
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    public void run() {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"heartbeat thread was started");
        }
        while (this.hb != null && this.members.size() > 1) {
            Address hb_dest = this.getHeartbeatDest();
            if (hb_dest == null) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)"hb_dest is null");
                }
                Util.sleep(this.gossip_interval);
                continue;
            }
            FdEntry entry = (FdEntry)this.counters.get(this.local_addr);
            if (entry == null) {
                entry = new FdEntry();
                this.counters.put(this.local_addr, entry);
            }
            entry.incrementCounter();
            FdHeader hdr = this.createHeader();
            if (hdr == null) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)"header could not be created. Heartbeat will not be sent");
                } else {
                    Message hb_msg = new Message(hb_dest, null, null);
                    hb_msg.putHeader(this.getName(), hdr);
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("--> HEARTBEAT to " + hb_dest));
                    }
                    this.passDown(new Event(1, hb_msg));
                }
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("own counters are " + this.printCounters()));
            }
            Enumeration e = this.counters.keys();
            while (e.hasMoreElements()) {
                long diff;
                long curr_time = System.currentTimeMillis();
                Address key = (Address)e.nextElement();
                entry = (FdEntry)this.counters.get(key);
                if (entry.getTimestamp() <= 0L || (diff = curr_time - entry.getTimestamp()) < this.timeout) continue;
                if (entry.excluded()) {
                    if (diff < 2L * this.timeout) continue;
                    this.counters.remove(key);
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.info((Object)("removed " + key));
                    continue;
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("suspecting " + key));
                }
                this.passUp(new Event(9, key));
            }
            Util.sleep(this.gossip_interval);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"heartbeat thread was stopped");
        }
    }

    Address getHeartbeatDest() {
        Address retval = null;
        if (this.members == null || this.members.size() < 2 || this.local_addr == null) {
            return null;
        }
        Vector members_copy = (Vector)this.members.clone();
        members_copy.removeElement(this.local_addr);
        int size = members_copy.size();
        int r = (int)(Math.random() * (double)(size + 1)) % size;
        retval = (Address)members_copy.elementAt(r);
        return retval;
    }

    FdHeader createHeader() {
        int num_mbrs = this.counters.size();
        int index = 0;
        FdHeader ret = null;
        if (num_mbrs <= 0) {
            return null;
        }
        ret = new FdHeader(1, num_mbrs);
        Enumeration e = this.counters.keys();
        while (e.hasMoreElements()) {
            Address key = (Address)e.nextElement();
            FdEntry entry = (FdEntry)this.counters.get(key);
            if (entry.excluded()) continue;
            if (index >= ret.members.length) {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn((Object)("index " + index + " is out of bounds (" + ret.members.length + ')'));
                break;
            }
            ret.members[index] = key;
            ret.counters[index] = entry.getCounter();
            ++index;
        }
        return ret;
    }

    void updateCounters(FdHeader hdr) {
        if (hdr == null || hdr.members == null || hdr.counters == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"hdr is null or contains no counters");
            }
            return;
        }
        for (int i = 0; i < hdr.members.length; ++i) {
            Address key = hdr.members[i];
            if (key == null) continue;
            FdEntry entry = (FdEntry)this.counters.get(key);
            if (entry == null) {
                entry = new FdEntry(hdr.counters[i]);
                this.counters.put(key, entry);
                continue;
            }
            if (entry.excluded()) continue;
            entry.setCounter(Math.max(entry.getCounter(), hdr.counters[i]));
        }
    }

    void updateCounter(Address mbr) {
        if (mbr == null) {
            return;
        }
        FdEntry entry = (FdEntry)this.counters.get(mbr);
        if (entry != null) {
            entry.setTimestamp();
        }
    }

    String printCounters() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.counters.keys();
        while (e.hasMoreElements()) {
            Address mbr = (Address)e.nextElement();
            FdEntry entry = (FdEntry)this.counters.get(mbr);
            sb.append("\n" + mbr + ": " + entry._toString());
        }
        return sb.toString();
    }

    Vector computeExcludedMembers(Vector old_mbrship, Vector new_mbrship) {
        Vector ret = new Vector();
        if (old_mbrship == null || new_mbrship == null) {
            return ret;
        }
        for (int i = 0; i < old_mbrship.size(); ++i) {
            if (new_mbrship.contains(old_mbrship.elementAt(i))) continue;
            ret.addElement(old_mbrship.elementAt(i));
        }
        return ret;
    }

    boolean checkPingerValidity(Object hb_sender) {
        int num_pings = 0;
        if (hb_sender != null && this.members != null && !this.members.contains(hb_sender)) {
            if (this.invalid_pingers.containsKey(hb_sender)) {
                num_pings = (Integer)this.invalid_pingers.get(hb_sender);
                if (num_pings >= this.max_tries) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)("sender " + hb_sender + " is not member in " + this.members + " ! Telling it to leave group"));
                    }
                    Message shun_msg = new Message((Address)hb_sender, null, null);
                    FdHeader hdr = new FdHeader(2);
                    shun_msg.putHeader(this.getName(), hdr);
                    this.passDown(new Event(1, shun_msg));
                    this.invalid_pingers.remove(hb_sender);
                } else {
                    this.invalid_pingers.put(hb_sender, new Integer(++num_pings));
                }
            } else {
                this.invalid_pingers.put(hb_sender, new Integer(++num_pings));
            }
            return false;
        }
        return true;
    }

    private static class FdEntry {
        private long counter = 0L;
        private long timestamp = 0L;
        private boolean excluded = false;

        FdEntry() {
        }

        FdEntry(long counter) {
            this.counter = counter;
            this.timestamp = System.currentTimeMillis();
        }

        long getCounter() {
            return this.counter;
        }

        long getTimestamp() {
            return this.timestamp;
        }

        boolean excluded() {
            return this.excluded;
        }

        synchronized void setCounter(long new_counter) {
            if (new_counter > this.counter) {
                this.timestamp = System.currentTimeMillis();
                this.counter = new_counter;
            }
        }

        synchronized void incrementCounter() {
            ++this.counter;
            this.timestamp = System.currentTimeMillis();
        }

        synchronized void setTimestamp() {
            this.timestamp = System.currentTimeMillis();
        }

        synchronized void setExcluded(boolean flag) {
            this.excluded = flag;
        }

        public String toString() {
            return "counter=" + this.counter + ", timestamp=" + this.timestamp + ", excluded=" + this.excluded;
        }

        public String _toString() {
            return "counter=" + this.counter + ", age=" + (System.currentTimeMillis() - this.timestamp) + ", excluded=" + this.excluded;
        }
    }

    public static class FdHeader
    extends Header {
        static final int HEARTBEAT = 1;
        static final int NOT_MEMBER = 2;
        int type = 1;
        Address[] members = null;
        long[] counters = null;

        public FdHeader() {
        }

        FdHeader(int type) {
            this.type = type;
        }

        FdHeader(int type, int num_elements) {
            this(type);
            this.members = new Address[num_elements];
            this.counters = new long[num_elements];
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "[FD_PROB: HEARTBEAT]";
                }
                case 2: {
                    return "[FD_PROB: NOT_MEMBER]";
                }
            }
            return "[FD_PROB: unknown type (" + this.type + ")]";
        }

        public String printDetails() {
            StringBuffer sb = new StringBuffer();
            if (this.members != null && this.counters != null) {
                for (int i = 0; i < this.members.length; ++i) {
                    Address mbr = this.members[i];
                    if (mbr == null) {
                        sb.append("\n<null>");
                    } else {
                        sb.append("\n" + mbr);
                    }
                    sb.append(": " + this.counters[i]);
                }
            }
            return sb.toString();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            if (this.members != null) {
                out.writeInt(this.members.length);
                out.writeObject(this.members);
            } else {
                out.writeInt(0);
            }
            if (this.counters != null) {
                out.writeInt(this.counters.length);
                for (int i = 0; i < this.counters.length; ++i) {
                    out.writeLong(this.counters[i]);
                }
            } else {
                out.writeInt(0);
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            int num = in.readInt();
            this.members = num == 0 ? null : (Address[])in.readObject();
            num = in.readInt();
            if (num == 0) {
                this.counters = null;
            } else {
                this.counters = new long[num];
                for (int i = 0; i < this.counters.length; ++i) {
                    this.counters[i] = in.readLong();
                }
            }
        }
    }
}

