/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.stack.IpAddress;
import org.jgroups.tests.stack.Utilities;
import org.jgroups.util.List;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class RouterTest
extends TestCase {
    private int routerPort = -1;
    private Random random = new Random();
    static /* synthetic */ Class class$org$jgroups$tests$stack$RouterTest;

    public RouterTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.routerPort = Utilities.startGossipRouter();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        Utilities.stopGossipRouter();
    }

    public void testEmptyGET() throws Exception {
        Socket s = new Socket("localhost", this.routerPort);
        DataInputStream dis = new DataInputStream(s.getInputStream());
        DataOutputStream dos = new DataOutputStream(s.getOutputStream());
        int len = dis.readInt();
        byte[] buffer = new byte[len];
        dis.readFully(buffer, 0, len);
        IpAddress localAddr = (IpAddress)Util.objectFromByteBuffer(buffer);
        RouterTest.assertEquals((Object)localAddr.getIpAddress(), (Object)s.getLocalAddress());
        RouterTest.assertEquals((int)localAddr.getPort(), (int)s.getLocalPort());
        dos.writeInt(-10);
        dos.writeUTF("nosuchgroup");
        len = dis.readInt();
        RouterTest.assertEquals((int)0, (int)len);
        RouterTest.assertEquals((int)-1, (int)dis.read());
        dis.close();
        dos.close();
        s.close();
    }

    public void test_REGISTER_GET() throws Exception {
        String groupName = "TESTGROUP";
        Socket s = new Socket("localhost", this.routerPort);
        DataInputStream dis = new DataInputStream(s.getInputStream());
        DataOutputStream dos = new DataOutputStream(s.getOutputStream());
        int len = dis.readInt();
        byte[] buffer = new byte[len];
        dis.readFully(buffer, 0, len);
        IpAddress localAddr = (IpAddress)Util.objectFromByteBuffer(buffer);
        RouterTest.assertEquals((Object)localAddr.getIpAddress(), (Object)s.getLocalAddress());
        RouterTest.assertEquals((int)localAddr.getPort(), (int)s.getLocalPort());
        dos.writeInt(-11);
        dos.writeUTF(groupName);
        buffer = Util.objectToByteBuffer(localAddr);
        dos.writeInt(buffer.length);
        dos.write(buffer, 0, buffer.length);
        dos.flush();
        Socket s2 = new Socket("localhost", this.routerPort);
        DataInputStream dis2 = new DataInputStream(s2.getInputStream());
        DataOutputStream dos2 = new DataOutputStream(s2.getOutputStream());
        len = dis2.readInt();
        buffer = new byte[len];
        dis2.readFully(buffer, 0, len);
        IpAddress localAddr2 = (IpAddress)Util.objectFromByteBuffer(buffer);
        RouterTest.assertEquals((Object)localAddr2.getIpAddress(), (Object)s2.getLocalAddress());
        RouterTest.assertEquals((int)localAddr2.getPort(), (int)s2.getLocalPort());
        dos2.writeInt(-10);
        dos2.writeUTF(groupName);
        len = dis2.readInt();
        buffer = new byte[len];
        dis2.readFully(buffer, 0, len);
        List groupList = (List)Util.objectFromByteBuffer(buffer);
        RouterTest.assertEquals((int)1, (int)groupList.size());
        RouterTest.assertEquals((Object)localAddr, (Object)groupList.removeFromHead());
        RouterTest.assertEquals((int)-1, (int)dis2.read());
        dis2.close();
        dos2.close();
        s2.close();
        dis.close();
        dos.close();
        s.close();
    }

    public void test_REGISTER_Route() throws Exception {
        String groupName = "TESTGROUP";
        Socket s = new Socket("localhost", this.routerPort);
        DataInputStream dis = new DataInputStream(s.getInputStream());
        DataOutputStream dos = new DataOutputStream(s.getOutputStream());
        int len = dis.readInt();
        byte[] buffer = new byte[len];
        dis.readFully(buffer, 0, len);
        IpAddress localAddr = (IpAddress)Util.objectFromByteBuffer(buffer);
        RouterTest.assertEquals((Object)localAddr.getIpAddress(), (Object)s.getLocalAddress());
        RouterTest.assertEquals((int)localAddr.getPort(), (int)s.getLocalPort());
        dos.writeInt(-11);
        dos.writeUTF(groupName);
        buffer = Util.objectToByteBuffer(localAddr);
        dos.writeInt(buffer.length);
        dos.write(buffer, 0, buffer.length);
        dos.flush();
        String payload = "THIS IS A MESSAGE PAYLOAD " + this.random.nextLong();
        Message msg = new Message(null, (Address)localAddr, (Serializable)((Object)payload));
        buffer = Util.objectToByteBuffer(msg);
        dos.writeUTF(groupName);
        dos.writeInt(0);
        dos.writeInt(buffer.length);
        dos.write(buffer, 0, buffer.length);
        len = dis.readInt();
        buffer = new byte[len];
        dis.readFully(buffer, 0, len);
        Message msgCopy = (Message)Util.objectFromByteBuffer(buffer);
        RouterTest.assertEquals((Object)msg.getSrc(), (Object)msgCopy.getSrc());
        RouterTest.assertNull((Object)msgCopy.getDest());
        RouterTest.assertEquals((Object)msg.getObject(), (Object)msgCopy.getObject());
        msg = new Message((Address)localAddr, (Address)localAddr, (Serializable)((Object)payload));
        buffer = Util.objectToByteBuffer(msg);
        dos.writeUTF(groupName);
        byte[] destAddrBuffer = Util.objectToByteBuffer(localAddr);
        dos.writeInt(destAddrBuffer.length);
        dos.write(destAddrBuffer, 0, destAddrBuffer.length);
        dos.writeInt(buffer.length);
        dos.write(buffer, 0, buffer.length);
        len = dis.readInt();
        buffer = new byte[len];
        dis.readFully(buffer, 0, len);
        msgCopy = (Message)Util.objectFromByteBuffer(buffer);
        RouterTest.assertEquals((Object)msg.getSrc(), (Object)msgCopy.getSrc());
        RouterTest.assertEquals((Object)msg.getDest(), (Object)msgCopy.getDest());
        RouterTest.assertEquals((Object)msg.getObject(), (Object)msgCopy.getObject());
        IpAddress inexistentAddress = new IpAddress("localhost", Utilities.getFreePort());
        msg = new Message((Address)inexistentAddress, (Address)localAddr, (Serializable)((Object)payload));
        buffer = Util.objectToByteBuffer(msg);
        dos.writeUTF(groupName);
        destAddrBuffer = Util.objectToByteBuffer(inexistentAddress);
        dos.writeInt(destAddrBuffer.length);
        dos.write(destAddrBuffer, 0, destAddrBuffer.length);
        dos.writeInt(buffer.length);
        dos.write(buffer, 0, buffer.length);
        dis.close();
        dos.close();
        s.close();
    }

    public void test_REGISTER_RouteStressAll() throws Exception {
        String groupName = "TESTGROUP";
        Socket s = new Socket("localhost", this.routerPort);
        final DataInputStream dis = new DataInputStream(s.getInputStream());
        final DataOutputStream dos = new DataOutputStream(s.getOutputStream());
        int len = dis.readInt();
        byte[] buffer = new byte[len];
        dis.readFully(buffer, 0, len);
        final IpAddress localAddr = (IpAddress)Util.objectFromByteBuffer(buffer);
        RouterTest.assertEquals((Object)localAddr.getIpAddress(), (Object)s.getLocalAddress());
        RouterTest.assertEquals((int)localAddr.getPort(), (int)s.getLocalPort());
        dos.writeInt(-11);
        dos.writeUTF("TESTGROUP");
        buffer = Util.objectToByteBuffer(localAddr);
        dos.writeInt(buffer.length);
        dos.write(buffer, 0, buffer.length);
        dos.flush();
        int count = 100000;
        int timeout = 120;
        final boolean[] received = new boolean[100000];
        for (int i = 0; i < 100000; ++i) {
            received[i] = false;
        }
        final Promise waitingArea = new Promise();
        long start = System.currentTimeMillis();
        new Thread(new Runnable(){

            public void run() {
                for (int i = 0; i < 100000; ++i) {
                    Message msg = new Message(null, (Address)localAddr, new Integer(i));
                    try {
                        byte[] buffer = Util.objectToByteBuffer(msg);
                        dos.writeUTF("TESTGROUP");
                        dos.writeInt(0);
                        dos.writeInt(buffer.length);
                        dos.write(buffer, 0, buffer.length);
                        dos.flush();
                        continue;
                    }
                    catch (Exception e) {
                        waitingArea.setResult(e);
                    }
                }
            }
        }, "Sending Thread").start();
        new Thread(new Runnable(){

            public void run() {
                int cnt = 0;
                while (cnt < 100000) {
                    try {
                        int len = dis.readInt();
                        byte[] buffer = new byte[len];
                        dis.readFully(buffer, 0, len);
                        Message msg = (Message)Util.objectFromByteBuffer(buffer);
                        int index = (Integer)msg.getObject();
                        received[index] = true;
                        ++cnt;
                    }
                    catch (Exception e) {
                        waitingArea.setResult(e);
                    }
                }
                waitingArea.setResult(Boolean.TRUE);
            }
        }, "Receiving Thread").start();
        Object result = waitingArea.getResult((long)timeout * 1000L);
        long stop = System.currentTimeMillis();
        dis.close();
        dos.close();
        s.close();
        int messok = 0;
        for (int i = 0; i < 100000; ++i) {
            if (!received[i]) continue;
            ++messok;
        }
        if (result == null) {
            RouterTest.fail((String)("Timeout while waiting for all messages to be received. " + messok + " messages out of " + 100000 + " received so far."));
        }
        if (result instanceof Exception) {
            throw (Exception)result;
        }
        boolean success = true;
        for (int i = 0; i < 100000; ++i) {
            if (received[i]) continue;
            RouterTest.fail((String)("At least message " + i + " NOT RECEIVED"));
        }
        System.out.println("STRESS TEST OK, 100000 messages, " + 100000000L / (stop - start) + " messages/sec");
    }

    public static Test suite() {
        TestSuite s = new TestSuite(class$org$jgroups$tests$stack$RouterTest == null ? (class$org$jgroups$tests$stack$RouterTest = RouterTest.class$("org.jgroups.tests.stack.RouterTest")) : class$org$jgroups$tests$stack$RouterTest);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RouterTest.suite());
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

