/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.tests.TestMessage;

public class JGroupsSender {
    static final String COMPONENT = "JGroupsSender";
    static Logger logger = Logger.getLogger("JGroupsSender");
    private JChannel channel;
    private String channelName = "XXX";
    private long sendDelay;
    private String testFileName;
    private int msgSize;

    public JGroupsSender(String props, int msgSize, long sendDelay, String filename) {
        this.msgSize = msgSize;
        this.sendDelay = sendDelay;
        this.testFileName = filename;
        logger.log(Level.INFO, "Initialize sender");
        try {
            this.channel = new JChannel(props);
            this.channel.setOpt(5, new Boolean(true));
            this.channel.setOpt(3, new Boolean(false));
            logger.log(Level.INFO, "Going into sender mode");
            this.channel.connect(this.channelName);
        }
        catch (ChannelException e) {
            logger.log(Level.SEVERE, e.toString());
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() {
        TestMessage tmsg = new TestMessage();
        long msgNumber = 0L;
        byte[] messageContent = null;
        InputStream in = this.openTestFile();
        try {
            while (true) {
                if ((messageContent = this.getNextChunk(in)) == null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                    continue;
                    finally {
                        in = this.openTestFile();
                        continue;
                    }
                }
                logger.log(Level.INFO, "Sending Message[" + msgNumber + "], incoming queue=" + this.channel.getNumMessages());
                tmsg.setSeqNumber(msgNumber);
                tmsg.setContent(messageContent);
                this.channel.send(new Message(null, null, tmsg));
                Thread.sleep(this.sendDelay);
                ++msgNumber;
            }
        }
        catch (ChannelNotConnectedException e) {
            logger.log(Level.SEVERE, e.toString());
        }
        catch (ChannelClosedException e) {
            logger.log(Level.SEVERE, e.toString());
        }
        catch (InterruptedException e) {
        }
    }

    private InputStream openTestFile() {
        FileInputStream testFile = null;
        try {
            testFile = new FileInputStream(this.testFileName);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Couldn't open file:" + this.testFileName);
        }
        return testFile;
    }

    private byte[] getNextChunk(InputStream in) {
        byte[] buffer = new byte[this.msgSize];
        try {
            int readBytes = in.read(buffer);
            if (readBytes == -1) {
                return null;
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Couldn't read the test data file: " + e);
            return null;
        }
        return buffer;
    }

    public void receive(boolean test) {
        new Thread(){

            public void run() {
                JGroupsSender.this.receiveLoop();
            }
        }.start();
    }

    public void receiveLoop() {
        Object obj = null;
        Message msg = null;
        while (true) {
            try {
                while (true) {
                    if ((obj = this.channel.receive(0L)) == null) {
                        return;
                    }
                    if (!(obj instanceof Message)) {
                        return;
                    }
                    msg = (Message)obj;
                    logger.log(Level.FINEST, "Descarding message: " + msg.toString());
                }
            }
            catch (ChannelNotConnectedException e) {
                logger.log(Level.SEVERE, e.toString());
            }
            catch (ChannelClosedException e) {
                logger.log(Level.SEVERE, e.toString());
            }
            catch (TimeoutException e) {
                logger.log(Level.SEVERE, "Timeout in the receive: " + e.toString());
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        String props = null;
        long sendDelay = 10L;
        int msgSize = 40000;
        String filename = "c:\\testfile.dat";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-sendDelay")) {
                sendDelay = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-msgSize")) {
                msgSize = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-file")) {
                filename = args[++i];
                continue;
            }
            System.out.println("JGroupsSender [-props <props>] [-msgSize <size in bytes>] [-sendDelay <delay in ms>] [-file <filename>");
            return;
        }
        JGroupsSender sender = new JGroupsSender(props, msgSize, sendDelay, filename);
        sender.send();
    }
}

