/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.jgroups.util.TimedWriter;
import org.jgroups.util.Util;

public class Link
implements Runnable {
    String local_addr = null;
    String remote_addr = null;
    InetAddress local = null;
    InetAddress remote = null;
    int local_port = 0;
    int remote_port = 0;
    ServerSocket srv_sock = null;
    Socket outgoing = null;
    Socket incoming = null;
    DataOutputStream outstream = null;
    DataInputStream instream = null;
    boolean established = false;
    boolean stop = false;
    boolean trace = false;
    Thread receiver_thread = null;
    long receiver_thread_join_timeout = 2000L;
    Receiver receiver = null;
    final int HB_PACKET = -99;
    Heartbeat hb = null;
    long timeout = 10000L;
    long hb_interval = 3000L;
    Object outgoing_mutex = new Object();
    TimedWriter writer = null;

    public Link(String local_addr, int local_port, String remote_addr, int remote_port) {
        this.local_addr = local_addr;
        this.local_port = local_port;
        this.remote_addr = remote_addr;
        this.remote_port = remote_port;
        this.hb = new Heartbeat(this.timeout, this.hb_interval);
    }

    public Link(String local_addr, int local_port, String remote_addr, int remote_port, Receiver r) {
        this(local_addr, local_port, remote_addr, remote_port);
        this.setReceiver(r);
    }

    public Link(String local_addr, int local_port, String remote_addr, int remote_port, long timeout, long hb_interval, Receiver r) {
        this.local_addr = local_addr;
        this.local_port = local_port;
        this.remote_addr = remote_addr;
        this.remote_port = remote_port;
        this.timeout = timeout;
        this.hb_interval = hb_interval;
        this.hb = new Heartbeat(timeout, hb_interval);
        this.setReceiver(r);
    }

    public void setTrace(boolean t) {
        this.trace = t;
    }

    public void setReceiver(Receiver r) {
        this.receiver = r;
    }

    public boolean established() {
        return this.established;
    }

    public InetAddress getLocalAddress() {
        return this.local;
    }

    public InetAddress getRemoteAddress() {
        return this.remote;
    }

    public int getLocalPort() {
        return this.local_port;
    }

    public int getRemotePort() {
        return this.remote_port;
    }

    public void start() throws Exception {
        this.local = InetAddress.getByName(this.local_addr);
        this.remote = InetAddress.getByName(this.remote_addr);
        this.srv_sock = new ServerSocket(this.local_port, 1, this.local);
        this.createOutgoingConnection(this.hb_interval);
        this.startReceiverThread();
        this.hb.start();
    }

    public void stop() {
        this.stopReceiverThread();
        this.hb.stop();
        try {
            this.srv_sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.established = false;
    }

    public boolean send(byte[] buf) {
        if (buf == null || buf.length == 0) {
            if (this.trace) {
                System.err.println("Link.send(): buffer is null or does not contain any data !");
            }
            return false;
        }
        if (!this.established) {
            if (this.trace) {
                System.err.println("Link.send(): connection not established, discarding message");
            }
            return false;
        }
        try {
            this.outstream.writeInt(buf.length);
            this.outstream.write(buf);
            return true;
        }
        catch (Exception ex) {
            if (this.trace) {
                System.err.println("Link.send1(): sending failed; retrying");
            }
            return this.retry(buf);
        }
    }

    boolean retry(byte[] buf) {
        this.closeOutgoingConnection();
        if (!this.createOutgoingConnection()) {
            this.closeOutgoingConnection();
            return false;
        }
        try {
            this.outstream.writeInt(buf.length);
            this.outstream.write(buf);
            return true;
        }
        catch (Exception e) {
            if (this.trace) {
                System.out.println("Link.send2(): failed, closing connection");
            }
            this.closeOutgoingConnection();
            return false;
        }
    }

    public void run() {
        InetAddress peer = null;
        int peer_port = 0;
        block5: while (!this.stop) {
            try {
                if (this.trace) {
                    System.out.println("-- WAITING for ACCEPT");
                }
                this.incoming = this.srv_sock.accept();
                this.instream = new DataInputStream(this.incoming.getInputStream());
                peer = this.incoming.getInetAddress();
                peer_port = this.incoming.getPort();
                if (this.trace) {
                    System.out.println("-- ACCEPT: incoming is " + this.printSocket(this.incoming));
                }
                if (this.remote.equals(this.incoming.getInetAddress())) {
                    if (this.trace) {
                        System.out.println("Link.run(): accepted connection from " + peer + ':' + peer_port);
                    }
                } else {
                    if (this.trace) {
                        System.err.println("Link.run(): rejected connection request from " + peer + ':' + peer_port + ". Address not specified as peer in link !");
                    }
                    this.closeIncomingConnection();
                    continue;
                }
                if (!this.established) {
                    this.createOutgoingConnection();
                }
                while (!this.stop) {
                    try {
                        int num_bytes = this.instream.readInt();
                        if (num_bytes == -99) {
                            this.hb.receivedHeartbeat();
                            continue;
                        }
                        byte[] buf = new byte[num_bytes];
                        this.instream.readFully(buf, 0, buf.length);
                        this.hb.receivedMessage();
                        if (this.receiver == null) continue;
                        this.receiver.receive(buf);
                    }
                    catch (Exception ex) {
                        this.closeIncomingConnection();
                        continue block5;
                    }
                }
            }
            catch (IOException io_ex) {
                this.receiver_thread = null;
                break;
            }
            catch (Exception e) {
            }
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("Link <" + this.local_addr + ':' + this.local_port + " --> " + this.remote_addr + ':' + this.remote_port + '>');
        ret.append(this.established ? " (established)" : " (not established)");
        return ret.toString();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Link)) {
            return false;
        }
        Link o = (Link)other;
        return this.local_addr.equals(o.local_addr) && this.remote_addr.equals(o.remote_addr) && this.local_port == o.local_port && this.remote_port == o.remote_port;
    }

    public int hashCode() {
        return this.local_addr.hashCode() + this.remote_addr.hashCode() + this.local_port + this.remote_port;
    }

    void startReceiverThread() {
        this.stopReceiverThread();
        this.receiver_thread = new Thread((Runnable)this, "Link.ReceiverThreadThread");
        this.receiver_thread.setDaemon(true);
        this.receiver_thread.start();
    }

    void stopReceiverThread() {
        if (this.receiver_thread != null && this.receiver_thread.isAlive()) {
            this.stop = true;
            this.closeIncomingConnection();
            try {
                this.receiver_thread.join(this.receiver_thread_join_timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.stop = false;
        }
        this.receiver_thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean createOutgoingConnection() {
        Object object = this.outgoing_mutex;
        synchronized (object) {
            if (this.established) {
                return true;
            }
            try {
                this.outgoing = new Socket(this.remote, this.remote_port, this.local, 0);
                this.outgoing.setSoLinger(true, 1);
                this.outstream = new DataOutputStream(this.outgoing.getOutputStream());
                if (this.receiver != null) {
                    this.receiver.linkUp(this.local, this.local_port, this.remote, this.remote_port);
                }
                this.established = true;
                if (this.trace) {
                    System.out.println("-- CREATE: outgoing is " + this.printSocket(this.outgoing));
                }
                return true;
            }
            catch (Exception e) {
                this.established = false;
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean createOutgoingConnection(long timeout) {
        Object object = this.outgoing_mutex;
        synchronized (object) {
            if (this.established) {
                return true;
            }
            try {
                if (this.writer == null) {
                    this.writer = new TimedWriter();
                }
                this.outgoing = this.writer.createSocket(this.local, this.remote, this.remote_port, timeout);
                this.outgoing.setSoLinger(true, 1);
                this.outstream = new DataOutputStream(this.outgoing.getOutputStream());
                if (this.receiver != null) {
                    this.receiver.linkUp(this.local, this.local_port, this.remote, this.remote_port);
                }
                this.established = true;
                if (this.trace) {
                    System.out.println("-- CREATE: outgoing is " + this.printSocket(this.outgoing));
                }
                return true;
            }
            catch (Exception e) {
                this.established = false;
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeOutgoingConnection() {
        Object object = this.outgoing_mutex;
        synchronized (object) {
            if (!this.established) {
                return;
            }
            if (this.outstream != null) {
                if (this.trace) {
                    System.out.println("-- CLOSE: outgoing is " + this.printSocket(this.outgoing));
                }
                try {
                    this.outstream.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.outstream = null;
            }
            if (this.outgoing != null) {
                try {
                    this.outgoing.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.outgoing = null;
            }
            this.established = false;
            if (this.receiver != null) {
                this.receiver.linkDown(this.local, this.local_port, this.remote, this.remote_port);
            }
        }
    }

    synchronized void closeIncomingConnection() {
        if (this.instream != null) {
            if (this.trace) {
                System.out.println("-- CLOSE: incoming is " + this.printSocket(this.incoming));
            }
            try {
                this.instream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.instream = null;
        }
        if (this.incoming != null) {
            try {
                this.incoming.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.incoming = null;
        }
    }

    synchronized void closeConnections() {
        this.closeOutgoingConnection();
        this.closeIncomingConnection();
    }

    String printSocket(Socket s) {
        if (s == null) {
            return "<null>";
        }
        StringBuffer ret = new StringBuffer();
        ret.append(s.getLocalAddress().getHostName());
        ret.append(':');
        ret.append(s.getLocalPort());
        ret.append(" --> ");
        ret.append(s.getInetAddress().getHostName());
        ret.append(':');
        ret.append(s.getPort());
        return ret.toString();
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.err.println("\nLink <local host> <local port> <remote host> <remote port>\n");
            return;
        }
        String local = args[0];
        String remote = args[2];
        int local_port = Integer.parseInt(args[1]);
        int remote_port = Integer.parseInt(args[3]);
        Link l = new Link(local, local_port, remote, remote_port, new MyReceiver());
        try {
            l.start();
            System.out.println(l);
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                System.out.print("> ");
                System.out.flush();
                String line = in.readLine();
                l.send(line.getBytes());
            }
        }
        catch (Exception e) {
            System.err.println(e);
            return;
        }
    }

    private static class MyReceiver
    implements Receiver {
        private MyReceiver() {
        }

        public void receive(byte[] msg) {
            System.out.println("<-- " + new String(msg));
        }

        public void linkDown(InetAddress l, int lp, InetAddress r, int rp) {
            System.out.println("** linkDown(): " + r + ':' + rp);
        }

        public void linkUp(InetAddress l, int lp, InetAddress r, int rp) {
            System.out.println("** linkUp(): " + r + ':' + rp);
        }

        public void missedHeartbeat(InetAddress l, int lp, InetAddress r, int rp, int num) {
            System.out.println("** missedHeartbeat(): " + r + ':' + rp);
        }

        public void receivedHeartbeatAgain(InetAddress l, int lp, InetAddress r, int rp) {
            System.out.println("** receivedHeartbeatAgain(): " + r + ':' + rp);
        }
    }

    class Heartbeat
    implements Runnable {
        Thread thread = null;
        long timeout = 10000L;
        long hb_interval = 3000L;
        boolean stop_hb = false;
        long last_hb = System.currentTimeMillis();
        boolean missed_hb = false;
        TimedWriter writer = new TimedWriter();

        public Heartbeat(long timeout, long hb_interval) {
            this.timeout = timeout;
            this.hb_interval = hb_interval;
        }

        public synchronized void start() {
            this.stop();
            this.stop_hb = false;
            this.missed_hb = false;
            this.last_hb = System.currentTimeMillis();
            this.thread = new Thread((Runnable)this, "HeartbeatThread");
            this.thread.setDaemon(true);
            this.thread.start();
        }

        public synchronized void interrupt() {
            this.thread.interrupt();
        }

        public synchronized void stop() {
            if (this.thread != null && this.thread.isAlive()) {
                this.stop_hb = true;
                this.missed_hb = false;
                this.thread.interrupt();
                try {
                    this.thread.join(this.timeout + 1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.thread = null;
            }
        }

        public void receivedMessage() {
            this.last_hb = System.currentTimeMillis();
            if (this.missed_hb) {
                if (Link.this.receiver != null) {
                    Link.this.receiver.receivedHeartbeatAgain(Link.this.local, Link.this.local_port, Link.this.remote, Link.this.remote_port);
                }
                this.missed_hb = false;
            }
        }

        public void receivedHeartbeat() {
            this.last_hb = System.currentTimeMillis();
            if (this.missed_hb) {
                if (Link.this.receiver != null) {
                    Link.this.receiver.receivedHeartbeatAgain(Link.this.local, Link.this.local_port, Link.this.remote, Link.this.remote_port);
                }
                this.missed_hb = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long diff = 0L;
            long curr_time = 0L;
            long num_missed_hbs = 0L;
            if (Link.this.trace) {
                System.out.println("heartbeat to " + Link.this.remote + ':' + Link.this.remote_port + " started");
            }
            while (!this.stop_hb) {
                if (Link.this.established) {
                    block19: {
                        if (Link.this.outstream != null) {
                            try {
                                this.writer.write((OutputStream)Link.this.outstream, -99, 1500L);
                                Thread.sleep(this.hb_interval);
                                break block19;
                            }
                            catch (Exception io_ex) {
                                Link.this.closeOutgoingConnection();
                                continue;
                            }
                        }
                        Link.this.established = false;
                        continue;
                    }
                    curr_time = System.currentTimeMillis();
                    diff = curr_time - this.last_hb;
                    if (curr_time - this.last_hb > this.hb_interval) {
                        num_missed_hbs = (curr_time - this.last_hb) / this.hb_interval;
                        if (Link.this.receiver != null) {
                            Link.this.receiver.missedHeartbeat(Link.this.local, Link.this.local_port, Link.this.remote, Link.this.remote_port, (int)num_missed_hbs);
                        }
                        this.missed_hb = true;
                    }
                    if (diff < this.timeout) continue;
                    if (Link.this.trace) {
                        System.out.println("###### Link.Heartbeat.run(): no heartbeat receveived for " + diff + " msecs. Closing connections. #####");
                    }
                    Link.this.closeConnections();
                    continue;
                }
                Object object = Link.this.outgoing_mutex;
                synchronized (object) {
                    if (Link.this.established) {
                        continue;
                    }
                    try {
                        Link.this.outgoing = this.writer.createSocket(Link.this.local, Link.this.remote, Link.this.remote_port, this.hb_interval);
                        Link.this.outstream = new DataOutputStream(Link.this.outgoing.getOutputStream());
                        if (Link.this.receiver != null) {
                            Link.this.receiver.linkUp(Link.this.local, Link.this.local_port, Link.this.remote, Link.this.remote_port);
                        }
                        Link.this.established = true;
                        if (Link.this.trace) {
                            System.out.println("-- CREATE (CE): " + Link.this.printSocket(Link.this.outgoing));
                        }
                    }
                    catch (InterruptedException interrupted_ex) {
                    }
                    catch (Exception ex) {
                        Util.sleep(this.hb_interval);
                    }
                }
            }
            if (Link.this.trace) {
                System.out.println("heartbeat to " + Link.this.remote + ':' + Link.this.remote_port + " stopped");
            }
            this.thread = null;
        }
    }

    public static interface Receiver {
        public void receive(byte[] var1);

        public void linkDown(InetAddress var1, int var2, InetAddress var3, int var4);

        public void linkUp(InetAddress var1, int var2, InetAddress var3, int var4);

        public void missedHeartbeat(InetAddress var1, int var2, InetAddress var3, int var4, int var5);

        public void receivedHeartbeatAgain(InetAddress var1, int var2, InetAddress var3, int var4);
    }
}

