/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.jetty.servlet.XMLConfiguration;
import org.mortbay.jndi.Util;
import org.mortbay.util.TypeUtil;
import org.mortbay.xml.XmlParser;

public class PlusWebAppContext
extends WebApplicationContext {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$jetty$plus$PlusWebAppContext == null ? (class$org$mortbay$jetty$plus$PlusWebAppContext = PlusWebAppContext.class$("org.mortbay.jetty.plus.PlusWebAppContext")) : class$org$mortbay$jetty$plus$PlusWebAppContext));
    private InitialContext _initialCtx = null;
    private HashMap _envMap = null;
    private ClassLoader _removeClassLoader = null;
    private boolean _webXmlEnvEntryOverride = true;
    static /* synthetic */ Class class$org$mortbay$jetty$plus$PlusWebAppContext;

    public PlusWebAppContext() {
    }

    public PlusWebAppContext(String webApp) {
        super(webApp);
    }

    public void setWebXmlEnvEntryOverride(boolean value) {
        this._webXmlEnvEntryOverride = value;
    }

    public boolean getWebXmlEnvEntryOverride() {
        return this._webXmlEnvEntryOverride;
    }

    public void addEnvEntry(String name, Object value) {
        if (this._envMap == null) {
            this._envMap = new HashMap();
        }
        if (name == null) {
            log.warn((Object)"Name for java:comp/env is null. Ignoring.");
        }
        if (value == null) {
            log.warn((Object)"Value for java:comp/env is null. Ignoring.");
        }
        this._envMap.put(name, value);
    }

    public Object getEnvEntry(String name) {
        if (this._envMap == null) {
            return null;
        }
        return this._envMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getENC() throws NamingException {
        Thread thread = Thread.currentThread();
        ClassLoader lastContextLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClassLoader());
        Map map = null;
        try {
            map = Util.flattenBindings((Context)this._initialCtx.lookup("java:comp"), "env");
        }
        finally {
            thread.setContextClassLoader(lastContextLoader);
        }
        return map;
    }

    public void doStart() throws Exception {
        this._initialCtx = new InitialContext();
        super.doStart();
    }

    public void handle(HttpRequest request, HttpResponse response) throws HttpException, IOException {
        super.handle(request, response);
    }

    protected void initialize() throws Exception {
        Context compCtx = (Context)this._initialCtx.lookup("java:comp");
        Context envCtx = compCtx.createSubcontext("env");
        if (log.isTraceEnabled()) {
            log.trace((Object)envCtx);
        }
        compCtx.rebind("UserTransaction", (Object)new LinkRef("javax.transaction.UserTransaction"));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Bound ref to javax.transaction.UserTransaction to java:comp/UserTransaction");
        }
        if (this._envMap != null) {
            Iterator it = this._envMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Util.bind(envCtx, (String)entry.getKey(), entry.getValue());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Bound java:comp/env/" + entry.getKey() + " to " + entry.getValue()));
            }
        }
    }

    protected void initClassLoader(boolean forceContextLoader) throws MalformedURLException, IOException {
        ClassLoader cl = this.getClassLoader();
        super.initClassLoader(forceContextLoader);
        if (cl == null || this.getClassLoader() != cl) {
            this._removeClassLoader = this.getClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() throws Exception {
        try {
            super.doStop();
        }
        finally {
            this._removeClassLoader = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Configuration
    extends XMLConfiguration {
        public PlusWebAppContext getPlusWebAppContext() {
            return (PlusWebAppContext)this.getWebApplicationContext();
        }

        protected void initWebXmlElement(String element, XmlParser.Node node) throws Exception {
            Context envCtx = (Context)this.getPlusWebAppContext()._initialCtx.lookup("java:comp/env");
            if ("env-entry".equals(element)) {
                String name = node.getString("env-entry-name", false, true);
                Object value = TypeUtil.valueOf((String)node.getString("env-entry-type", false, true), (String)node.getString("env-entry-value", false, true));
                try {
                    Object o = envCtx.lookup(name);
                    if (((PlusWebAppContext)this.getWebApplicationContext()).getWebXmlEnvEntryOverride()) {
                        Util.bind(envCtx, name, value);
                    }
                }
                catch (NameNotFoundException e) {
                    Util.bind(envCtx, name, value);
                }
            } else if ("resource-ref".equals(element)) {
                String name = node.getString("res-ref-name", false, true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Linking resource-ref java:comp/env/" + name + " to global " + name));
                }
                Object o = this.getPlusWebAppContext()._initialCtx.lookup(name);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found Object in global namespace: " + o.toString()));
                }
                Util.bind(envCtx, name, new LinkRef(name));
            } else if ("resource-env-ref".equals(element)) {
                String name = node.getString("resource-env-ref-name", false, true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Linking resource-env-ref java:comp/env/" + name + " to global " + name));
                }
                Util.bind(envCtx, name, new LinkRef(name));
            } else if ("ejb-ref".equals(element) || "ejb-local-ref".equals(element) || "security-domain".equals(element)) {
                log.warn((Object)("Entry " + element + " => " + node + " is not supported yet"));
            } else {
                super.initWebXmlElement(element, node);
            }
        }
    }
}

