/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus;

import java.io.IOException;
import java.net.MalformedURLException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.jetty.servlet.XMLConfiguration;
import org.mortbay.jndi.Util;
import org.mortbay.log4j.CRS;
import org.mortbay.util.LogSupport;
import org.mortbay.util.TypeUtil;
import org.mortbay.xml.XmlParser;

public class PlusWebAppContext
extends WebApplicationContext {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$jetty$plus$PlusWebAppContext == null ? (class$org$mortbay$jetty$plus$PlusWebAppContext = PlusWebAppContext.class$("org.mortbay.jetty.plus.PlusWebAppContext")) : class$org$mortbay$jetty$plus$PlusWebAppContext));
    private InitialContext _initialCtx = null;
    private ClassLoader _removeClassLoader = null;
    static /* synthetic */ Class class$org$mortbay$jetty$plus$PlusWebAppContext;

    public PlusWebAppContext() {
        this.setConfiguration((WebApplicationContext.Configuration)new Configuration(this));
    }

    public PlusWebAppContext(String webApp) {
        super(webApp);
        this.setConfiguration((WebApplicationContext.Configuration)new Configuration(this));
    }

    public void start() throws Exception {
        this._initialCtx = new InitialContext();
        super.start();
    }

    public void handle(HttpRequest request, HttpResponse response) throws HttpException, IOException {
        super.handle(request, response);
    }

    protected void initialize() throws Exception {
        Context compCtx = (Context)this._initialCtx.lookup("java:comp");
        Context envCtx = compCtx.createSubcontext("env");
        if (LogSupport.isTraceEnabled((Log)log)) {
            log.trace((Object)envCtx);
        }
        compCtx.rebind("UserTransaction", (Object)new LinkRef("javax.transaction.UserTransaction"));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Bound ref to javax.transaction.UserTransaction to java:comp/UserTransaction");
        }
    }

    protected void initClassLoader(boolean forceContextLoader) throws MalformedURLException, IOException {
        ClassLoader cl = this.getClassLoader();
        super.initClassLoader(forceContextLoader);
        if (cl == null || this.getClassLoader() != cl) {
            this._removeClassLoader = this.getClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        try {
            super.stop();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            CRS.remove(this._removeClassLoader);
            this._removeClassLoader = null;
            throw throwable;
        }
        CRS.remove(this._removeClassLoader);
        this._removeClassLoader = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Configuration
    extends XMLConfiguration {
        public Configuration(WebApplicationContext context) {
            super(context);
        }

        public PlusWebAppContext getPlusWebAppContext() {
            return (PlusWebAppContext)this.getWebApplicationContext();
        }

        protected void initWebXmlElement(String element, XmlParser.Node node) throws Exception {
            Context envCtx = (Context)this.getPlusWebAppContext()._initialCtx.lookup("java:comp/env");
            if ("env-entry".equals(element)) {
                String name = node.getString("env-entry-name", false, true);
                Object value = TypeUtil.valueOf((String)node.getString("env-entry-type", false, true), (String)node.getString("env-entry-value", false, true));
                Util.bind(envCtx, name, value);
            } else if ("resource-ref".equals(element)) {
                String name = node.getString("res-ref-name", false, true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Linking resource-ref java:comp/env/" + name + " to global " + name));
                }
                Object o = this.getPlusWebAppContext()._initialCtx.lookup(name);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found Object in global namespace: " + o.toString()));
                }
                Util.bind(envCtx, name, new LinkRef(name));
            } else if ("resource-env-ref".equals(element)) {
                String name = node.getString("resource-env-ref-name", false, true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Linking resource-env-ref java:comp/env/" + name + " to global " + name));
                }
                Util.bind(envCtx, name, new LinkRef(name));
            } else if ("ejb-ref".equals(element) || "ejb-local-ref".equals(element) || "security-domain".equals(element)) {
                log.warn((Object)("Entry " + element + " => " + node + " is not supported yet"));
            } else {
                super.initWebXmlElement(element, node);
            }
        }
    }
}

