/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jndi;

import java.util.HashMap;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.mortbay.util.Code;

public class Util {
    public static void bind(Context ctx, String nameStr, Object obj) throws NamingException {
        Name name = ctx.getNameParser("").parse(nameStr);
        if (name.size() == 0) {
            return;
        }
        Context subCtx = ctx;
        for (int i = 0; i < name.size() - 1; ++i) {
            try {
                subCtx = (Context)subCtx.lookup(name.get(i));
                Code.debug((String)("Subcontext " + name.get(i) + " already exists"));
                continue;
            }
            catch (NameNotFoundException e) {
                subCtx = subCtx.createSubcontext(name.get(i));
                Code.debug((String)("Subcontext " + name.get(i) + " created"));
            }
        }
        subCtx.rebind(name.get(name.size() - 1), obj);
        Code.debug((String)("Bound object to " + name.get(name.size() - 1)));
    }

    public static Map flattenBindings(Context ctx, String name) throws NamingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Context c = (Context)ctx.lookup(name);
        NameParser parser = c.getNameParser("");
        NamingEnumeration<Binding> namingEnumeration = ctx.listBindings(name);
        while (namingEnumeration.hasMore()) {
            Binding b = namingEnumeration.next();
            if (b.getObject() instanceof Context) {
                map.putAll(Util.flattenBindings(c, b.getName()));
                continue;
            }
            Name compoundName = parser.parse(c.getNameInNamespace());
            compoundName.add(b.getName());
            map.put(compoundName.toString(), b.getObject());
        }
        return map;
    }
}

