/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.ha.spi;

import com.sun.appserv.ha.spi.DuplicateFactoryRegistrationException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackingStoreRegistry {
    private static BackingStoreRegistry _instance = new BackingStoreRegistry();
    private Map<String, String> factories = new ConcurrentHashMap<String, String>();

    private BackingStoreRegistry() {
    }

    public static BackingStoreRegistry getInstance() {
        return _instance;
    }

    public void registerFactory(String type, String factoryClassName) throws DuplicateFactoryRegistrationException {
        if (this.factories.get(type) != null) {
            throw new DuplicateFactoryRegistrationException("Duplicate factory class (" + factoryClassName + ") for type: " + type);
        }
        this.factories.put(type, factoryClassName);
    }

    public void removeFactory(String type) {
        this.factories.remove(type);
    }

    public String getFactoryClassName(String type) {
        return this.factories.get(type);
    }

    public Collection<String> getRegisteredTypes() {
        return this.factories.keySet();
    }
}

