/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import org.mortbay.util.ByteArrayOutputStream2;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiMap;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.Utf8StringBuffer;

public class UrlEncoded
extends MultiMap {
    public UrlEncoded(UrlEncoded url) {
        super((Map)url);
    }

    public UrlEncoded() {
        super(6);
    }

    public UrlEncoded(String s) {
        super(6);
        this.decode(s, "UTF-8");
    }

    public UrlEncoded(String s, String charset) {
        super(6);
        this.decode(s, charset);
    }

    public void decode(String query) {
        UrlEncoded.decodeTo(query, (MultiMap)this, "UTF-8");
    }

    public void decode(String query, String charset) {
        UrlEncoded.decodeTo(query, (MultiMap)this, charset);
    }

    public String encode() {
        return this.encode("UTF-8", false);
    }

    public String encode(String charset) {
        return this.encode(charset, false);
    }

    public synchronized String encode(String charset, boolean equalsForNullValue) {
        return UrlEncoded.encode(this, charset, equalsForNullValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encode(MultiMap map, String charset, boolean equalsForNullValue) {
        StringBuffer result;
        if (charset == null) {
            charset = "UTF-8";
        }
        StringBuffer stringBuffer = result = new StringBuffer(128);
        synchronized (stringBuffer) {
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = entry.getKey().toString();
                Object list = entry.getValue();
                int s = LazyList.size(list);
                if (s == 0) {
                    result.append(UrlEncoded.encodeString(key, charset));
                    if (equalsForNullValue) {
                        result.append('=');
                    }
                } else {
                    for (int i = 0; i < s; ++i) {
                        if (i > 0) {
                            result.append('&');
                        }
                        Object val = LazyList.get(list, i);
                        result.append(UrlEncoded.encodeString(key, charset));
                        if (val != null) {
                            String str = val.toString();
                            if (str.length() > 0) {
                                result.append('=');
                                result.append(UrlEncoded.encodeString(str, charset));
                                continue;
                            }
                            if (!equalsForNullValue) continue;
                            result.append('=');
                            continue;
                        }
                        if (!equalsForNullValue) continue;
                        result.append('=');
                    }
                }
                if (!iter.hasNext()) continue;
                result.append('&');
            }
            return result.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(String content, MultiMap map, String charset) {
        if (charset == null) {
            charset = "UTF-8";
        }
        MultiMap multiMap = map;
        synchronized (multiMap) {
            String key = null;
            String value = null;
            int mark = -1;
            boolean encoded = false;
            block9: for (int i = 0; i < content.length(); ++i) {
                char c = content.charAt(i);
                switch (c) {
                    case '&': {
                        value = encoded ? UrlEncoded.decodeString(content, mark + 1, i - mark - 1, charset) : content.substring(mark + 1, i);
                        mark = i;
                        encoded = false;
                        if (key != null) {
                            map.add(key, value);
                            key = null;
                            value = null;
                            continue block9;
                        }
                        if (value == null) continue block9;
                        map.add(value, null);
                        value = null;
                        continue block9;
                    }
                    case '=': {
                        if (key != null) continue block9;
                        key = encoded ? UrlEncoded.decodeString(content, mark + 1, i - mark - 1, charset) : content.substring(mark + 1, i);
                        mark = i;
                        encoded = false;
                        continue block9;
                    }
                    case '+': {
                        encoded = true;
                        continue block9;
                    }
                    case '%': {
                        encoded = true;
                    }
                }
            }
            if (key != null) {
                value = encoded ? UrlEncoded.decodeString(content, mark + 1, content.length() - mark - 1, charset) : content.substring(mark + 1);
                map.add(key, value);
            } else if (mark < content.length()) {
                key = encoded ? UrlEncoded.decodeString(content, mark + 1, content.length() - mark - 1, charset) : content.substring(mark + 1);
                map.add(key, "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeUtf8To(byte[] raw, int offset, int length, MultiMap map) {
        MultiMap multiMap = map;
        synchronized (multiMap) {
            Utf8StringBuffer buffer = new Utf8StringBuffer();
            String key = null;
            String value = null;
            int end = offset + length;
            block9: for (int i = offset; i < end; ++i) {
                byte b = raw[i];
                switch ((char)(0xFF & b)) {
                    case '&': {
                        value = buffer.length() == 0 ? null : buffer.toString();
                        buffer.reset();
                        if (key != null) {
                            map.add(key, value);
                            key = null;
                            value = null;
                            continue block9;
                        }
                        if (value == null) continue block9;
                        map.add(value, null);
                        value = null;
                        continue block9;
                    }
                    case '=': {
                        if (key != null) {
                            buffer.append(b);
                            continue block9;
                        }
                        key = buffer.toString();
                        buffer.reset();
                        continue block9;
                    }
                    case '+': {
                        buffer.append((byte)32);
                        continue block9;
                    }
                    case '%': {
                        if (i + 2 >= end) continue block9;
                        buffer.append((byte)((TypeUtil.convertHexDigit(raw[++i]) << 4) + TypeUtil.convertHexDigit(raw[++i])));
                        continue block9;
                    }
                    default: {
                        buffer.append(b);
                    }
                }
            }
            if (key != null) {
                value = buffer.toString();
                buffer.reset();
                map.add(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeUtf8To(InputStream in, MultiMap map) throws IOException {
        MultiMap multiMap = map;
        synchronized (multiMap) {
            int b;
            Utf8StringBuffer buffer = new Utf8StringBuffer();
            String key = null;
            String value = null;
            block9: while ((b = in.read()) >= 0) {
                switch ((char)b) {
                    case '&': {
                        value = buffer.length() == 0 ? null : buffer.toString();
                        buffer.reset();
                        if (key != null) {
                            map.add(key, value);
                            key = null;
                            value = null;
                            break;
                        }
                        if (value == null) continue block9;
                        map.add(value, null);
                        value = null;
                        break;
                    }
                    case '=': {
                        if (key != null) {
                            buffer.append((byte)b);
                            break;
                        }
                        key = buffer.toString();
                        buffer.reset();
                        break;
                    }
                    case '+': {
                        buffer.append((byte)32);
                        break;
                    }
                    case '%': {
                        int dh = in.read();
                        int dl = in.read();
                        if (dh < 0) continue block9;
                        if (dl < 0) break;
                        buffer.append((byte)((TypeUtil.convertHexDigit((byte)dh) << 4) + TypeUtil.convertHexDigit((byte)dl)));
                        break;
                    }
                    default: {
                        buffer.append((byte)b);
                    }
                }
            }
            if (key != null) {
                value = buffer.toString();
                buffer.reset();
                map.add(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(InputStream in, MultiMap map, String charset) throws IOException {
        if (charset == null || "UTF-8".equalsIgnoreCase(charset)) {
            UrlEncoded.decodeUtf8To(in, map);
            return;
        }
        MultiMap multiMap = map;
        synchronized (multiMap) {
            ByteArrayOutputStream2 buf = new ByteArrayOutputStream2(256);
            String key = null;
            String value = null;
            byte digit = 0;
            int digits = 0;
            byte[] bytes = new byte[256];
            int l = -1;
            while ((l = in.read(bytes)) >= 0) {
                block10: for (int i = 0; i < l; ++i) {
                    byte c = bytes[i];
                    switch ((char)c) {
                        case '&': {
                            value = buf.size() == 0 ? null : new String(buf.getBuf(), 0, buf.size(), charset);
                            buf.reset();
                            if (key != null) {
                                map.add(key, value);
                                key = null;
                                value = null;
                                continue block10;
                            }
                            if (value == null) continue block10;
                            map.add(value, null);
                            value = null;
                            continue block10;
                        }
                        case '=': {
                            if (key != null) {
                                buf.write(c);
                                continue block10;
                            }
                            key = new String(buf.getBuf(), 0, buf.size(), charset);
                            buf.reset();
                            continue block10;
                        }
                        case '+': {
                            buf.write(32);
                            continue block10;
                        }
                        case '%': {
                            digits = 2;
                            continue block10;
                        }
                        default: {
                            if (digits == 2) {
                                digit = TypeUtil.convertHexDigit(c);
                                digits = 1;
                                continue block10;
                            }
                            if (digits == 1) {
                                buf.write((digit << 4) + TypeUtil.convertHexDigit(c));
                                digits = 0;
                                continue block10;
                            }
                            buf.write(c);
                        }
                    }
                }
            }
            if (key != null) {
                value = new String(buf.getBuf(), 0, buf.size(), charset);
                buf.reset();
                map.add(key, value);
            }
        }
    }

    public static String decodeString(String encoded) {
        return UrlEncoded.decodeString(encoded, 0, encoded.length(), "UTF-8");
    }

    public static String decodeString(String encoded, String charset) {
        return UrlEncoded.decodeString(encoded, 0, encoded.length(), charset);
    }

    public static String decodeString(String encoded, int offset, int length, String charset) {
        if (charset == null) {
            charset = "UTF-8";
        }
        byte[] bytes = null;
        int n = 0;
        for (int i = 0; i < length; ++i) {
            char c = encoded.charAt(offset + i);
            if (c < '\u0000' || c > '\u00ff') {
                throw new IllegalArgumentException("Not encoded");
            }
            if (c == '+') {
                if (bytes == null) {
                    bytes = new byte[length * 2];
                    encoded.getBytes(offset, offset + i, bytes, 0);
                    n = i;
                }
                bytes[n++] = 32;
                continue;
            }
            if (c == '%' && i + 2 < length) {
                char cn = encoded.charAt(offset + i + 1);
                byte b = cn >= 'a' && cn <= 'z' ? (byte)(10 + cn - 97) : (cn >= 'A' && cn <= 'Z' ? (byte)(10 + cn - 65) : (byte)(cn - 48));
                cn = encoded.charAt(offset + i + 2);
                b = cn >= 'a' && cn <= 'z' ? (byte)(b * 16 + 10 + cn - 97) : (cn >= 'A' && cn <= 'Z' ? (byte)(b * 16 + 10 + cn - 65) : (byte)(b * 16 + cn - 48));
                if (bytes == null) {
                    bytes = new byte[length];
                    encoded.getBytes(offset, offset + i, bytes, 0);
                    n = i;
                }
                i += 2;
                bytes[n++] = b;
                continue;
            }
            if (n <= 0) continue;
            bytes[n++] = (byte)c;
        }
        if (bytes == null) {
            if (offset == 0 && encoded.length() == length) {
                return encoded;
            }
            return encoded.substring(offset, offset + length);
        }
        try {
            return new String(bytes, 0, n, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes, 0, n);
        }
    }

    public static String encodeString(String string) {
        return UrlEncoded.encodeString(string, "UTF-8");
    }

    public static String encodeString(String string, String charset) {
        if (charset == null) {
            charset = "UTF-8";
        }
        byte[] bytes = null;
        try {
            bytes = string.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            bytes = string.getBytes();
        }
        int len = bytes.length;
        byte[] encoded = new byte[bytes.length * 3];
        int n = 0;
        boolean noEncode = true;
        for (int i = 0; i < len; ++i) {
            byte b = bytes[i];
            if (b == 32) {
                noEncode = false;
                encoded[n++] = 43;
                continue;
            }
            if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57) {
                encoded[n++] = b;
                continue;
            }
            noEncode = false;
            encoded[n++] = 37;
            byte nibble = (byte)((b & 0xF0) >> 4);
            encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
            nibble = (byte)(b & 0xF);
            encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
        }
        if (noEncode) {
            return string;
        }
        try {
            return new String(encoded, 0, n, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(encoded, 0, n);
        }
    }

    public Object clone() {
        return new UrlEncoded(this);
    }
}

