/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.jaas;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Stack;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.mortbay.jetty.plus.jaas.JAASRole;
import org.mortbay.jetty.plus.jaas.JAASUserRealm;
import org.mortbay.jetty.plus.jaas.RoleCheckPolicy;
import org.mortbay.jetty.plus.jaas.StrictRoleCheckPolicy;

public class JAASUserPrincipal
implements Principal {
    private Subject subject = null;
    private JAASUserRealm realm = null;
    private static RoleStack runAsRoles = new RoleStack();
    private RoleCheckPolicy roleCheckPolicy = null;
    private String name = null;
    private LoginContext loginContext = null;

    public JAASUserPrincipal(JAASUserRealm realm, String name) {
        this.name = name;
        this.realm = realm;
    }

    public JAASUserRealm getRealm() {
        return this.realm;
    }

    public boolean isUserInRole(String roleName) {
        if (this.roleCheckPolicy == null) {
            this.roleCheckPolicy = new StrictRoleCheckPolicy();
        }
        return this.roleCheckPolicy.checkRole(new JAASRole(roleName), runAsRoles.peek(), this.getRoles());
    }

    public Group getRoles() {
        return this.getRealm().getRoles(this);
    }

    public void setRoleCheckPolicy(RoleCheckPolicy policy) {
        this.roleCheckPolicy = policy;
    }

    public void pushRole(String roleName) {
        RoleStack.push(new JAASRole(roleName));
    }

    public void popRole() {
        runAsRoles.pop();
    }

    public void disassociate() {
        runAsRoles.clear();
    }

    public String getName() {
        return this.name;
    }

    protected void setSubject(Subject subject) {
        this.subject = subject;
    }

    public Subject getSubject() {
        return this.subject;
    }

    protected void setLoginContext(LoginContext loginContext) {
        this.loginContext = loginContext;
    }

    protected LoginContext getLoginContext() {
        return this.loginContext;
    }

    public String toString() {
        return this.getName();
    }

    public static class RoleStack {
        private static ThreadLocal local = new ThreadLocal();

        public static boolean empty() {
            Stack s = (Stack)local.get();
            if (s == null) {
                return false;
            }
            return s.empty();
        }

        public static void push(JAASRole role) {
            Stack<JAASRole> s = (Stack<JAASRole>)local.get();
            if (s == null) {
                s = new Stack<JAASRole>();
                local.set(s);
            }
            s.push(role);
        }

        public static void pop() {
            Stack s = (Stack)local.get();
            if (s == null || s.empty()) {
                return;
            }
            s.pop();
        }

        public static JAASRole peek() {
            Stack s = (Stack)local.get();
            if (s == null || s.empty()) {
                return null;
            }
            return (JAASRole)s.peek();
        }

        public static void clear() {
            Stack s = (Stack)local.get();
            if (s == null || s.empty()) {
                return;
            }
            s.clear();
        }
    }
}

