/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.jaas.spi;

import java.sql.Connection;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.sql.DataSource;
import org.mortbay.jetty.plus.jaas.spi.AbstractDatabaseLoginModule;

public class DataSourceLoginModule
extends AbstractDatabaseLoginModule {
    private String dbJNDIName;
    private DataSource dataSource;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        try {
            super.initialize(subject, callbackHandler, sharedState, options);
            this.dbJNDIName = (String)options.get("dbJNDIName");
            InitialContext ic = new InitialContext();
            this.dataSource = (DataSource)ic.lookup("java:comp/env/" + this.dbJNDIName);
            System.err.print("Datasource is " + (this.dataSource != null ? "found" : "not found"));
        }
        catch (NamingException e) {
            throw new IllegalStateException(e.toString());
        }
    }

    public Connection getConnection() throws Exception {
        return this.dataSource.getConnection();
    }
}

