/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.naming;

import java.util.ArrayList;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.mortbay.log.Log;
import org.mortbay.naming.NamingUtil;

public abstract class NamingEntry {
    private String jndiName;
    private Object objectToBind;
    private Name objectNameInNamespace;
    private Name namingEntryName;
    private Name objectName;
    private Context context;
    private static ThreadLocal webAppCompContext = new ThreadLocal();

    public static void setThreadLocalContext(Context c) {
        webAppCompContext.set(c);
    }

    public static Context getThreadLocalContext() {
        return (Context)webAppCompContext.get();
    }

    public static Context createContext(String webappName) throws NamingException {
        InitialContext icontext = new InitialContext();
        return icontext.createSubcontext(webappName);
    }

    public static void destroyContext(String webappName) throws NamingException {
        InitialContext icontext = new InitialContext();
        icontext.destroySubcontext(webappName);
    }

    public static Object lookupNamingEntry(Context context, Class clazz, String jndiName) throws NamingException {
        NameParser parser = context.getNameParser("");
        Name name = parser.parse("");
        name.add(clazz.getName());
        name.addAll(parser.parse(jndiName));
        return context.lookup(name);
    }

    public static List lookupNamingEntries(Context context, Class clazz) throws NamingException {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            NamingEnumeration<Binding> nenum = context.listBindings(clazz.getName());
            while (nenum.hasMoreElements()) {
                Binding binding = nenum.next();
                list.add(binding.getObject());
            }
        }
        catch (NameNotFoundException e) {
            Log.debug((String)("No entries of type " + clazz.getName() + " in context=" + context));
        }
        return list;
    }

    public NamingEntry(String jndiName, Object object) throws NamingException {
        this.jndiName = jndiName;
        this.objectToBind = object;
        InitialContext icontext = new InitialContext();
        this.context = NamingEntry.getThreadLocalContext();
        if (this.context == null) {
            this.context = icontext;
        }
        NameParser parser = this.context.getNameParser("");
        this.namingEntryName = parser.parse("");
        this.namingEntryName.add(this.getClass().getName());
        this.namingEntryName.add(this.getJndiName());
        NamingUtil.bind((Context)this.context, (String)this.namingEntryName.toString(), (Object)this);
        this.objectName = parser.parse(this.getJndiName());
        NamingUtil.bind((Context)this.context, (String)this.objectName.toString(), (Object)this.getObjectToBind());
        this.objectNameInNamespace = parser.parse(this.context.getNameInNamespace());
        this.objectNameInNamespace.addAll(this.objectName);
        Log.info((String)("Bound " + this.objectNameInNamespace + " using context " + this.context));
        Log.info((String)("Bound " + this.namingEntryName + " using context " + this.context));
    }

    public void bindToEnv() throws NamingException {
        InitialContext ic = new InitialContext();
        Context env = (Context)ic.lookup("java:comp/env");
        Log.info((String)("Binding java:comp/env/" + this.getJndiName() + " to " + this.objectNameInNamespace));
        NamingUtil.bind((Context)env, (String)this.getJndiName(), (Object)new LinkRef(this.objectNameInNamespace.toString()));
    }

    public void unbindEnv() {
        try {
            InitialContext ic = new InitialContext();
            Context env = (Context)ic.lookup("java:comp/env");
            Log.info((String)("Unbinding java:comp/env/" + this.getJndiName()));
            env.unbind(this.getJndiName());
        }
        catch (NamingException e) {
            Log.warn((Throwable)e);
        }
    }

    public void unbind() {
        try {
            this.context.unbind(this.objectName);
            this.context.unbind(this.namingEntryName);
        }
        catch (NamingException e) {
            Log.warn((Throwable)e);
        }
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public Object getObjectToBind() {
        return this.objectToBind;
    }
}

