/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.naming;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.mortbay.jetty.plus.naming.NamingEntry;
import org.mortbay.log.Log;

public class EnvEntry
extends NamingEntry {
    private boolean overrideWebXml;

    public static EnvEntry getEnvEntry(String jndiName) throws NamingException {
        try {
            Context context = EnvEntry.getThreadLocalContext();
            Object o = null;
            if (context != null) {
                try {
                    o = EnvEntry.lookupNamingEntry(context, EnvEntry.class, jndiName);
                }
                catch (NameNotFoundException e) {
                    Log.ignore((Throwable)e);
                    Log.debug((String)("Didn't find " + jndiName + " in thread context context"));
                }
            }
            if (o == null) {
                o = EnvEntry.lookupNamingEntry(new InitialContext(), EnvEntry.class, jndiName);
                Log.debug((String)("Found env entry " + jndiName + " in global context"));
            }
            return (EnvEntry)o;
        }
        catch (NameNotFoundException e) {
            Log.debug((String)("Didn't find " + jndiName + " anywhere"));
            return null;
        }
    }

    public EnvEntry(String jndiName, Object objToBind) throws NamingException {
        this(jndiName, objToBind, false);
    }

    public EnvEntry(String jndiName, Object objToBind, boolean overrideWebXml) throws NamingException {
        super(jndiName, objToBind);
        this.overrideWebXml = overrideWebXml;
    }

    public boolean isOverrideWebXml() {
        return this.overrideWebXml;
    }

    public void bindToEnv() throws NamingException {
        InitialContext iContext = new InitialContext();
        Context env = (Context)iContext.lookup("java:comp/env");
        boolean doBind = false;
        try {
            env.lookup(this.getJndiName());
            if (this.isOverrideWebXml()) {
                doBind = true;
            }
        }
        catch (NameNotFoundException e) {
            doBind = true;
        }
        if (doBind) {
            super.bindToEnv();
        }
    }
}

