/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.jaas;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.plus.jaas.JAASGroup;
import org.mortbay.jetty.plus.jaas.JAASUserPrincipal;
import org.mortbay.jetty.plus.jaas.RoleCheckPolicy;
import org.mortbay.jetty.plus.jaas.callback.AbstractCallbackHandler;
import org.mortbay.jetty.plus.jaas.callback.DefaultCallbackHandler;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.log.Log;
import org.mortbay.util.Loader;

public class JAASUserRealm
implements UserRealm {
    public static String DEFAULT_ROLE_CLASS_NAME = "org.mortbay.jetty.plus.jaas.JAASRole";
    public static String[] DEFAULT_ROLE_CLASS_NAMES = new String[]{DEFAULT_ROLE_CLASS_NAME};
    protected String[] roleClassNames = DEFAULT_ROLE_CLASS_NAMES;
    protected String callbackHandlerClass;
    protected String realmName;
    protected String loginModuleName;
    protected HashMap userMap = new HashMap();
    protected RoleCheckPolicy roleCheckPolicy;

    public JAASUserRealm() {
    }

    public JAASUserRealm(String name) {
        this();
        this.realmName = name;
    }

    public String getName() {
        return this.realmName;
    }

    public void setName(String name) {
        this.realmName = name;
    }

    public void setLoginModuleName(String name) {
        this.loginModuleName = name;
    }

    public void setCallbackHandlerClass(String classname) {
        this.callbackHandlerClass = classname;
    }

    public void setRoleClassNames(String[] classnames) {
        ArrayList<String> tmp = new ArrayList<String>();
        if (classnames != null) {
            tmp.addAll(Arrays.asList(classnames));
        }
        if (!tmp.contains(DEFAULT_ROLE_CLASS_NAME)) {
            tmp.add(DEFAULT_ROLE_CLASS_NAME);
        }
        this.roleClassNames = (String[])tmp.toArray();
    }

    public String[] getRoleClassNames() {
        return this.roleClassNames;
    }

    public void setRoleCheckPolicy(RoleCheckPolicy policy) {
        this.roleCheckPolicy = policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal getPrincipal(String username) {
        JAASUserRealm jAASUserRealm = this;
        synchronized (jAASUserRealm) {
            return (Principal)this.userMap.get(username);
        }
    }

    public boolean isUserInRole(Principal user, String role) {
        if (user instanceof JAASUserPrincipal) {
            return ((JAASUserPrincipal)user).isUserInRole(role);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reauthenticate(Principal user) {
        JAASUserRealm jAASUserRealm = this;
        synchronized (jAASUserRealm) {
            return this.userMap.get(user.getName()) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal authenticate(String username, Object credentials, Request request) {
        try {
            UserInfo info = null;
            JAASUserRealm jAASUserRealm = this;
            synchronized (jAASUserRealm) {
                info = (UserInfo)this.userMap.get(username);
            }
            if (info != null) {
                jAASUserRealm = this;
                synchronized (jAASUserRealm) {
                    this.userMap.remove(username);
                }
            }
            AbstractCallbackHandler callbackHandler = null;
            if (this.callbackHandlerClass == null) {
                Log.warn((String)"No CallbackHandler configured: using DefaultCallbackHandler");
                callbackHandler = new DefaultCallbackHandler();
            } else {
                callbackHandler = (AbstractCallbackHandler)Loader.loadClass((Class)JAASUserRealm.class, (String)this.callbackHandlerClass).getConstructors()[0].newInstance(new Object[0]);
            }
            if (callbackHandler instanceof DefaultCallbackHandler) {
                callbackHandler.setRequest(request);
            }
            callbackHandler.setUserName(username);
            callbackHandler.setCredential(credentials);
            LoginContext loginContext = new LoginContext(this.loginModuleName, callbackHandler);
            loginContext.login();
            JAASUserPrincipal userPrincipal = new JAASUserPrincipal(this, username);
            userPrincipal.setSubject(loginContext.getSubject());
            userPrincipal.setRoleCheckPolicy(this.roleCheckPolicy);
            JAASUserRealm jAASUserRealm2 = this;
            synchronized (jAASUserRealm2) {
                this.userMap.put(username, new UserInfo(username, userPrincipal, loginContext));
            }
            return userPrincipal;
        }
        catch (Exception e) {
            Log.warn((String)e.toString());
            Log.debug((Throwable)e);
            return null;
        }
    }

    public void disassociate(Principal user) {
        if (user != null) {
            ((JAASUserPrincipal)user).disassociate();
        }
    }

    public Principal pushRole(Principal user, String role) {
        ((JAASUserPrincipal)user).pushRole(role);
        return user;
    }

    public Principal popRole(Principal user) {
        ((JAASUserPrincipal)user).popRole();
        return user;
    }

    public Group getRoles(JAASUserPrincipal principal) {
        String[] roleClassNames = this.getRoleClassNames();
        JAASGroup roleGroup = new JAASGroup("__roles__");
        try {
            for (int i = 0; i < roleClassNames.length; ++i) {
                Class<?> load_class = Thread.currentThread().getContextClassLoader().loadClass(roleClassNames[i]);
                Set<?> rolesForType = principal.getSubject().getPrincipals(load_class);
                Iterator<?> itor = rolesForType.iterator();
                while (itor.hasNext()) {
                    roleGroup.addMember((Principal)itor.next());
                }
            }
            return roleGroup;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(Principal user) {
        try {
            if (!(user instanceof JAASUserPrincipal)) {
                throw new IllegalArgumentException(user + " is not a JAASUserPrincipal");
            }
            String key = ((JAASUserPrincipal)user).getName();
            UserInfo info = null;
            JAASUserRealm jAASUserRealm = this;
            synchronized (jAASUserRealm) {
                info = (UserInfo)this.userMap.get(key);
            }
            if (info == null) {
                Log.warn((String)("Logout called for user=" + user + " who is NOT in the authentication cache"));
            } else {
                info.getLoginContext().logout();
            }
            jAASUserRealm = this;
            synchronized (jAASUserRealm) {
                this.userMap.remove(key);
            }
            Log.debug((String)(user + " has been LOGGED OUT"));
        }
        catch (LoginException e) {
            Log.warn((Throwable)e);
        }
    }

    protected class UserInfo {
        String name;
        JAASUserPrincipal principal;
        LoginContext context;

        public UserInfo(String name, JAASUserPrincipal principal, LoginContext context) {
            this.name = name;
            this.principal = principal;
            this.context = context;
        }

        public String getName() {
            return this.name;
        }

        public JAASUserPrincipal getJAASUserPrincipal() {
            return this.principal;
        }

        public LoginContext getLoginContext() {
            return this.context;
        }
    }
}

