/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.naming;

import java.util.Hashtable;
import java.util.WeakHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.mortbay.log.Log;
import org.mortbay.naming.NamingContext;

public class ContextFactory
implements ObjectFactory {
    private static WeakHashMap _contextMap = new WeakHashMap();

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        Context ctx;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (Log.isDebugEnabled()) {
            Log.debug((String)("looking for context for " + loader));
        }
        if ((ctx = (Context)_contextMap.get(loader)) == null && (ctx = this.getParentClassLoaderContext(loader)) == null) {
            Reference ref = (Reference)obj;
            StringRefAddr parserAddr = (StringRefAddr)ref.get("parser");
            String parserClassName = parserAddr == null ? null : (String)parserAddr.getContent();
            NameParser parser = parserClassName == null ? null : loader.loadClass(parserClassName).newInstance();
            ctx = new NamingContext(env, name.get(0), nameCtx, parser);
            if (Log.isDebugEnabled()) {
                Log.debug((String)("No entry for classloader: " + loader));
            }
            _contextMap.put(loader, ctx);
        }
        return ctx;
    }

    public Context getParentClassLoaderContext(ClassLoader loader) {
        Context ctx = null;
        ClassLoader cl = loader;
        for (cl = cl.getParent(); cl != null && ctx == null; cl = cl.getParent()) {
            ctx = (Context)_contextMap.get(cl);
        }
        return ctx;
    }
}

