/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.DigesterFactory;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.startup.WebAnnotationSet;
import org.apache.catalina.startup.WebRuleSet;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.digester.Digester;
import org.jboss.logging.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class ContextConfig
implements LifecycleListener {
    protected static Logger log = Logger.getLogger(ContextConfig.class);
    protected Map customAuthenticators;
    protected static Properties authenticators = null;
    protected Context context = null;
    protected String defaultContextXml = null;
    protected String defaultWebXml = null;
    protected boolean ok = false;
    protected SAXParseException parseException = null;
    protected String originalDocBase = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    protected static Digester contextDigester = null;
    protected static Digester webDigester = null;
    protected static WebRuleSet webRuleSet = new WebRuleSet();
    protected static boolean xmlValidation = false;
    protected static boolean xmlNamespaceAware = false;
    protected static long deploymentCount = 0L;
    protected static final LoginConfig DUMMY_LOGIN_CONFIG = new LoginConfig("NONE", null, null, null);

    public String getDefaultWebXml() {
        if (this.defaultWebXml == null) {
            this.defaultWebXml = "conf/web.xml";
        }
        return this.defaultWebXml;
    }

    public void setDefaultWebXml(String path) {
        this.defaultWebXml = path;
    }

    public String getDefaultContextXml() {
        if (this.defaultContextXml == null) {
            this.defaultContextXml = "conf/context.xml";
        }
        return this.defaultContextXml;
    }

    public void setDefaultContextXml(String path) {
        this.defaultContextXml = path;
    }

    public void setCustomAuthenticators(Map customAuthenticators) {
        this.customAuthenticators = customAuthenticators;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.context = (Context)((Object)event.getLifecycle());
        }
        catch (ClassCastException e) {
            log.error((Object)sm.getString("contextConfig.cce", event.getLifecycle()), (Throwable)e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("before_start")) {
            this.beforeStart();
        } else if (event.getType().equals("after_start")) {
            if (this.originalDocBase != null) {
                String docBase = this.context.getDocBase();
                this.context.setDocBase(this.originalDocBase);
                this.originalDocBase = docBase;
            }
        } else if (event.getType().equals("stop")) {
            if (this.originalDocBase != null) {
                String docBase = this.context.getDocBase();
                this.context.setDocBase(this.originalDocBase);
                this.originalDocBase = docBase;
            }
            this.stop();
        } else if (event.getType().equals("init")) {
            this.init();
        } else if (event.getType().equals("destroy")) {
            this.destroy();
        }
    }

    protected void applicationAnnotationsConfig() {
        long t1 = System.currentTimeMillis();
        WebAnnotationSet.loadApplicationAnnotations(this.context);
        long t2 = System.currentTimeMillis();
        if (this.context instanceof StandardContext) {
            ((StandardContext)this.context).setStartupTime(t2 - t1 + ((StandardContext)this.context).getStartupTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void applicationWebConfig() {
        String altDDName = null;
        InputStream stream = null;
        ServletContext servletContext = this.context.getServletContext();
        if (servletContext != null) {
            altDDName = (String)servletContext.getAttribute("org.apache.catalina.deploy.alt_dd");
            if (altDDName != null) {
                try {
                    stream = new FileInputStream(altDDName);
                }
                catch (FileNotFoundException e) {
                    log.error((Object)sm.getString("contextConfig.altDDNotFound", altDDName));
                }
            } else {
                stream = servletContext.getResourceAsStream("/WEB-INF/web.xml");
            }
        }
        if (stream == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(sm.getString("contextConfig.applicationMissing") + " " + this.context));
            }
            return;
        }
        long t1 = System.currentTimeMillis();
        URL url = null;
        Digester digester = webDigester;
        synchronized (digester) {
            block30: {
                block29: {
                    url = altDDName != null ? new File(altDDName).toURL() : servletContext.getResource("/WEB-INF/web.xml");
                    if (url != null) {
                        InputSource is = new InputSource(url.toExternalForm());
                        is.setByteStream(stream);
                        if (this.context instanceof StandardContext) {
                            ((StandardContext)this.context).setReplaceWelcomeFiles(true);
                        }
                        webDigester.push(this.context);
                        webDigester.setErrorHandler(new ContextErrorHandler());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Parsing application web.xml file at " + url.toExternalForm()));
                        }
                        webDigester.parse(is);
                        if (this.parseException != null) {
                            this.ok = false;
                        }
                        break block29;
                    }
                    log.info((Object)("No web.xml, using defaults " + this.context));
                }
                Object var10_12 = null;
                webDigester.reset();
                this.parseException = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    break block30;
                }
                catch (IOException e2) {
                    log.error((Object)sm.getString("contextConfig.applicationClose"), (Throwable)e2);
                }
                break block30;
                {
                    catch (SAXParseException e) {
                        log.error((Object)sm.getString("contextConfig.applicationParse", url.toExternalForm()), (Throwable)e);
                        log.error((Object)sm.getString("contextConfig.applicationPosition", "" + e.getLineNumber(), "" + e.getColumnNumber()));
                        this.ok = false;
                        Object var10_13 = null;
                        webDigester.reset();
                        this.parseException = null;
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block30;
                        }
                        catch (IOException e2) {
                            log.error((Object)sm.getString("contextConfig.applicationClose"), (Throwable)e2);
                        }
                        break block30;
                    }
                    catch (Exception e) {
                        log.error((Object)sm.getString("contextConfig.applicationParse", url.toExternalForm()), (Throwable)e);
                        this.ok = false;
                        Object var10_14 = null;
                        webDigester.reset();
                        this.parseException = null;
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block30;
                        }
                        catch (IOException e2) {
                            log.error((Object)sm.getString("contextConfig.applicationClose"), (Throwable)e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    webDigester.reset();
                    this.parseException = null;
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException e2) {
                        log.error((Object)sm.getString("contextConfig.applicationClose"), (Throwable)e2);
                    }
                    throw throwable;
                }
            }
        }
        webRuleSet.recycle();
        long t2 = System.currentTimeMillis();
        if (this.context instanceof StandardContext) {
            ((StandardContext)this.context).setStartupTime(t2 - t1);
        }
    }

    protected synchronized void authenticatorConfig() {
        Pipeline pipeline;
        SecurityConstraint[] constraints = this.context.findConstraints();
        if (constraints == null || constraints.length == 0) {
            return;
        }
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (loginConfig == null) {
            loginConfig = DUMMY_LOGIN_CONFIG;
            this.context.setLoginConfig(loginConfig);
        }
        if (this.context instanceof Authenticator) {
            return;
        }
        if (this.context instanceof ContainerBase) {
            Pipeline pipeline2 = ((ContainerBase)((Object)this.context)).getPipeline();
            if (pipeline2 != null) {
                Valve basic = pipeline2.getBasic();
                if (basic != null && basic instanceof Authenticator) {
                    return;
                }
                Valve[] valves = pipeline2.getValves();
                for (int i = 0; i < valves.length; ++i) {
                    if (!(valves[i] instanceof Authenticator)) continue;
                    return;
                }
            }
        } else {
            return;
        }
        if (this.context.getRealm() == null) {
            log.error((Object)sm.getString("contextConfig.missingRealm"));
            this.ok = false;
            return;
        }
        Valve authenticator = null;
        if (this.customAuthenticators != null) {
            authenticator = (Valve)this.customAuthenticators.get(loginConfig.getAuthMethod());
        }
        if (authenticator == null) {
            if (authenticators == null) {
                try {
                    InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/apache/catalina/startup/Authenticators.properties");
                    if (is == null) {
                        log.error((Object)sm.getString("contextConfig.authenticatorResources"));
                        this.ok = false;
                        return;
                    }
                    authenticators = new Properties();
                    authenticators.load(is);
                }
                catch (IOException e) {
                    log.error((Object)sm.getString("contextConfig.authenticatorResources"), (Throwable)e);
                    this.ok = false;
                    return;
                }
            }
            String authenticatorName = null;
            authenticatorName = authenticators.getProperty(loginConfig.getAuthMethod());
            if (authenticatorName == null) {
                log.error((Object)sm.getString("contextConfig.authenticatorMissing", loginConfig.getAuthMethod()));
                this.ok = false;
                return;
            }
            try {
                Class<?> authenticatorClass = Class.forName(authenticatorName);
                authenticator = (Valve)authenticatorClass.newInstance();
            }
            catch (Throwable t) {
                log.error((Object)sm.getString("contextConfig.authenticatorInstantiate", authenticatorName), t);
                this.ok = false;
            }
        }
        if (authenticator != null && this.context instanceof ContainerBase && (pipeline = ((ContainerBase)((Object)this.context)).getPipeline()) != null) {
            ((ContainerBase)((Object)this.context)).addValve(authenticator);
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("contextConfig.authenticatorConfigured", loginConfig.getAuthMethod()));
            }
        }
    }

    protected static Digester createWebDigester() {
        Digester webDigester = ContextConfig.createWebXmlDigester(xmlNamespaceAware, xmlValidation);
        return webDigester;
    }

    public static Digester createWebXmlDigester(boolean namespaceAware, boolean validation) {
        Digester webDigester = DigesterFactory.newDigester(xmlValidation, xmlNamespaceAware, webRuleSet);
        return webDigester;
    }

    protected Digester createContextDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        ContextRuleSet contextRuleSet = new ContextRuleSet("", false);
        digester.addRuleSet(contextRuleSet);
        NamingRuleSet namingRuleSet = new NamingRuleSet("Context/");
        digester.addRuleSet(namingRuleSet);
        return digester;
    }

    protected String getBaseDir() {
        Container engineC = this.context.getParent().getParent();
        if (engineC instanceof StandardEngine) {
            return ((StandardEngine)engineC).getBaseDir();
        }
        return System.getProperty("catalina.base");
    }

    protected void defaultWebConfig() {
        long t2;
        File file;
        long t1 = System.currentTimeMillis();
        if (this.defaultWebXml == null && this.context instanceof StandardContext) {
            this.defaultWebXml = ((StandardContext)this.context).getDefaultWebXml();
        }
        if (this.defaultWebXml == null) {
            this.getDefaultWebXml();
        }
        if (!(file = new File(this.defaultWebXml)).isAbsolute()) {
            file = new File(this.getBaseDir(), this.defaultWebXml);
        }
        InputStream stream = null;
        InputSource source = null;
        try {
            if (!file.exists()) {
                stream = this.getClass().getClassLoader().getResourceAsStream(this.defaultWebXml);
                if (stream != null) {
                    source = new InputSource(this.getClass().getClassLoader().getResource(this.defaultWebXml).toString());
                }
                if (stream == null && (stream = this.getClass().getClassLoader().getResourceAsStream("web-embed.xml")) != null) {
                    source = new InputSource(this.getClass().getClassLoader().getResource("web-embed.xml").toString());
                }
                if (stream == null) {
                    log.info((Object)"No default web.xml");
                }
            } else {
                source = new InputSource("file://" + file.getAbsolutePath());
                stream = new FileInputStream(file);
                this.context.addWatchedResource(file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            log.error((Object)(sm.getString("contextConfig.defaultMissing") + " " + this.defaultWebXml + " " + file), (Throwable)e);
        }
        if (stream != null) {
            this.processDefaultWebConfig(webDigester, stream, source);
            webRuleSet.recycle();
        }
        if ((t2 = System.currentTimeMillis()) - t1 > 200L) {
            log.debug((Object)("Processed default web.xml " + file + " " + (t2 - t1)));
        }
        stream = null;
        source = null;
        String resourceName = this.getHostConfigPath("web.xml.default");
        file = new File(this.getConfigBase(), resourceName);
        try {
            if (!file.exists()) {
                stream = this.getClass().getClassLoader().getResourceAsStream(resourceName);
                if (stream != null) {
                    source = new InputSource(this.getClass().getClassLoader().getResource(resourceName).toString());
                }
            } else {
                source = new InputSource("file://" + file.getAbsolutePath());
                stream = new FileInputStream(file);
            }
        }
        catch (Exception e) {
            log.error((Object)(sm.getString("contextConfig.defaultMissing") + " " + resourceName + " " + file), (Throwable)e);
        }
        if (stream != null) {
            this.processDefaultWebConfig(webDigester, stream, source);
            webRuleSet.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void processDefaultWebConfig(Digester digester, InputStream stream, InputSource source) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing context [" + this.context.getName() + "] web configuration resource " + source.getSystemId()));
        }
        Digester digester2 = digester;
        synchronized (digester2) {
            block20: {
                block19: {
                    source.setByteStream(stream);
                    if (this.context instanceof StandardContext) {
                        ((StandardContext)this.context).setReplaceWelcomeFiles(true);
                    }
                    digester.setClassLoader(this.getClass().getClassLoader());
                    digester.setUseContextClassLoader(false);
                    digester.push(this.context);
                    digester.setErrorHandler(new ContextErrorHandler());
                    digester.parse(source);
                    if (this.parseException == null) break block19;
                    this.ok = false;
                }
                Object var7_5 = null;
                digester.reset();
                this.parseException = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    break block20;
                }
                catch (IOException e2) {
                    log.error((Object)sm.getString("contextConfig.defaultClose"), (Throwable)e2);
                }
                break block20;
                {
                    catch (SAXParseException e) {
                        log.error((Object)sm.getString("contextConfig.defaultParse"), (Throwable)e);
                        log.error((Object)sm.getString("contextConfig.defaultPosition", "" + e.getLineNumber(), "" + e.getColumnNumber()));
                        this.ok = false;
                        Object var7_6 = null;
                        digester.reset();
                        this.parseException = null;
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block20;
                        }
                        catch (IOException e2) {
                            log.error((Object)sm.getString("contextConfig.defaultClose"), (Throwable)e2);
                        }
                        break block20;
                    }
                    catch (Exception e) {
                        log.error((Object)sm.getString("contextConfig.defaultParse"), (Throwable)e);
                        this.ok = false;
                        Object var7_7 = null;
                        digester.reset();
                        this.parseException = null;
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block20;
                        }
                        catch (IOException e2) {
                            log.error((Object)sm.getString("contextConfig.defaultClose"), (Throwable)e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    digester.reset();
                    this.parseException = null;
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException e2) {
                        log.error((Object)sm.getString("contextConfig.defaultClose"), (Throwable)e2);
                    }
                    throw throwable;
                }
            }
        }
    }

    protected void contextConfig() {
        if (this.defaultContextXml == null && this.context instanceof StandardContext) {
            this.defaultContextXml = ((StandardContext)this.context).getDefaultContextXml();
        }
        if (this.defaultContextXml == null) {
            this.getDefaultContextXml();
        }
        if (!this.context.getOverride()) {
            this.processContextConfig(new File(this.getBaseDir()), this.defaultContextXml);
            this.processContextConfig(this.getConfigBase(), this.getHostConfigPath("context.xml.default"));
        }
        if (this.context.getConfigFile() != null) {
            this.processContextConfig(new File(this.context.getConfigFile()), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void processContextConfig(File baseDir, String resourceName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing context [" + this.context.getName() + "] configuration file " + baseDir + " " + resourceName));
        }
        InputSource source = null;
        InputStream stream = null;
        File file = baseDir;
        if (resourceName != null) {
            file = new File(baseDir, resourceName);
        }
        try {
            if (!file.exists()) {
                if (resourceName != null && (stream = this.getClass().getClassLoader().getResourceAsStream(resourceName)) != null) {
                    source = new InputSource(this.getClass().getClassLoader().getResource(resourceName).toString());
                }
            } else {
                source = new InputSource("file://" + file.getAbsolutePath());
                stream = new FileInputStream(file);
                this.context.addWatchedResource(file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            log.error((Object)sm.getString("contextConfig.contextMissing", resourceName + " " + file), (Throwable)e);
        }
        if (source == null) {
            return;
        }
        Digester digester = contextDigester;
        synchronized (digester) {
            block27: {
                block26: {
                    source.setByteStream(stream);
                    contextDigester.setClassLoader(this.getClass().getClassLoader());
                    contextDigester.setUseContextClassLoader(false);
                    contextDigester.push(this.context.getParent());
                    contextDigester.push(this.context);
                    contextDigester.setErrorHandler(new ContextErrorHandler());
                    contextDigester.parse(source);
                    if (this.parseException != null) {
                        this.ok = false;
                    }
                    if (!log.isDebugEnabled()) break block26;
                    log.debug((Object)("Successfully processed context [" + this.context.getName() + "] configuration file " + baseDir + " " + resourceName));
                }
                Object var9_8 = null;
                contextDigester.reset();
                this.parseException = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    break block27;
                }
                catch (IOException e2) {
                    log.error((Object)sm.getString("contextConfig.contextClose"), (Throwable)e2);
                }
                break block27;
                {
                    catch (SAXParseException e) {
                        log.error((Object)sm.getString("contextConfig.contextParse", this.context.getName()), (Throwable)e);
                        log.error((Object)sm.getString("contextConfig.defaultPosition", "" + e.getLineNumber(), "" + e.getColumnNumber()));
                        this.ok = false;
                        Object var9_9 = null;
                        contextDigester.reset();
                        this.parseException = null;
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block27;
                        }
                        catch (IOException e2) {
                            log.error((Object)sm.getString("contextConfig.contextClose"), (Throwable)e2);
                        }
                        break block27;
                    }
                    catch (Exception e) {
                        log.error((Object)sm.getString("contextConfig.contextParse", this.context.getName()), (Throwable)e);
                        this.ok = false;
                        Object var9_10 = null;
                        contextDigester.reset();
                        this.parseException = null;
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block27;
                        }
                        catch (IOException e2) {
                            log.error((Object)sm.getString("contextConfig.contextClose"), (Throwable)e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    contextDigester.reset();
                    this.parseException = null;
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException e2) {
                        log.error((Object)sm.getString("contextConfig.contextClose"), (Throwable)e2);
                    }
                    throw throwable;
                }
            }
        }
    }

    protected void fixDocBase() throws IOException {
        File file;
        File canonicalAppBase;
        Host host = (Host)this.context.getParent();
        String appBase = host.getAppBase();
        boolean unpackWARs = true;
        if (host instanceof StandardHost) {
            unpackWARs = ((StandardHost)host).isUnpackWARs() && ((StandardContext)this.context).getUnpackWAR();
        }
        canonicalAppBase = (canonicalAppBase = new File(appBase)).isAbsolute() ? canonicalAppBase.getCanonicalFile() : new File(System.getProperty("catalina.base"), appBase).getCanonicalFile();
        String docBase = this.context.getDocBase();
        if (docBase == null) {
            String path = this.context.getPath();
            if (path == null) {
                return;
            }
            docBase = path.equals("") ? "ROOT" : (path.startsWith("/") ? path.substring(1).replace('/', '#') : path.replace('/', '#'));
        }
        docBase = !(file = new File(docBase)).isAbsolute() ? new File(canonicalAppBase, docBase).getPath() : file.getCanonicalPath();
        file = new File(docBase);
        String origDocBase = docBase;
        String contextPath = this.context.getPath();
        if (contextPath.equals("")) {
            contextPath = "ROOT";
        } else if (contextPath.lastIndexOf(47) > 0) {
            contextPath = "/" + contextPath.substring(1).replace('/', '#');
        }
        if (docBase.toLowerCase().endsWith(".war") && !file.isDirectory() && unpackWARs) {
            URL war = new URL("jar:" + new File(docBase).toURI().toURL() + "!/");
            docBase = ExpandWar.expand(host, war, contextPath);
            file = new File(docBase);
            docBase = file.getCanonicalPath();
            if (this.context instanceof StandardContext) {
                ((StandardContext)this.context).setOriginalDocBase(origDocBase);
            }
        } else {
            File docDir = new File(docBase);
            if (!docDir.exists()) {
                File warFile = new File(docBase + ".war");
                if (warFile.exists()) {
                    if (unpackWARs) {
                        URL war = new URL("jar:" + warFile.toURI().toURL() + "!/");
                        docBase = ExpandWar.expand(host, war, contextPath);
                        file = new File(docBase);
                        docBase = file.getCanonicalPath();
                    } else {
                        docBase = warFile.getCanonicalPath();
                    }
                }
                if (this.context instanceof StandardContext) {
                    ((StandardContext)this.context).setOriginalDocBase(origDocBase);
                }
            }
        }
        if (docBase.startsWith(canonicalAppBase.getPath() + File.separatorChar)) {
            docBase = docBase.substring(canonicalAppBase.getPath().length());
            if ((docBase = docBase.replace(File.separatorChar, '/')).startsWith("/")) {
                docBase = docBase.substring(1);
            }
        } else {
            docBase = docBase.replace(File.separatorChar, '/');
        }
        this.context.setDocBase(docBase);
    }

    protected void antiLocking() throws IOException {
        if (this.context instanceof StandardContext && ((StandardContext)this.context).getAntiResourceLocking()) {
            String path;
            Host host = (Host)this.context.getParent();
            String appBase = host.getAppBase();
            String docBase = this.context.getDocBase();
            if (docBase == null) {
                return;
            }
            if (this.originalDocBase == null) {
                this.originalDocBase = docBase;
            } else {
                docBase = this.originalDocBase;
            }
            File docBaseFile = new File(docBase);
            if (!docBaseFile.isAbsolute()) {
                File file = new File(appBase);
                if (!file.isAbsolute()) {
                    file = new File(System.getProperty("catalina.base"), appBase);
                }
                docBaseFile = new File(file, docBase);
            }
            if ((path = this.context.getPath()) == null) {
                return;
            }
            docBase = path.equals("") ? "ROOT" : (path.startsWith("/") ? path.substring(1) : path);
            File file = null;
            file = docBase.toLowerCase().endsWith(".war") ? new File(System.getProperty("java.io.tmpdir"), deploymentCount++ + "-" + docBase + ".war") : new File(System.getProperty("java.io.tmpdir"), deploymentCount++ + "-" + docBase);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Anti locking context[" + this.context.getPath() + "] setting docBase to " + file));
            }
            ExpandWar.delete(file);
            if (ExpandWar.copy(docBaseFile, file)) {
                this.context.setDocBase(file.getAbsolutePath());
            }
        }
    }

    protected void init() {
        if (webDigester == null) {
            webDigester = ContextConfig.createWebDigester();
            webDigester.getParser();
        }
        if (contextDigester == null) {
            contextDigester = this.createContextDigester();
            contextDigester.getParser();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.init"));
        }
        this.context.setConfigured(false);
        this.ok = true;
        this.contextConfig();
        try {
            this.fixDocBase();
        }
        catch (IOException e) {
            log.error((Object)sm.getString("contextConfig.fixDocBase"), (Throwable)e);
        }
    }

    protected synchronized void beforeStart() {
        try {
            this.antiLocking();
        }
        catch (IOException e) {
            log.error((Object)sm.getString("contextConfig.antiLocking"), (Throwable)e);
        }
    }

    protected synchronized void start() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.start"));
        }
        Container container = this.context.getParent();
        if (!this.context.getOverride() && container instanceof Host) {
            xmlValidation = this.context.getXmlValidation();
            if (!xmlValidation) {
                xmlValidation = ((Host)container).getXmlValidation();
            }
            if (!(xmlNamespaceAware = this.context.getXmlNamespaceAware())) {
                xmlNamespaceAware = ((Host)container).getXmlNamespaceAware();
            }
            container = container.getParent();
        }
        this.defaultWebConfig();
        this.applicationWebConfig();
        if (!this.context.getIgnoreAnnotations()) {
            this.applicationAnnotationsConfig();
        }
        if (this.ok) {
            this.validateSecurityRoles();
        }
        if (this.ok) {
            this.authenticatorConfig();
        }
        if (log.isDebugEnabled() && this.context instanceof ContainerBase) {
            log.debug((Object)"Pipeline Configuration:");
            Pipeline pipeline = ((ContainerBase)((Object)this.context)).getPipeline();
            Valve[] valves = null;
            if (pipeline != null) {
                valves = pipeline.getValves();
            }
            if (valves != null) {
                for (int i = 0; i < valves.length; ++i) {
                    log.debug((Object)("  " + valves[i].getInfo()));
                }
            }
            log.debug((Object)"======================");
        }
        if (this.ok) {
            this.context.setConfigured(true);
        } else {
            log.error((Object)sm.getString("contextConfig.unavailable"));
            this.context.setConfigured(false);
        }
    }

    protected synchronized void stop() {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.stop"));
        }
        Container[] children = this.context.findChildren();
        for (i = 0; i < children.length; ++i) {
            this.context.removeChild(children[i]);
        }
        SecurityConstraint[] securityConstraints = this.context.findConstraints();
        for (i = 0; i < securityConstraints.length; ++i) {
            this.context.removeConstraint(securityConstraints[i]);
        }
        ErrorPage[] errorPages = this.context.findErrorPages();
        for (i = 0; i < errorPages.length; ++i) {
            this.context.removeErrorPage(errorPages[i]);
        }
        FilterDef[] filterDefs = this.context.findFilterDefs();
        for (i = 0; i < filterDefs.length; ++i) {
            this.context.removeFilterDef(filterDefs[i]);
        }
        FilterMap[] filterMaps = this.context.findFilterMaps();
        for (i = 0; i < filterMaps.length; ++i) {
            this.context.removeFilterMap(filterMaps[i]);
        }
        String[] mimeMappings = this.context.findMimeMappings();
        for (i = 0; i < mimeMappings.length; ++i) {
            this.context.removeMimeMapping(mimeMappings[i]);
        }
        String[] parameters = this.context.findParameters();
        for (i = 0; i < parameters.length; ++i) {
            this.context.removeParameter(parameters[i]);
        }
        String[] securityRoles = this.context.findSecurityRoles();
        for (i = 0; i < securityRoles.length; ++i) {
            this.context.removeSecurityRole(securityRoles[i]);
        }
        String[] servletMappings = this.context.findServletMappings();
        for (i = 0; i < servletMappings.length; ++i) {
            this.context.removeServletMapping(servletMappings[i]);
        }
        String[] taglibs = this.context.findTaglibs();
        for (i = 0; i < taglibs.length; ++i) {
            this.context.removeTaglib(taglibs[i]);
        }
        String[] welcomeFiles = this.context.findWelcomeFiles();
        for (i = 0; i < welcomeFiles.length; ++i) {
            this.context.removeWelcomeFile(welcomeFiles[i]);
        }
        String[] wrapperLifecycles = this.context.findWrapperLifecycles();
        for (i = 0; i < wrapperLifecycles.length; ++i) {
            this.context.removeWrapperLifecycle(wrapperLifecycles[i]);
        }
        String[] wrapperListeners = this.context.findWrapperListeners();
        for (i = 0; i < wrapperListeners.length; ++i) {
            this.context.removeWrapperListener(wrapperListeners[i]);
        }
        Host host = (Host)this.context.getParent();
        String appBase = host.getAppBase();
        String docBase = this.context.getDocBase();
        if (docBase != null && this.originalDocBase != null) {
            File docBaseFile = new File(docBase);
            if (!docBaseFile.isAbsolute()) {
                docBaseFile = new File(appBase, docBase);
            }
            ExpandWar.delete(docBaseFile);
        }
        this.ok = true;
    }

    protected synchronized void destroy() {
        String workDir;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.destroy"));
        }
        if ((workDir = ((StandardContext)this.context).getWorkPath()) != null) {
            ExpandWar.delete(new File(workDir));
        }
    }

    protected void validateSecurityRoles() {
        SecurityConstraint[] constraints = this.context.findConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            String[] roles = constraints[i].findAuthRoles();
            for (int j = 0; j < roles.length; ++j) {
                if ("*".equals(roles[j]) || this.context.findSecurityRole(roles[j])) continue;
                log.info((Object)sm.getString("contextConfig.role.auth", roles[j]));
                this.context.addSecurityRole(roles[j]);
            }
        }
        Container[] wrappers = this.context.findChildren();
        for (int i = 0; i < wrappers.length; ++i) {
            Wrapper wrapper = (Wrapper)wrappers[i];
            String runAs = wrapper.getRunAs();
            if (runAs != null && !this.context.findSecurityRole(runAs)) {
                log.info((Object)sm.getString("contextConfig.role.runas", runAs));
                this.context.addSecurityRole(runAs);
            }
            String[] names = wrapper.findSecurityReferences();
            for (int j = 0; j < names.length; ++j) {
                String link = wrapper.findSecurityReference(names[j]);
                if (link == null || this.context.findSecurityRole(link)) continue;
                log.info((Object)sm.getString("contextConfig.role.link", link));
                this.context.addSecurityRole(link);
            }
        }
    }

    protected File getConfigBase() {
        File configBase = new File(System.getProperty("catalina.base"), "conf");
        if (!configBase.exists()) {
            return null;
        }
        return configBase;
    }

    protected String getHostConfigPath(String resourceName) {
        StringBuffer result = new StringBuffer();
        Context host = null;
        Container engine = null;
        for (Container container = this.context; container != null; container = container.getParent()) {
            if (container instanceof Host) {
                host = container;
            }
            if (!(container instanceof Engine)) continue;
            engine = container;
        }
        if (engine != null) {
            result.append(engine.getName()).append('/');
        }
        if (host != null) {
            result.append(host.getName()).append('/');
        }
        result.append(resourceName);
        return result.toString();
    }

    protected class ContextErrorHandler
    implements ErrorHandler {
        protected ContextErrorHandler() {
        }

        public void error(SAXParseException exception) {
            ContextConfig.this.parseException = exception;
        }

        public void fatalError(SAXParseException exception) {
            ContextConfig.this.parseException = exception;
        }

        public void warning(SAXParseException exception) {
            ContextConfig.this.parseException = exception;
        }
    }
}

