/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db.hibernate;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.configuration.ObjectFactory;
import org.jbpm.context.exe.Converter;
import org.jbpm.util.ClassLoaderUtil;

public abstract class Converters {
    static final int CONVERTERS_BY_CLASS_NAMES = 0;
    static final int CONVERTERS_BY_DATABASE_ID = 1;
    static final int CONVERTERS_IDS = 2;
    static Map converterMapsMap = new HashMap();
    private static Log log = LogFactory.getLog((Class)Converters.class);

    public static Converter getConverterByClassName(String className) {
        Converter converter = (Converter)Converters.getConvertersByClassNames().get(className);
        if (converter == null) {
            throw new JbpmException("converter '" + className + "' is not declared in jbpm.converter.properties");
        }
        return converter;
    }

    public static Converter getConverterByDatabaseId(String converterDatabaseId) {
        return (Converter)Converters.getConvertersByDatabaseId().get(converterDatabaseId);
    }

    public static String getConverterId(Converter converter) {
        return (String)Converters.getConvertersIds().get(converter);
    }

    static Map getConvertersByClassNames() {
        return Converters.getConverterMaps()[0];
    }

    static Map getConvertersByDatabaseId() {
        return Converters.getConverterMaps()[1];
    }

    static Map getConvertersIds() {
        return Converters.getConverterMaps()[2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map[] getConverterMaps() {
        Map[] converterMaps = null;
        Map map = converterMapsMap;
        synchronized (map) {
            ObjectFactory objectFactory = JbpmConfiguration.Configs.getObjectFactory();
            converterMaps = (Map[])converterMapsMap.get(objectFactory);
            if (converterMaps == null) {
                converterMaps = Converters.createConverterMaps(objectFactory);
                converterMapsMap.put(objectFactory, converterMaps);
            }
        }
        return converterMaps;
    }

    static Map[] createConverterMaps(ObjectFactory objectFactory) {
        Map[] converterMaps = new Map[]{new HashMap(), new HashMap(), new HashMap()};
        Map convertersByClassNames = converterMaps[0];
        Map convertersByDatabaseId = converterMaps[1];
        Map convertersIds = converterMaps[2];
        Properties converterProperties = null;
        if (objectFactory.hasObject("resource.converter")) {
            String resource = (String)objectFactory.createObject("resource.converter");
            converterProperties = ClassLoaderUtil.getProperties(resource);
        } else {
            converterProperties = new Properties();
        }
        Iterator<Object> iter = converterProperties.keySet().iterator();
        while (iter.hasNext()) {
            String converterDatabaseId = (String)iter.next();
            if (converterDatabaseId.length() != 1) {
                throw new JbpmException("converter-ids must be of length 1 (to be stored in a char)");
            }
            if (convertersByDatabaseId.containsKey(converterDatabaseId)) {
                throw new JbpmException("duplicate converter id : '" + converterDatabaseId + "'");
            }
            String converterClassName = converterProperties.getProperty(converterDatabaseId);
            try {
                Class converterClass = ClassLoaderUtil.loadClass(converterClassName);
                Converter converter = (Converter)converterClass.newInstance();
                log.debug((Object)("adding converter '" + converterDatabaseId + "', '" + converterClassName + "'"));
                convertersByClassNames.put(converterClassName, converter);
                convertersByDatabaseId.put(converterDatabaseId, converter);
                convertersIds.put(converter, converterDatabaseId);
            }
            catch (Throwable t) {
                log.debug((Object)("couldn't instantiate converter '" + converterClassName + "': " + t));
            }
        }
        return converterMaps;
    }
}

