/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Permission;
import java.security.Principal;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.security.auth.login.AppConfigurationEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.security.AppPolicy;
import org.jboss.security.AuthenticationInfo;
import org.jboss.security.AuthorizationInfo;
import org.jboss.security.IAppPolicyStore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class SecurityPolicyParser
implements IAppPolicyStore {
    private static String DEFAULT_APP_POLICY_NAME = "other";
    private URL policyURL;
    private HashMap policyMap = new HashMap();
    static /* synthetic */ Class class$java$lang$String;

    public SecurityPolicyParser(URL policyURL) {
        this.policyURL = policyURL;
    }

    public AppPolicy getAppPolicy(String appName) {
        AppPolicy appPolicy = (AppPolicy)this.policyMap.get(appName);
        if (appPolicy == null) {
            appPolicy = AppPolicy.getDefaultAppPolicy();
        }
        return appPolicy;
    }

    public void refresh() {
        Document doc = null;
        try {
            doc = this.loadURL();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        Element root = doc.getDocumentElement();
        NodeList apps = root.getElementsByTagName("application-policy");
        for (int n = 0; n < apps.getLength(); ++n) {
            Element app = (Element)apps.item(n);
            String name = app.getAttribute("name");
            AppPolicy appPolicy = new AppPolicy(name);
            try {
                this.parse(app, appPolicy);
                if (name.equals(DEFAULT_APP_POLICY_NAME)) {
                    AppPolicy.setDefaultAppPolicy(appPolicy);
                    continue;
                }
                this.policyMap.put(name, appPolicy);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Document loadURL() throws Exception {
        InputStream is = this.policyURL.openStream();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        LocalResolver resolver = new LocalResolver();
        docBuilder.setEntityResolver(resolver);
        Document doc = docBuilder.parse(is);
        return doc;
    }

    private void parse(Element policy, AppPolicy appPolicy) throws Exception {
        this.parseKeyStore(policy, appPolicy);
        this.parseAuthentication(policy, appPolicy);
        this.parseAuthorization(policy, appPolicy);
    }

    private void parseKeyStore(Element policy, AppPolicy appPolicy) throws Exception {
        NodeList keystore = policy.getElementsByTagName("keystore");
        String keystoreHref = ".keystore";
        String keystoreType = "JKS";
        if (keystore.getLength() > 0) {
            Element e = (Element)keystore.item(0);
            keystoreHref = e.getAttribute("href");
            keystoreType = e.getAttribute("type");
            InputStream keystoreStream = null;
            try {
                URL keystoreURL = new URL(keystoreHref);
                keystoreStream = keystoreURL.openStream();
            }
            catch (MalformedURLException ex) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                keystoreStream = loader.getResourceAsStream(keystoreHref);
            }
            KeyStore keyStore = KeyStore.getInstance(keystoreType);
            char[] password = new char[]{};
            keyStore.load(keystoreStream, password);
            appPolicy.setKeyStore(keyStore);
        }
    }

    private void parseAuthentication(Element policy, AppPolicy appPolicy) throws Exception {
        NodeList authentication = policy.getElementsByTagName("authentication");
        if (authentication.getLength() == 0) {
            return;
        }
        Element auth = (Element)authentication.item(0);
        NodeList modules = auth.getElementsByTagName("login-module");
        ArrayList tmp = new ArrayList();
        for (int n = 0; n < modules.getLength(); ++n) {
            Element grant = (Element)modules.item(n);
            this.parseModule(grant, tmp);
        }
        AppConfigurationEntry[] entries = new AppConfigurationEntry[tmp.size()];
        tmp.toArray(entries);
        AuthenticationInfo info = new AuthenticationInfo();
        info.setAppConfigurationEntry(entries);
        appPolicy.setLoginInfo(info);
    }

    private void parseModule(Element module, ArrayList entries) throws Exception {
        AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        String className = module.getAttribute("code");
        String flag = module.getAttribute("flag");
        if (flag != null) {
            if (flag.equals(AppConfigurationEntry.LoginModuleControlFlag.REQUIRED.toString())) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            } else if (flag.equals(AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.toString())) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            } else if (flag.equals(AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.toString())) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            } else if (flag.equals(AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL.toString())) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            }
        }
        NodeList opts = module.getElementsByTagName("module-option");
        HashMap<String, String> options = new HashMap<String, String>();
        for (int n = 0; n < opts.getLength(); ++n) {
            Element opt = (Element)opts.item(n);
            String name = opt.getAttribute("name");
            String value = SecurityPolicyParser.getContent(opt, "");
            options.put(name, value);
        }
        AppConfigurationEntry entry = new AppConfigurationEntry(className, controlFlag, options);
        entries.add(entry);
    }

    private void parseAuthorization(Element policy, AppPolicy appPolicy) throws Exception {
        NodeList authorization = policy.getElementsByTagName("authorization");
        if (authorization.getLength() == 0) {
            return;
        }
        Element auth = (Element)authorization.item(0);
        NodeList grants = auth.getElementsByTagName("grant");
        for (int n = 0; n < grants.getLength(); ++n) {
            Element grant = (Element)grants.item(n);
            this.parseGrant(grant, appPolicy);
        }
    }

    private void parseGrant(Element grant, AppPolicy appPolicy) throws Exception {
        String signers;
        String attr;
        URL codebase = null;
        if (grant.getAttribute("codebase") != null && (attr = grant.getAttribute("codebase")).length() > 0) {
            codebase = new URL(attr);
        }
        String[] signerAliases = new String[]{};
        Certificate[] signedBy = null;
        if (grant.getAttribute("signedBy") != null && (signers = grant.getAttribute("signedBy")).length() > 0) {
            signedBy = this.getCertificates(signers, appPolicy.getKeyStore());
        }
        CodeSource cs = new CodeSource(codebase, signedBy);
        ArrayList<Principal> principals = null;
        NodeList tmp = grant.getElementsByTagName("principal");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        for (int n = 0; n < tmp.getLength(); ++n) {
            Element principal = (Element)tmp.item(n);
            String code = principal.getAttribute("code");
            String name = principal.getAttribute("name");
            try {
                Class<?> cls = loader.loadClass(code);
                Class[] parameterTypes = new Class[]{class$java$lang$String == null ? SecurityPolicyParser.class$("java.lang.String") : class$java$lang$String};
                Constructor<?> ctor = cls.getConstructor(parameterTypes);
                Object[] args = new Object[]{name};
                Principal p = (Principal)ctor.newInstance(args);
                if (principals == null) {
                    principals = new ArrayList<Principal>();
                }
                principals.add(p);
                continue;
            }
            catch (Exception e) {
                throw new GeneralSecurityException(e.getClass().getName() + ',' + e.getMessage());
            }
        }
        ArrayList<UnresolvedPermission> permissions = null;
        tmp = grant.getElementsByTagName("permission");
        for (int n = 0; n < tmp.getLength(); ++n) {
            Element perm = (Element)tmp.item(n);
            String code = perm.getAttribute("code");
            String name = perm.getAttribute("name");
            String actions = perm.getAttribute("actions");
            String signers2 = perm.getAttribute("signedBy");
            name = this.expandString(name);
            try {
                Class<?> cls = null;
                Constructor<?> ctor = null;
                Permission p = null;
                try {
                    cls = loader.loadClass(code);
                    Class[] parameterTypes2 = new Class[]{class$java$lang$String == null ? SecurityPolicyParser.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? SecurityPolicyParser.class$("java.lang.String") : class$java$lang$String};
                    Object[] args2 = new Object[]{name, actions};
                    ctor = cls.getConstructor(parameterTypes2);
                    p = (Permission)ctor.newInstance(args2);
                }
                catch (ClassNotFoundException e) {
                    Certificate[] certs = null;
                    if (signers2 != null) {
                        certs = this.getCertificates(signers2, appPolicy.getKeyStore());
                    }
                    p = new UnresolvedPermission(code, name, actions, certs);
                }
                catch (Exception e) {
                    Class[] parameterTypes = new Class[]{class$java$lang$String == null ? SecurityPolicyParser.class$("java.lang.String") : class$java$lang$String};
                    Object[] args = new Object[]{name};
                    ctor = cls.getConstructor(parameterTypes);
                    p = (Permission)ctor.newInstance(args);
                }
                if (permissions == null) {
                    permissions = new ArrayList<UnresolvedPermission>();
                }
                if (p == null) continue;
                permissions.add((UnresolvedPermission)p);
                continue;
            }
            catch (Exception e) {
                throw new GeneralSecurityException(e.getClass().getName() + ',' + e.getMessage());
            }
        }
        Principal[] roles = new Principal[]{};
        AuthorizationInfo authInfo = appPolicy.getPermissionInfo();
        if (authInfo == null) {
            authInfo = new AuthorizationInfo();
            appPolicy.setPermissionInfo(authInfo);
        }
        if (principals == null) {
            authInfo.grant(cs, permissions);
        } else {
            roles = principals.toArray(roles);
            authInfo.grant(cs, permissions, roles);
        }
    }

    private String expandString(String str) {
        int index = str.indexOf("${/}");
        if (index >= 0) {
            int start = 0;
            StringBuffer sb = new StringBuffer();
            while (index >= 0) {
                sb.append(str.substring(start, index));
                sb.append(File.separatorChar);
                start = index + 4;
                index = str.indexOf("${/}", start);
            }
            if (start <= str.length() - 1) {
                sb.append(str.substring(start));
            }
            str = sb.toString();
        }
        return str;
    }

    private Certificate[] getCertificates(String signedBy, KeyStore keyStore) {
        Certificate[] signedByCerts = null;
        StringTokenizer tokenizer = new StringTokenizer(signedBy, ",");
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        while (tokenizer.hasMoreTokens()) {
            String alias = tokenizer.nextToken();
            try {
                Certificate cert = keyStore.getCertificate(alias);
                certs.add(cert);
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
        }
        if (certs.size() > 0) {
            signedByCerts = new Certificate[certs.size()];
            certs.toArray(signedByCerts);
        }
        return signedByCerts;
    }

    public static String getContent(Element element, String defaultContent) {
        NodeList children = element.getChildNodes();
        String content = defaultContent;
        if (children.getLength() > 0) {
            content = "";
            for (int n = 0; n < children.getLength(); ++n) {
                content = children.item(n).getNodeType() == 3 || children.item(n).getNodeType() == 4 ? content + children.item(n).getNodeValue() : content + children.item(n).getFirstChild();
            }
            return content;
        }
        return content;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LocalResolver
    implements EntityResolver {
        private static final String SECURITY_POLICY_PUBLIC_ID = "-//JBoss//DTD JAAS SecurityPolicy//EN";
        private static final String SECURITY_POLICY_DTD_NAME = "security-policy.dtd";

        private LocalResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            InputSource is = null;
            if (publicId.equals(SECURITY_POLICY_PUBLIC_ID)) {
                try {
                    InputStream dtdStream = this.getClass().getResourceAsStream(SECURITY_POLICY_DTD_NAME);
                    is = new InputSource(dtdStream);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return is;
        }
    }
}

