/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.modelmbean.ModelMBeanConstants;
import org.jboss.mx.modelmbean.RequiredModelMBeanInstantiator;
import org.jboss.mx.notification.MBeanServerListenerRegistry;
import org.jboss.mx.server.MBeanInvoker;
import org.jboss.mx.server.ObjectInputStreamWithClassLoader;
import org.jboss.mx.server.ServerConstants;
import org.jboss.mx.server.registry.MBeanEntry;
import org.jboss.mx.server.registry.MBeanRegistry;
import org.jboss.mx.service.ServiceConstants;

public class MBeanServerImpl
implements MBeanServer,
ServerConstants,
ServiceConstants,
ModelMBeanConstants {
    private static final Object[] NOPARAMS = new Object[0];
    private static final String[] NOSIG = new String[0];
    protected MBeanServer outer = null;
    protected MBeanRegistry registry = null;
    private MBeanServerListenerRegistry listeners = new MBeanServerListenerRegistry();
    private ClassLoaderRepository classLoaderRepository;
    private static Logger log = Logger.getLogger(class$org$jboss$mx$server$MBeanServerImpl == null ? (class$org$jboss$mx$server$MBeanServerImpl = MBeanServerImpl.class$("org.jboss.mx.server.MBeanServerImpl")) : class$org$jboss$mx$server$MBeanServerImpl);
    static /* synthetic */ Class class$org$jboss$mx$server$MBeanServerImpl;
    static /* synthetic */ Class class$javax$management$ObjectName;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$javax$management$MBeanServer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$management$ObjectInstance;
    static /* synthetic */ Class class$org$jboss$mx$server$registry$MBeanEntry;

    public MBeanServerImpl(String defaultDomain, MBeanServer outer, MBeanServerDelegate delegate) {
        this.outer = outer == null ? this : outer;
        this.classLoaderRepository = this.getClassLoaderRepository();
        this.registry = this.createRegistry(defaultDomain);
        try {
            HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put("JMImplementation", "JMImplementation");
            this.registry.registerMBean(delegate, new ObjectName("JMImplementation:type=MBeanServerDelegate"), valueMap);
            ModelMBean rmm = RequiredModelMBeanInstantiator.instantiate();
            rmm.setModelMBeanInfo(this.getRegistryManagementInterface());
            rmm.setManagedResource(this.registry, "ObjectReference");
            this.registry.registerMBean(rmm, new ObjectName("JMImplementation:type=MBeanRegistry"), valueMap);
            String loaderClassMBeanName = this.classLoaderRepository.getClass().getName() + "MBean";
            ClassLoader cl = this.classLoaderRepository.getClass().getClassLoader();
            Class<?> mbean = cl.loadClass(loaderClassMBeanName);
            ObjectName loaderName = new ObjectName("JMImplementation:service=LoaderRepository,name=Default");
            this.registry.registerMBean(this.classLoaderRepository, loaderName, valueMap);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
        }
        catch (MBeanException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
        catch (InvalidTargetObjectTypeException e) {
            e.printStackTrace();
        }
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.instantiate(className, (ClassLoader)null, NOPARAMS, NOSIG);
    }

    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        return this.instantiate(className, (ClassLoader)null, params, signature);
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.instantiate(className, loaderName, NOPARAMS, NOSIG);
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        ClassLoader cl = null;
        try {
            if (loaderName != null) {
                cl = (ClassLoader)this.registry.get(loaderName).getResourceInstance();
            }
        }
        catch (ClassCastException e) {
            throw new ReflectionException(e, loaderName + " is not a class loader.");
        }
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        return this.instantiate(className, cl, params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        Object mbean = this.instantiate(className);
        return this.registerMBean(mbean, name, (ClassLoader)null);
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        Object mbean = this.instantiate(className, params, signature);
        return this.registerMBean(mbean, name, (ClassLoader)null);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Object mbean = this.instantiate(className, loaderName);
        return this.registerMBean(mbean, name, loaderName);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Object mbean = this.instantiate(className, loaderName, params, signature);
        return this.registerMBean(mbean, name, loaderName);
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.registerMBean(object, name, (ClassLoader)null);
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        MBeanEntry entry = this.registry.get(name);
        Object mbean = entry.getResourceInstance();
        name = entry.getObjectName();
        try {
            this.invoke(new ObjectName("JMImplementation:type=MBeanRegistry"), "unregisterMBean", new Object[]{name}, new String[]{(class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = MBeanServerImpl.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName()});
        }
        catch (Exception e) {
            Exception result = this.handleInvocationException(e);
            if (result instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)result;
            }
            if (result instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)result;
            }
            throw new RuntimeException(result.toString());
        }
        if (mbean instanceof NotificationBroadcaster) {
            this.listeners.remove(name);
        }
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.registry.getObjectInstance(name);
    }

    public Set queryMBeans(ObjectName name, QueryExp query) {
        HashSet<ObjectInstance> result = new HashSet<ObjectInstance>();
        if (query != null) {
            query.setMBeanServer(this.outer);
        }
        List entries = this.registry.findEntries(name);
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            MBeanEntry entry = (MBeanEntry)iterator.next();
            ObjectName objectName = entry.getObjectName();
            if (!this.queryMBean(objectName, query)) continue;
            try {
                ObjectInstance instance = this.registry.getObjectInstance(objectName);
                result.add(instance);
            }
            catch (InstanceNotFoundException ignored) {}
        }
        return result;
    }

    public Set queryNames(ObjectName name, QueryExp query) {
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        if (query != null) {
            query.setMBeanServer(this.outer);
        }
        List entries = this.registry.findEntries(name);
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            MBeanEntry entry = (MBeanEntry)iterator.next();
            ObjectName objectName = entry.getObjectName();
            if (!this.queryMBean(objectName, query)) continue;
            result.add(objectName);
        }
        return result;
    }

    public boolean isRegistered(ObjectName name) {
        return this.registry.contains(name);
    }

    public Integer getMBeanCount() {
        return new Integer(this.registry.getSize());
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        MBeanEntry entry = this.registry.get(name);
        MBeanInvoker mbean = entry.getInvoker();
        return mbean.getAttribute(attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        MBeanEntry entry = this.registry.get(name);
        MBeanInvoker mbean = entry.getInvoker();
        return mbean.getAttributes(attributes);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        MBeanEntry entry = this.registry.get(name);
        MBeanInvoker mbean = entry.getInvoker();
        mbean.setAttribute(attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        MBeanEntry entry = this.registry.get(name);
        MBeanInvoker mbean = entry.getInvoker();
        return mbean.setAttributes(attributes);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        MBeanEntry entry = this.registry.get(name);
        MBeanInvoker mbean = entry.getInvoker();
        return mbean.invoke(operationName, params, signature);
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        MBeanEntry entry = this.registry.get(name);
        MBeanInvoker invoker = entry.getInvoker();
        return invoker.getMBeanInfo();
    }

    public String getDefaultDomain() {
        return this.registry.getDefaultDomain();
    }

    public String[] getDomains() {
        return this.registry.getDomains();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        MBeanEntry entry = this.registry.get(name);
        ClassLoader newTCL = entry.getClassLoader();
        MBeanInvoker broadcaster = entry.getInvoker();
        Thread thread = Thread.currentThread();
        ClassLoader oldTCL = thread.getContextClassLoader();
        try {
            if (newTCL != oldTCL && newTCL != null) {
                thread.setContextClassLoader(newTCL);
            }
            this.listeners.add(entry.getObjectName(), broadcaster, listener, filter, handback);
            Object var11_10 = null;
            if (newTCL != oldTCL && newTCL != null) {
                thread.setContextClassLoader(oldTCL);
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (newTCL != oldTCL && newTCL != null) {
                thread.setContextClassLoader(oldTCL);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        MBeanEntry entry = this.registry.get(name);
        ClassLoader newTCL = entry.getClassLoader();
        MBeanInvoker broadcaster = entry.getInvoker();
        Thread thread = Thread.currentThread();
        ClassLoader oldTCL = thread.getContextClassLoader();
        try {
            if (newTCL != oldTCL && newTCL != null) {
                thread.setContextClassLoader(newTCL);
            }
            this.listeners.add(entry.getObjectName(), broadcaster, (NotificationListener)this.registry.get(listener).getResourceInstance(), filter, handback);
            Object var11_10 = null;
            if (newTCL != oldTCL && newTCL != null) {
                thread.setContextClassLoader(oldTCL);
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (newTCL != oldTCL && newTCL != null) {
                thread.setContextClassLoader(oldTCL);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        MBeanEntry entry = this.registry.get(name);
        ClassLoader newTCL = entry.getClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader oldTCL = thread.getContextClassLoader();
        try {
            if (newTCL != oldTCL && newTCL != null) {
                thread.setContextClassLoader(newTCL);
            }
            this.listeners.remove(entry.getObjectName(), listener);
            Object var8_7 = null;
            if (newTCL != oldTCL && newTCL != null) {
                thread.setContextClassLoader(oldTCL);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (newTCL != oldTCL && newTCL != null) {
                thread.setContextClassLoader(oldTCL);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        MBeanEntry entry = this.registry.get(name);
        ClassLoader newTCL = entry.getClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader oldTCL = thread.getContextClassLoader();
        try {
            if (newTCL != oldTCL && newTCL != null) {
                thread.setContextClassLoader(newTCL);
            }
            this.listeners.remove(entry.getObjectName(), (NotificationListener)this.registry.get(listener).getResourceInstance());
            Object var8_7 = null;
            if (newTCL != oldTCL && newTCL != null) {
                thread.setContextClassLoader(oldTCL);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (newTCL != oldTCL && newTCL != null) {
                thread.setContextClassLoader(oldTCL);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        MBeanEntry entry = this.registry.get(name);
        ClassLoader newTCL = entry.getClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader oldTCL = thread.getContextClassLoader();
        try {
            if (newTCL != oldTCL && newTCL != null) {
                thread.setContextClassLoader(newTCL);
            }
            this.listeners.remove(entry.getObjectName(), listener, filter, handback);
            Object var10_9 = null;
            if (newTCL != oldTCL && newTCL != null) {
                thread.setContextClassLoader(oldTCL);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (newTCL != oldTCL && newTCL != null) {
                thread.setContextClassLoader(oldTCL);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        MBeanEntry entry = this.registry.get(name);
        ClassLoader newTCL = entry.getClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader oldTCL = thread.getContextClassLoader();
        try {
            if (newTCL != oldTCL && newTCL != null) {
                thread.setContextClassLoader(newTCL);
            }
            this.listeners.remove(entry.getObjectName(), (NotificationListener)this.registry.get(listener).getResourceInstance(), filter, handback);
            Object var10_9 = null;
            if (newTCL != oldTCL && newTCL != null) {
                thread.setContextClassLoader(oldTCL);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (newTCL != oldTCL && newTCL != null) {
                thread.setContextClassLoader(oldTCL);
            }
            throw throwable;
        }
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        String mbeanClassName = null;
        try {
            mbeanClassName = this.getMBeanInfo(name).getClassName();
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            return false;
        }
        if (className.equals(mbeanClassName)) {
            return true;
        }
        Class<?> mbeanClass = null;
        Class<?> testClass = null;
        ClassLoader cl = this.getClassLoaderFor(name);
        try {
            mbeanClass = cl.loadClass(mbeanClassName);
            testClass = cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return testClass.isAssignableFrom(mbeanClass);
    }

    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        try {
            ClassLoader cl = this.getClassLoaderFor(name);
            return new ObjectInputStreamWithClassLoader(new ByteArrayInputStream(data), cl);
        }
        catch (IOException e) {
            throw new OperationsException("I/O exception deserializing: " + e.getMessage());
        }
    }

    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        try {
            Class c = this.classLoaderRepository.loadClass(className);
            ClassLoader cl = c.getClassLoader();
            return new ObjectInputStreamWithClassLoader(new ByteArrayInputStream(data), cl);
        }
        catch (IOException e) {
            throw new OperationsException("I/O exception deserializing: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e, "Class not found from default repository: " + className);
        }
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        try {
            ClassLoader cl = (ClassLoader)this.registry.get(loaderName).getResourceInstance();
            return new ObjectInputStreamWithClassLoader(new ByteArrayInputStream(data), cl);
        }
        catch (IOException e) {
            throw new OperationsException("I/O exception deserializing: " + e.getMessage());
        }
    }

    public ClassLoader getClassLoaderFor(ObjectName name) throws InstanceNotFoundException {
        MBeanEntry entry = this.registry.get(name);
        ClassLoader cl = entry.getClassLoader();
        if (cl == null) {
            cl = entry.getResourceInstance().getClass().getClassLoader();
        }
        return cl;
    }

    public ClassLoader getClassLoader(ObjectName name) throws InstanceNotFoundException {
        MBeanEntry entry = this.registry.get(name);
        Object cl = entry.getResourceInstance();
        if (!(cl instanceof ClassLoader)) {
            throw new InstanceNotFoundException("Not a classloader " + name);
        }
        return (ClassLoader)cl;
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        if (this.classLoaderRepository == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            String className = System.getProperty("jbossmx.loader.repository.class", "org.jboss.mx.loading.UnifiedLoaderRepository3");
            System.setProperty("jbossmx.loader.repository.class", className);
            try {
                Class<?> repository = cl.loadClass(className);
                this.classLoaderRepository = (ClassLoaderRepository)repository.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new Error("Cannot instantiate loader repository class: " + className);
            }
            catch (ClassCastException e) {
                throw new Error("Loader repository is not an instance of LoaderRepository: " + className);
            }
            catch (Exception e) {
                throw new Error("Error creating loader repository: " + e);
            }
        }
        return this.classLoaderRepository;
    }

    public void releaseServer() {
        this.registry.releaseRegistry();
        this.listeners.removeAll();
        this.listeners = null;
        this.registry = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object instantiate(String className, ClassLoader cl, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        if (className == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null className"));
        }
        if (className.equals("")) {
            throw new ReflectionException(new ClassNotFoundException("empty class name"));
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldTCL = thread.getContextClassLoader();
        try {
            Class<?> clazz = null;
            if (cl != null) {
                if (cl != oldTCL) {
                    thread.setContextClassLoader(cl);
                }
                clazz = cl.loadClass(className);
            } else {
                clazz = this.classLoaderRepository.loadClass(className);
            }
            Class[] sign = new Class[signature.length];
            for (int i = 0; i < signature.length; ++i) {
                if (LoaderRepository.getNativeClassForName(signature[i]) == null) {
                    try {
                        if (cl != null) {
                            sign[i] = cl.loadClass(signature[i]);
                            continue;
                        }
                        sign[i] = this.classLoaderRepository.loadClass(signature[i]);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new ReflectionException(e, "Constructor parameter class not found: " + signature[i]);
                    }
                }
                sign[i] = LoaderRepository.getNativeClassForName(signature[i]);
            }
            Constructor<?> constructor = clazz.getConstructor(sign);
            Object obj = constructor.newInstance(params);
            Object var12_15 = null;
            if (cl != null && cl != oldTCL) {
                thread.setContextClassLoader(oldTCL);
            }
            return obj;
        }
        catch (Throwable t) {
            try {
                this.handleInstantiateExceptions(t, className);
                log.error("Unhandled exception instantiating class: " + className, t);
                Object var8_10 = null;
                Object var12_16 = null;
                if (cl != null && cl != oldTCL) {
                    thread.setContextClassLoader(oldTCL);
                }
                return var8_10;
            }
            catch (Throwable throwable) {
                block16: {
                    Object var12_17 = null;
                    if (cl == null || cl == oldTCL) break block16;
                    thread.setContextClassLoader(oldTCL);
                }
                throw throwable;
            }
        }
    }

    protected void handleInstantiateExceptions(Throwable t, String className) throws ReflectionException, MBeanException {
        if (t instanceof ClassNotFoundException) {
            throw new ReflectionException((Exception)t, "Class not found: " + className);
        }
        if (t instanceof InstantiationException) {
            throw new ReflectionException((Exception)t, "Cannot instantiate with no-args constructor: " + className);
        }
        if (t instanceof IllegalAccessException) {
            throw new ReflectionException((Exception)t, "Illegal access to default constructor: " + className);
        }
        if (t instanceof NoSuchMethodException) {
            throw new ReflectionException((Exception)t, className + " does not have a public no args constructor.");
        }
        if (t instanceof SecurityException) {
            throw new ReflectionException((Exception)t, "Can't access default constructor for " + className + ": " + t.toString());
        }
        if (t instanceof InvocationTargetException) {
            Throwable root = ((InvocationTargetException)t).getTargetException();
            if (root instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)root, className + " constructor has thrown an exception: " + root.toString());
            }
            if (root instanceof Error) {
                throw new RuntimeErrorException((Error)root, className + " constructor has thrown an error: " + root.toString());
            }
            if (root instanceof Exception) {
                throw new MBeanException((Exception)root, className + " constructor has thrown an exception: " + root.toString());
            }
            throw new Error("Something went wrong with handling the exception from " + className + " default constructor.");
        }
        if (t instanceof ExceptionInInitializerError) {
            Throwable root = ((ExceptionInInitializerError)t).getException();
            if (root instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)root, "Exception in class " + className + " static initializer: " + root.toString());
            }
            throw new Error("ERROR: it turns out the root cause is not always a runtime exception!");
        }
        if (t instanceof IllegalArgumentException) {
            throw new Error("Error in the server: mismatch between expected constructor arguments and supplied arguments.");
        }
        if (t instanceof Error) {
            throw new RuntimeErrorException((Error)t, "instantiating " + className + " failed: " + t.toString());
        }
    }

    protected ObjectInstance registerMBean(Object mbean, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)this.registry.get(loaderName).getResourceInstance();
        }
        catch (ClassCastException e) {
            throw new ReflectionException(e, loaderName + " is not a class loader.");
        }
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        return this.registerMBean(mbean, name, cl);
    }

    protected ObjectInstance registerMBean(Object object, ObjectName name, ClassLoader cl) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        HashMap<String, ClassLoader> valueMap = null;
        if (cl != null) {
            valueMap = new HashMap<String, ClassLoader>();
            valueMap.put("org.jboss.mx.classloader", cl);
        }
        try {
            return (ObjectInstance)this.invoke(new ObjectName("JMImplementation:type=MBeanRegistry"), "registerMBean", new Object[]{object, name, valueMap}, new String[]{(class$java$lang$Object == null ? (class$java$lang$Object = MBeanServerImpl.class$("java.lang.Object")) : class$java$lang$Object).getName(), (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = MBeanServerImpl.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName(), (class$java$util$Map == null ? (class$java$util$Map = MBeanServerImpl.class$("java.util.Map")) : class$java$util$Map).getName()});
        }
        catch (Exception e) {
            Exception result = this.handleInvocationException(e);
            if (result instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)result;
            }
            if (result instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)result;
            }
            if (result instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)result;
            }
            throw new RuntimeException(result.toString());
        }
    }

    private Exception handleInvocationException(Exception e) {
        if (e instanceof MBeanException) {
            return ((MBeanException)e).getTargetException();
        }
        if (e instanceof RuntimeOperationsException) {
            throw ((RuntimeOperationsException)e).getTargetException();
        }
        if (e instanceof ReflectionException) {
            Exception target = ((ReflectionException)e).getTargetException();
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            throw new RuntimeException(target.toString());
        }
        if (e instanceof RuntimeMBeanException) {
            throw ((RuntimeMBeanException)e).getTargetException();
        }
        if (e instanceof RuntimeErrorException) {
            throw ((RuntimeErrorException)e).getTargetError();
        }
        throw new RuntimeException(e.toString());
    }

    protected boolean queryMBean(ObjectName objectName, QueryExp queryExp) {
        if (queryExp == null) {
            return true;
        }
        try {
            return queryExp.apply(objectName);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected MBeanRegistry createRegistry(String defaultDomain) {
        String registryClass = System.getProperty("jbossmx.mbean.registry.class", "org.jboss.mx.server.registry.BasicMBeanRegistry");
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = cl.loadClass(registryClass);
            Constructor<?> constructor = clazz.getConstructor(class$javax$management$MBeanServer == null ? (class$javax$management$MBeanServer = MBeanServerImpl.class$("javax.management.MBeanServer")) : class$javax$management$MBeanServer, class$java$lang$String == null ? (class$java$lang$String = MBeanServerImpl.class$("java.lang.String")) : class$java$lang$String);
            return (MBeanRegistry)constructor.newInstance(this.outer, defaultDomain);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("The MBean registry implementation class " + registryClass + " was not found: " + e.toString());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The MBean registry implementation class " + registryClass + " must contain a default <init>(MBeanServer srvr, String domain) " + " constructor.");
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate class " + registryClass + ": " + e.toString());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable to create the MBean registry instance. Illegal access to class " + registryClass + " constructor: " + e.toString());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unable to create the MBean registry instance. Class " + registryClass + " has raised an exception in constructor: " + e.getTargetException().toString());
        }
    }

    private ModelMBeanInfo getRegistryManagementInterface() {
        boolean READABLE = true;
        boolean WRITABLE = true;
        boolean BOOLEAN = true;
        DescriptorSupport descDefaultDomain = new DescriptorSupport();
        descDefaultDomain.setField("name", "DefaultDomain");
        descDefaultDomain.setField("descriptorType", "attribute");
        descDefaultDomain.setField("displayName", "Default Domain");
        descDefaultDomain.setField("default", this.getDefaultDomain());
        descDefaultDomain.setField("currencyTimeLimit", "-1");
        ModelMBeanAttributeInfo defaultDomainInfo = new ModelMBeanAttributeInfo("DefaultDomain", (class$java$lang$String == null ? (class$java$lang$String = MBeanServerImpl.class$("java.lang.String")) : class$java$lang$String).getName(), "The domain to use when an object name has no domain", true, false, false, descDefaultDomain);
        DescriptorSupport descSize = new DescriptorSupport();
        descSize.setField("name", "Size");
        descSize.setField("descriptorType", "attribute");
        descSize.setField("displayName", "Size");
        descSize.setField("getMethod", "getSize");
        ModelMBeanAttributeInfo sizeInfo = new ModelMBeanAttributeInfo("Size", Integer.TYPE.getName(), "The number of MBeans registered in the MBean Server", true, false, false, descSize);
        DescriptorSupport descRegisterMBean = new DescriptorSupport();
        descRegisterMBean.setField("name", "registerMBean");
        descRegisterMBean.setField("descriptorType", "operation");
        descRegisterMBean.setField("role", "operation");
        MBeanParameterInfo[] registerMBeanParms = new MBeanParameterInfo[]{new MBeanParameterInfo("Resource", (class$java$lang$Object == null ? (class$java$lang$Object = MBeanServerImpl.class$("java.lang.Object")) : class$java$lang$Object).getName(), "A compliant MBean to be registered in the MBean Server"), new MBeanParameterInfo("ObjectName", (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = MBeanServerImpl.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName(), "The object name of the MBean"), new MBeanParameterInfo("ValueMap", (class$java$util$Map == null ? (class$java$util$Map = MBeanServerImpl.class$("java.util.Map")) : class$java$util$Map).getName(), "Values associated with the registration")};
        ModelMBeanOperationInfo registerMBeanInfo = new ModelMBeanOperationInfo("registerMBean", "Adds an MBean in the MBeanServer", registerMBeanParms, (class$javax$management$ObjectInstance == null ? (class$javax$management$ObjectInstance = MBeanServerImpl.class$("javax.management.ObjectInstance")) : class$javax$management$ObjectInstance).getName(), 2, descRegisterMBean);
        DescriptorSupport descUnregisterMBean = new DescriptorSupport();
        descUnregisterMBean.setField("name", "unregisterMBean");
        descUnregisterMBean.setField("descriptorType", "operation");
        descUnregisterMBean.setField("role", "operation");
        MBeanParameterInfo[] unregisterMBeanParms = new MBeanParameterInfo[]{new MBeanParameterInfo("ObjectName", (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = MBeanServerImpl.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName(), "The object name of the MBean to remove")};
        ModelMBeanOperationInfo unregisterMBeanInfo = new ModelMBeanOperationInfo("unregisterMBean", "Removes an MBean from the MBeanServer", unregisterMBeanParms, Void.TYPE.getName(), 1, descUnregisterMBean);
        DescriptorSupport descGetSize = new DescriptorSupport();
        descGetSize.setField("name", "getSize");
        descGetSize.setField("descriptorType", "operation");
        descGetSize.setField("role", "operation");
        MBeanParameterInfo[] getSizeParms = new MBeanParameterInfo[]{};
        ModelMBeanOperationInfo getSizeInfo = new ModelMBeanOperationInfo("getSize", "Gets the number of MBeans registered", getSizeParms, Integer.TYPE.getName(), 0, descGetSize);
        DescriptorSupport descGet = new DescriptorSupport();
        descGet.setField("name", "get");
        descGet.setField("descriptorType", "operation");
        descGet.setField("role", "operation");
        MBeanParameterInfo[] getParam = new MBeanParameterInfo[]{new MBeanParameterInfo("ObjectName", (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = MBeanServerImpl.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName(), "object name to find")};
        ModelMBeanOperationInfo getInfo = new ModelMBeanOperationInfo("get", "Gets the MBeanEntry for a given ObjectName", getParam, (class$org$jboss$mx$server$registry$MBeanEntry == null ? (class$org$jboss$mx$server$registry$MBeanEntry = MBeanServerImpl.class$("org.jboss.mx.server.registry.MBeanEntry")) : class$org$jboss$mx$server$registry$MBeanEntry).getName(), 0, descGet);
        DescriptorSupport descGetValue = new DescriptorSupport();
        descGetValue.setField("name", "getValue");
        descGetValue.setField("descriptorType", "operation");
        descGetValue.setField("role", "operation");
        MBeanParameterInfo[] getValueParms = new MBeanParameterInfo[]{new MBeanParameterInfo("ObjectName", (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = MBeanServerImpl.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName(), "The object name of the registered MBean"), new MBeanParameterInfo("Key", (class$java$lang$String == null ? (class$java$lang$String = MBeanServerImpl.class$("java.lang.String")) : class$java$lang$String).getName(), "The key to the value stored")};
        ModelMBeanOperationInfo getValueInfo = new ModelMBeanOperationInfo("getValue", "Get a value stored in the MBean's registration", getValueParms, (class$java$lang$Object == null ? (class$java$lang$Object = MBeanServerImpl.class$("java.lang.Object")) : class$java$lang$Object).getName(), 0, descGetValue);
        DescriptorSupport descMBean = new DescriptorSupport();
        descMBean.setField("name", "MBeanRegistry");
        descMBean.setField("descriptorType", "MBean");
        descMBean.setField("displayName", "MBeanServer Registry");
        ModelMBeanAttributeInfo[] attrInfo = new ModelMBeanAttributeInfo[]{defaultDomainInfo, sizeInfo};
        ModelMBeanConstructorInfo[] ctorInfo = null;
        ModelMBeanOperationInfo[] opInfo = new ModelMBeanOperationInfo[]{registerMBeanInfo, unregisterMBeanInfo, getSizeInfo, getValueInfo, getInfo};
        ModelMBeanNotificationInfo[] notifyInfo = null;
        ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(RequiredModelMBeanInstantiator.getClassName(), "Managed Bean Registry", attrInfo, ctorInfo, opInfo, notifyInfo, descMBean);
        return info;
    }

    public String toString() {
        return super.toString() + "[ defaultDomain='" + this.getDefaultDomain() + "' ]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

