/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.jboss.mx.modelmbean.ModelMBeanConstants;
import org.jboss.mx.server.MethodMapper;

public class MBeanInfoConversion
implements ModelMBeanConstants {
    public static ModelMBeanInfoSupport toModelMBeanInfo(MBeanInfo info) {
        return MBeanInfoConversion.toModelMBeanInfo(info, true);
    }

    public static ModelMBeanInfoSupport toModelMBeanInfo(MBeanInfo info, boolean createAttributeOperationMapping) {
        int i;
        if (info instanceof ModelMBeanInfoSupport) {
            return (ModelMBeanInfoSupport)info;
        }
        if (info instanceof ModelMBeanInfo) {
            return new ModelMBeanInfoSupport((ModelMBeanInfo)((Object)info));
        }
        MBeanAttributeInfo[] attributes = info.getAttributes();
        ModelMBeanAttributeInfo[] mmbAttributes = new ModelMBeanAttributeInfo[attributes.length];
        ArrayList<ModelMBeanOperationInfo> accessorOperations = new ArrayList<ModelMBeanOperationInfo>();
        for (int i2 = 0; i2 < attributes.length; ++i2) {
            Descriptor attrDescriptor;
            ModelMBeanOperationInfo opInfo;
            ModelMBeanAttributeInfo attrInfo = new ModelMBeanAttributeInfo(attributes[i2].getName(), attributes[i2].getType(), attributes[i2].getDescription(), attributes[i2].isReadable(), attributes[i2].isWritable(), attributes[i2].isIs());
            Descriptor d = attrInfo.getDescriptor();
            d.setField("currencyTimeLimit", "0");
            attrInfo.setDescriptor(d);
            mmbAttributes[i2] = attrInfo;
            if (!createAttributeOperationMapping) continue;
            String getterOperationName = null;
            String setterOperationName = null;
            DescriptorSupport getterDescriptor = null;
            DescriptorSupport setterDescriptor = null;
            if (attributes[i2].isReadable()) {
                getterOperationName = attributes[i2].isIs() ? "is" + attributes[i2].getName() : "get" + attributes[i2].getName();
                getterDescriptor = new DescriptorSupport();
                getterDescriptor.setField("name", getterOperationName);
                getterDescriptor.setField("descriptortype", "operation");
                getterDescriptor.setField("role", "getter");
                opInfo = new ModelMBeanOperationInfo(getterOperationName, "Read accessor operation for '" + attributes[i2].getName() + "' attribute.", new MBeanParameterInfo[0], attributes[i2].getType(), 0, getterDescriptor);
                attrDescriptor = mmbAttributes[i2].getDescriptor();
                attrDescriptor.setField("getMethod", getterOperationName);
                mmbAttributes[i2].setDescriptor(attrDescriptor);
                accessorOperations.add(opInfo);
            }
            if (!attributes[i2].isWritable()) continue;
            setterOperationName = "set" + attributes[i2].getName();
            setterDescriptor = new DescriptorSupport();
            setterDescriptor.setField("name", setterOperationName);
            setterDescriptor.setField("descriptortype", "operation");
            setterDescriptor.setField("role", "setter");
            opInfo = new ModelMBeanOperationInfo(setterOperationName, "Write accessor operation for '" + attributes[i2].getName() + "' attribute.", new MBeanParameterInfo[]{new MBeanParameterInfo("value", attributes[i2].getType(), "Attribute's value.")}, Void.TYPE.getName(), 1, setterDescriptor);
            attrDescriptor = mmbAttributes[i2].getDescriptor();
            attrDescriptor.setField("setMethod", setterOperationName);
            mmbAttributes[i2].setDescriptor(attrDescriptor);
            accessorOperations.add(opInfo);
        }
        MBeanOperationInfo[] operations = info.getOperations();
        ModelMBeanOperationInfo[] mmbOperations = new ModelMBeanOperationInfo[operations.length + accessorOperations.size()];
        for (i = 0; i < operations.length; ++i) {
            mmbOperations[i] = new ModelMBeanOperationInfo(operations[i].getName(), operations[i].getDescription(), operations[i].getSignature(), operations[i].getReturnType(), operations[i].getImpact());
        }
        for (i = operations.length; i < mmbOperations.length; ++i) {
            mmbOperations[i] = (ModelMBeanOperationInfo)accessorOperations.get(i - operations.length);
        }
        MBeanConstructorInfo[] constructors = info.getConstructors();
        ModelMBeanConstructorInfo[] mmbConstructors = new ModelMBeanConstructorInfo[constructors.length];
        for (int i3 = 0; i3 < constructors.length; ++i3) {
            mmbConstructors[i3] = new ModelMBeanConstructorInfo(constructors[i3].getName(), constructors[i3].getDescription(), constructors[i3].getSignature());
        }
        MBeanNotificationInfo[] notifications = info.getNotifications();
        ModelMBeanNotificationInfo[] mmbNotifications = new ModelMBeanNotificationInfo[notifications.length];
        for (int i4 = 0; i4 < notifications.length; ++i4) {
            mmbNotifications[i4] = new ModelMBeanNotificationInfo(notifications[i4].getNotifTypes(), notifications[i4].getName(), notifications[i4].getDescription());
        }
        return new ModelMBeanInfoSupport(info.getClassName(), info.getDescription(), mmbAttributes, mmbConstructors, mmbOperations, mmbNotifications);
    }

    public static ModelMBeanInfoSupport stripAttributeOperations(ModelMBeanInfo info, boolean stripAllRoles) throws MBeanException {
        HashMap<String, ModelMBeanOperationInfo> opsMap = new HashMap<String, ModelMBeanOperationInfo>();
        ModelMBeanOperationInfo[] operations = (ModelMBeanOperationInfo[])info.getOperations();
        for (int i = 0; i < operations.length; ++i) {
            opsMap.put(MethodMapper.operationSignature(operations[i]), operations[i]);
        }
        ModelMBeanAttributeInfo[] attributes = (ModelMBeanAttributeInfo[])info.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            String key;
            ModelMBeanOperationInfo opinfo;
            String role;
            if (attributes[i].isReadable() && attributes[i].getDescriptor().getFieldValue("getMethod") != null && ("getter".equals(role = (String)(opinfo = (ModelMBeanOperationInfo)opsMap.get(key = MethodMapper.getterSignature(attributes[i]))).getDescriptor().getFieldValue("role")) || stripAllRoles)) {
                opsMap.remove(key);
            }
            if (!attributes[i].isWritable() || attributes[i].getDescriptor().getFieldValue("setMethod") == null || !"setter".equals(role = (String)(opinfo = (ModelMBeanOperationInfo)opsMap.get(key = MethodMapper.setterSignature(attributes[i]))).getDescriptor().getFieldValue("role")) && !stripAllRoles) continue;
            opsMap.remove(key);
        }
        operations = new ModelMBeanOperationInfo[opsMap.size()];
        int position = 0;
        Iterator iterator = opsMap.values().iterator();
        while (iterator.hasNext()) {
            operations[position] = (ModelMBeanOperationInfo)iterator.next();
            ++position;
        }
        return new ModelMBeanInfoSupport(info.getClassName(), info.getDescription(), (ModelMBeanAttributeInfo[])info.getAttributes(), (ModelMBeanConstructorInfo[])info.getConstructors(), operations, (ModelMBeanNotificationInfo[])info.getNotifications(), info.getMBeanDescriptor());
    }
}

