/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.ClassLoadingTask;
import org.jboss.mx.loading.UnifiedClassLoader4;
import org.jboss.mx.loading.UnifiedLoaderRepository4;

public class LoadMgr4 {
    private static Logger log = Logger.getLogger(class$org$jboss$mx$loading$LoadMgr4 == null ? (class$org$jboss$mx$loading$LoadMgr4 = LoadMgr4.class$("org.jboss.mx.loading.LoadMgr4")) : class$org$jboss$mx$loading$LoadMgr4);
    private static Object registrationLock = new Object();
    private static HashMap loadClassThreads = new HashMap();
    private static Map loadTasksByThread = Collections.synchronizedMap(new WeakHashMap());
    static /* synthetic */ Class class$org$jboss$mx$loading$LoadMgr4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLoaderThread(UnifiedClassLoader4 ucl, Thread t) {
        Object object = registrationLock;
        synchronized (object) {
            Thread prevThread = loadClassThreads.put(ucl, t);
            if (log.isTraceEnabled()) {
                log.trace("registerLoaderThread, ucl=" + ucl + ", t=" + t + ", prevT=" + prevThread);
            }
            Map map = loadTasksByThread;
            synchronized (map) {
                List taskList = (List)loadTasksByThread.get(t);
                if (taskList == null) {
                    taskList = Collections.synchronizedList(new LinkedList());
                    loadTasksByThread.put(t, taskList);
                    if (log.isTraceEnabled()) {
                        log.trace("created new task list");
                    }
                }
            }
            registrationLock.notifyAll();
        }
    }

    public static boolean beginLoadTask(ClassLoadingTask task, UnifiedLoaderRepository4 repository) throws ClassNotFoundException {
        Class cls;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Begin beginLoadTask, task=" + task);
        }
        if ((cls = repository.loadClassFromCache(task.classname)) != null) {
            task.loadedClass = cls;
            task.state = 4;
            if (trace) {
                log.trace("End beginLoadTask, loadClassFromCache");
            }
            return true;
        }
        UnifiedClassLoader4 ucl = repository.getClassLoader(task.classname);
        if (ucl == null) {
            try {
                cls = repository.loadClassFromClassLoader(task.classname, false, task.requestingClassLoader);
            }
            catch (LinkageError e) {
                if (trace) {
                    log.trace("End beginLoadTask, LinkageError for task: " + task, e);
                }
                throw e;
            }
            if (cls != null) {
                task.loadedClass = cls;
                task.state = 4;
                if (trace) {
                    log.trace("End beginLoadTask, loadClassFromClassLoader");
                }
                return true;
            }
            if (trace) {
                log.trace("End beginLoadTask, ClassNotFoundException");
            }
            String msg = "No ClassLoaders found for: " + task.classname;
            throw new ClassNotFoundException(msg);
        }
        LoadMgr4.scheduleTask(task, ucl, 0, false, trace);
        task.state = 1;
        if (trace) {
            log.trace("End beginLoadTask, task=" + task);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void nextTask(Thread t, ClassLoadingTask task, UnifiedLoaderRepository4 repository) throws InterruptedException {
        ClassLoadingTask loadTask;
        ClassLoadingTask.ThreadTask threadTask;
        List taskList;
        boolean trace;
        block38: {
            Object object;
            trace = log.isTraceEnabled();
            taskList = (List)loadTasksByThread.get(t);
            ClassLoadingTask classLoadingTask = task;
            synchronized (classLoadingTask) {
                while (taskList.size() == 0 && task.threadTaskCount != 0) {
                    if (trace) {
                        log.trace("Begin nextTask(WAIT_ON_EVENT), task=" + task);
                    }
                    try {
                        task.state = 3;
                        task.wait();
                    }
                    catch (InterruptedException e) {
                        if (trace) {
                            log.trace("nextTask(WAIT_ON_EVENT), interrupted, task=" + task, e);
                        }
                        throw e;
                    }
                }
                if (trace) {
                    log.trace("Continue nextTask(" + taskList.size() + "), task=" + task);
                }
                if (task.threadTaskCount == 0) {
                    task.state = 4;
                    log.trace("End nextTask(FINISHED), task=" + task);
                    return;
                }
            }
            threadTask = (ClassLoadingTask.ThreadTask)taskList.remove(0);
            loadTask = threadTask.getLoadTask();
            if (trace) {
                log.trace("Begin nextTask(" + taskList.size() + "), loadTask=" + loadTask);
            }
            UnifiedClassLoader4 ucl4 = (UnifiedClassLoader4)threadTask.ucl;
            try {
                try {
                    if (threadTask.t == null) {
                        if (trace) {
                            log.trace("Rescheduling threadTask=" + threadTask);
                        }
                        LoadMgr4.scheduleTask(loadTask, ucl4, threadTask.order, true, trace);
                    } else {
                        if (trace) {
                            log.trace("Running threadTask=" + threadTask);
                        }
                        threadTask.run();
                    }
                }
                catch (Throwable e) {
                    loadTask.loadException = e;
                    if (trace) {
                        log.trace("Run failed with exception", e);
                    }
                    Object var10_10 = null;
                    if (threadTask.releaseInNextTask) {
                        if (trace) {
                            log.trace("Releasing loadLock and ownership of UCL: " + threadTask.ucl);
                        }
                        Object object2 = registrationLock;
                        synchronized (object2) {
                            loadClassThreads.remove(threadTask.ucl);
                        }
                        object2 = threadTask.ucl;
                        synchronized (object2) {
                            ucl4.release();
                            ucl4.notifyAll();
                        }
                    }
                    break block38;
                }
                Object var10_9 = null;
                if (!threadTask.releaseInNextTask) break block38;
                if (trace) {
                    log.trace("Releasing loadLock and ownership of UCL: " + threadTask.ucl);
                }
                object = registrationLock;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (threadTask.releaseInNextTask) {
                    if (trace) {
                        log.trace("Releasing loadLock and ownership of UCL: " + threadTask.ucl);
                    }
                    Object object3 = registrationLock;
                    synchronized (object3) {
                        loadClassThreads.remove(threadTask.ucl);
                    }
                    object3 = threadTask.ucl;
                    synchronized (object3) {
                        ucl4.release();
                        ucl4.notifyAll();
                    }
                }
                throw throwable;
            }
            synchronized (object) {
                loadClassThreads.remove(threadTask.ucl);
            }
            object = threadTask.ucl;
            synchronized (object) {
                ucl4.release();
                ucl4.notifyAll();
            }
        }
        if (loadTask.threadTaskCount == 0) {
            Class loadedClass = threadTask.getLoadedClass();
            if (loadedClass != null) {
                ClassLoader loader = loadedClass.getClassLoader();
                repository.cacheLoadedClass(threadTask.getClassname(), loadedClass, loader);
            }
            ClassLoadingTask classLoadingTask = loadTask;
            synchronized (classLoadingTask) {
                loadTask.state = 4;
                loadTask.notify();
            }
        }
        if (trace) {
            log.trace("End nextTask(" + taskList.size() + "), loadTask=" + loadTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endLoadTask(ClassLoadingTask task) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Begin endLoadTask, task=" + task);
        }
        Object object = registrationLock;
        synchronized (object) {
            loadClassThreads.remove(task.requestingClassLoader);
            registrationLock.notifyAll();
        }
        List taskList = (List)loadTasksByThread.get(task.requestingThread);
        if (taskList == null) {
            return;
        }
        List list = taskList;
        synchronized (list) {
            int size = taskList.size();
            for (int i = 0; i < size; ++i) {
                ClassLoadingTask loadTask;
                ClassLoadingTask.ThreadTask threadTask = (ClassLoadingTask.ThreadTask)taskList.remove(0);
                ClassLoadingTask classLoadingTask = loadTask = threadTask.getLoadTask();
                synchronized (classLoadingTask) {
                    if (trace) {
                        log.trace("Reassigning task: " + threadTask + ", to: " + loadTask.requestingThread);
                    }
                    threadTask.t = null;
                    List toTaskList = (List)loadTasksByThread.get(loadTask.requestingThread);
                    toTaskList.add(0, threadTask);
                    loadTask.state = 2;
                    loadTask.notify();
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleTask(ClassLoadingTask task, UnifiedClassLoader4 ucl, int order, boolean reschedule, boolean trace) throws ClassNotFoundException {
        Thread t = null;
        boolean releaseInNextTask = false;
        ClassLoadingTask.ThreadTask subtask = null;
        List taskList = null;
        Object object = registrationLock;
        synchronized (object) {
            t = (Thread)loadClassThreads.get(ucl);
            if (t == null) {
                while (t == null && !ucl.attempt(1L)) {
                    if (trace) {
                        log.trace("Waiting for owner of UCL: " + ucl);
                    }
                    try {
                        registrationLock.wait();
                    }
                    catch (InterruptedException e) {
                        String msg = "Interrupted waiting for registration notify, classame: " + task.classname;
                        throw new ClassNotFoundException(msg);
                    }
                    t = (Thread)loadClassThreads.get(ucl);
                    if (!trace) continue;
                    log.trace("Notified that UCL owner is: " + t);
                }
                t = (Thread)loadClassThreads.get(ucl);
                if (t == null) {
                    releaseInNextTask = true;
                    t = task.requestingThread;
                    Thread prevThread = loadClassThreads.put(ucl, t);
                    if (trace) {
                        log.trace("scheduleTask, taking ownership of ucl=" + ucl + ", t=" + t + ", prevT=" + prevThread);
                    }
                }
            }
            subtask = task.newThreadTask(ucl, t, order, reschedule, releaseInNextTask);
            List list = taskList = (List)loadTasksByThread.get(t);
            synchronized (list) {
                taskList.add(subtask);
            }
        }
        if (trace) {
            log.trace("scheduleTask(" + taskList.size() + "), created subtask: " + subtask);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class PkgClassLoader {
        public final UnifiedClassLoader4 ucl;
        public final int order;

        public PkgClassLoader(UnifiedClassLoader4 ucl) {
            this(ucl, Integer.MAX_VALUE);
        }

        public PkgClassLoader(UnifiedClassLoader4 ucl, int order) {
            this.ucl = ucl;
            this.order = order;
        }
    }
}

