/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.mx.loading.UnifiedClassLoader4;
import org.jboss.mx.loading.UnifiedLoaderRepository4;

public class HeirarchicalLoaderRepository4
extends UnifiedLoaderRepository4 {
    private static final Logger log = Logger.getLogger(class$org$jboss$mx$loading$HeirarchicalLoaderRepository3 == null ? (class$org$jboss$mx$loading$HeirarchicalLoaderRepository3 = HeirarchicalLoaderRepository4.class$("org.jboss.mx.loading.HeirarchicalLoaderRepository3")) : class$org$jboss$mx$loading$HeirarchicalLoaderRepository3);
    private static ObjectName DEFAULT_LOADER_NAME;
    private UnifiedLoaderRepository4 parentRepository;
    private boolean java2ParentDelegaton;
    static /* synthetic */ Class class$org$jboss$mx$loading$HeirarchicalLoaderRepository3;

    public HeirarchicalLoaderRepository4(MBeanServer server) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        this(server, DEFAULT_LOADER_NAME);
    }

    public HeirarchicalLoaderRepository4(MBeanServer server, ObjectName parentName) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        this.parentRepository = (UnifiedLoaderRepository4)server.getAttribute(parentName, "Instance");
    }

    public HeirarchicalLoaderRepository4(UnifiedLoaderRepository4 parentRepository) {
        this.parentRepository = parentRepository;
    }

    public UnifiedClassLoader newClassLoader(URL url, boolean addToRepository) throws Exception {
        UnifiedClassLoader4 ucl = null;
        ucl = !this.java2ParentDelegaton ? new UnifiedClassLoader4(url, null, (ClassLoader)new NoParentClassLoader(), this) : new UnifiedClassLoader4(url, null, this);
        if (addToRepository) {
            this.registerClassLoader(ucl);
        }
        return ucl;
    }

    public UnifiedClassLoader newClassLoader(URL url, URL origURL, boolean addToRepository) throws Exception {
        UnifiedClassLoader4 ucl = null;
        ucl = !this.java2ParentDelegaton ? new UnifiedClassLoader4(url, origURL, (ClassLoader)new NoParentClassLoader(), this) : new UnifiedClassLoader4(url, origURL, this);
        if (addToRepository) {
            this.registerClassLoader(ucl);
        }
        return ucl;
    }

    public boolean getUseParentFirst() {
        return this.java2ParentDelegaton;
    }

    public void setUseParentFirst(boolean flag) {
        this.java2ParentDelegaton = flag;
    }

    public Class loadClass(String name, boolean resolve, ClassLoader scl) throws ClassNotFoundException {
        Class foundClass = null;
        if (this.java2ParentDelegaton) {
            try {
                foundClass = this.parentRepository.loadClass(name, resolve, scl);
            }
            catch (ClassNotFoundException e) {
                foundClass = super.loadClass(name, resolve, scl);
            }
        } else {
            try {
                foundClass = super.loadClass(name, resolve, scl);
            }
            catch (ClassNotFoundException e) {
                foundClass = this.parentRepository.loadClass(name, resolve, scl);
            }
        }
        if (foundClass != null) {
            return foundClass;
        }
        throw new ClassNotFoundException(name);
    }

    public URL getResource(String name, ClassLoader scl) {
        URL resource = null;
        if (this.java2ParentDelegaton) {
            resource = this.parentRepository.getResource(name, scl);
            if (resource == null) {
                resource = super.getResource(name, scl);
            }
        } else {
            resource = super.getResource(name, scl);
            if (resource == null) {
                resource = this.parentRepository.getResource(name, scl);
            }
        }
        return resource;
    }

    public void getResources(String name, ClassLoader cl, List urls) {
        if (this.java2ParentDelegaton) {
            this.parentRepository.getResources(name, cl, urls);
            super.getResources(name, cl, urls);
        } else {
            super.getResources(name, cl, urls);
            this.parentRepository.getResources(name, cl, urls);
        }
    }

    public URL[] getURLs() {
        URL[] ourURLs = super.getURLs();
        URL[] parentURLs = this.parentRepository.getURLs();
        int size = ourURLs.length + parentURLs.length;
        URL[] urls = new URL[size];
        System.arraycopy(ourURLs, 0, urls, 0, ourURLs.length);
        System.arraycopy(parentURLs, 0, urls, ourURLs.length, parentURLs.length);
        return urls;
    }

    public Class loadClassFromCache(String name) {
        Class foundClass = null;
        if (this.java2ParentDelegaton) {
            foundClass = this.parentRepository.loadClassFromCache(name);
            if (foundClass == null) {
                foundClass = super.loadClassFromCache(name);
            }
        } else {
            foundClass = super.loadClassFromCache(name);
        }
        return foundClass;
    }

    public UnifiedClassLoader4 getClassLoader(String name) {
        return new UClWrapper(this);
    }

    UnifiedClassLoader4 internalGetClassLoader(String name) {
        UnifiedClassLoader4 thisUCL = super.getClassLoader(name);
        UnifiedClassLoader4 ucl = thisUCL;
        if (ucl == null) {
            UnifiedClassLoader4 parentUCL;
            ucl = parentUCL = this.parentRepository.getClassLoader(name);
        }
        return ucl;
    }

    UnifiedClassLoader4 internalGetParentClassLoader() {
        ClassLoader loader;
        UnifiedClassLoader4 ucl = null;
        Iterator iter = this.parentRepository.getClassLoaders().iterator();
        ucl = iter.hasNext() ? (UnifiedClassLoader4)iter.next() : ((loader = this.getClass().getClassLoader()) instanceof UnifiedClassLoader4 ? (UnifiedClassLoader4)loader : new UnifiedClassLoader4(null, null, loader, this));
        return ucl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            DEFAULT_LOADER_NAME = new ObjectName("JMImplementation:service=LoaderRepository,name=Default");
        }
        catch (Exception e) {
            log.error("Failed to initialize default loader name", e);
        }
    }

    static class UClWrapper
    extends UnifiedClassLoader4 {
        HeirarchicalLoaderRepository4 ulr;

        UClWrapper(HeirarchicalLoaderRepository4 ulr) {
            super(null, null, (ClassLoader)new NoParentClassLoader(), ulr);
            this.ulr = ulr;
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            Class<?> clazz = null;
            UnifiedClassLoader4 ucl = this.ulr.internalGetClassLoader(name);
            UnifiedClassLoader4 parentUCL = null;
            try {
                if (ucl != null) {
                    clazz = ucl.findClass(name);
                } else {
                    parentUCL = this.ulr.internalGetParentClassLoader();
                    parentUCL.findClass(name);
                }
            }
            catch (ClassNotFoundException e) {
                if (parentUCL != null) {
                    clazz = parentUCL.loadClass(name);
                }
                throw e;
            }
            return clazz;
        }
    }

    static class NoParentClassLoader
    extends ClassLoader {
        NoParentClassLoader() {
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            throw new ClassNotFoundException("NoParentClassLoader has no classed");
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException("NoParentClassLoader has no classed");
        }
    }
}

