/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.UnifiedClassLoader;

public class ClassLoaderUtils {
    private static Logger log = Logger.getLogger(class$org$jboss$mx$loading$ClassLoaderUtils == null ? (class$org$jboss$mx$loading$ClassLoaderUtils = ClassLoaderUtils.class$("org.jboss.mx.loading.ClassLoaderUtils")) : class$org$jboss$mx$loading$ClassLoaderUtils);
    static /* synthetic */ Class class$org$jboss$mx$loading$ClassLoaderUtils;

    public static void displayClassInfo(Class clazz, StringBuffer results) {
        ClassLoader cl = clazz.getClassLoader();
        results.append("\n" + clazz.getName() + "(" + Integer.toHexString(clazz.hashCode()) + ").ClassLoader=" + cl);
        ClassLoader parent = cl;
        while (parent != null) {
            results.append("\n.." + parent);
            URL[] urls = ClassLoaderUtils.getClassLoaderURLs(parent);
            int length = urls != null ? urls.length : 0;
            for (int u = 0; u < length; ++u) {
                results.append("\n...." + urls[u]);
            }
            if (parent == null) continue;
            parent = parent.getParent();
        }
        CodeSource clazzCS = clazz.getProtectionDomain().getCodeSource();
        if (clazzCS != null) {
            results.append("\n++++CodeSource: " + clazzCS);
        } else {
            results.append("\n++++Null CodeSource");
        }
        results.append("\nImplemented Interfaces:");
        Class<?>[] ifaces = clazz.getInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            Class<?> iface = ifaces[i];
            results.append("\n++" + iface + "(" + Integer.toHexString(iface.hashCode()) + ")");
            ClassLoader loader = ifaces[i].getClassLoader();
            results.append("\n++++ClassLoader: " + loader);
            ProtectionDomain pd = ifaces[i].getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            if (cs != null) {
                results.append("\n++++CodeSource: " + cs);
                continue;
            }
            results.append("\n++++Null CodeSource");
        }
    }

    public static URL[] getClassLoaderURLs(ClassLoader cl) {
        URL[] urls = new URL[]{};
        try {
            Method getCp;
            Class<?> returnType = urls.getClass();
            Class[] parameterTypes = new Class[]{};
            Class<?> clClass = cl.getClass();
            Method getURLs = clClass.getMethod("getURLs", parameterTypes);
            if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                Object[] args = new Object[]{};
                urls = (URL[])getURLs.invoke((Object)cl, args);
            }
            if ((urls == null || urls.length == 0) && returnType.isAssignableFrom((getCp = clClass.getMethod("getClasspath", parameterTypes)).getReturnType())) {
                Object[] args = new Object[]{};
                urls = (URL[])getCp.invoke((Object)cl, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return urls;
    }

    public static URLClassLoader[] getClassLoaderStack(ClassLoader cl) {
        ArrayList<ClassLoader> stack = new ArrayList<ClassLoader>();
        while (cl != null) {
            if (cl instanceof URLClassLoader) {
                stack.add(cl);
            }
            cl = cl.getParent();
        }
        URLClassLoader[] ucls = new URLClassLoader[stack.size()];
        stack.toArray(ucls);
        return ucls;
    }

    public static String getJarClassName(String className) {
        String jarClassName = className.replace('.', '/');
        return jarClassName + ".class";
    }

    public static String getPackageName(String className) {
        int startIndex = 0;
        if (className.length() > 0 && className.charAt(0) == '[') {
            startIndex = className.indexOf(76) + 1;
        }
        String pkgName = "";
        int endIndex = className.lastIndexOf(46);
        if (endIndex > 0) {
            pkgName = className.substring(startIndex, endIndex);
        }
        return pkgName;
    }

    public static String getResourceName(String className) {
        int startIndex = 0;
        if (className.length() > 0 && className.charAt(0) == '[') {
            startIndex = className.indexOf(76) + 1;
        }
        String resName = "";
        int endIndex = className.lastIndexOf(46);
        if (endIndex > 0) {
            resName = className.substring(startIndex, endIndex);
        }
        return resName.replace('.', '/');
    }

    public static String[] updatePackageMap(UnifiedClassLoader cl, HashMap packagesMap) throws Exception {
        URL url = cl.getURL();
        ClassPathIterator cpi = new ClassPathIterator(url);
        HashSet pkgNameSet = new HashSet();
        return ClassLoaderUtils.updatePackageMap(cl, packagesMap, cpi, pkgNameSet);
    }

    public static String[] updatePackageMap(UnifiedClassLoader cl, HashMap packagesMap, URL url, String[] prevPkgNames) throws Exception {
        ClassPathIterator cpi = new ClassPathIterator(url);
        HashSet<Object> pkgNameSet = null;
        pkgNameSet = prevPkgNames == null ? new HashSet() : new HashSet<String>(Arrays.asList(prevPkgNames));
        return ClassLoaderUtils.updatePackageMap(cl, packagesMap, cpi, pkgNameSet);
    }

    public static String[] updateClassNamesMap(UnifiedClassLoader cl, HashMap classNamesMap) throws Exception {
        URL url = cl.getURL();
        ClassPathIterator cpi = new ClassPathIterator(url);
        HashSet classNameSet = new HashSet();
        return ClassLoaderUtils.updateClassNamesMap(cl, classNamesMap, cpi, classNameSet);
    }

    public static String[] updateClassNamesMap(UnifiedClassLoader cl, HashMap classNamesMap, URL url, String[] prevClassNames) throws Exception {
        ClassPathIterator cpi = new ClassPathIterator(url);
        HashSet<Object> classNameSet = null;
        classNameSet = prevClassNames == null ? new HashSet() : new HashSet<String>(Arrays.asList(prevClassNames));
        return ClassLoaderUtils.updateClassNamesMap(cl, classNamesMap, cpi, classNameSet);
    }

    static String[] updatePackageMap(UnifiedClassLoader cl, HashMap packagesMap, ClassPathIterator cpi, HashSet pkgNameSet) throws Exception {
        ClassPathEntry entry;
        boolean trace = log.isTraceEnabled();
        while ((entry = cpi.getNextEntry()) != null) {
            String name = entry.getName();
            if (name.equals("META-INF/INDEX.LIST")) {
                ClassLoaderUtils.readJarIndex(cl, cpi, packagesMap, pkgNameSet);
                break;
            }
            if (entry.isDirectory()) continue;
            String pkgName = entry.toPackageName();
            ClassLoaderUtils.addPackage(pkgName, packagesMap, pkgNameSet, cl, trace);
        }
        cpi.close();
        String[] pkgNames = new String[pkgNameSet.size()];
        pkgNameSet.toArray(pkgNames);
        return pkgNames;
    }

    static String[] updateClassNamesMap(UnifiedClassLoader cl, HashMap classNamesMap, ClassPathIterator cpi, HashSet classNameSet) throws Exception {
        ClassPathEntry entry;
        boolean trace = log.isTraceEnabled();
        while ((entry = cpi.getNextEntry()) != null) {
            String name = entry.getName();
            if (entry.isDirectory() || !name.endsWith(".class")) continue;
            ClassLoaderUtils.addClass(name, classNamesMap, cl, trace);
            classNameSet.add(name);
        }
        cpi.close();
        String[] classNames = new String[classNameSet.size()];
        classNameSet.toArray(classNames);
        return classNames;
    }

    private static void readJarIndex(UnifiedClassLoader cl, ClassPathIterator cpi, HashMap packagesMap, HashSet pkgNameSet) throws Exception {
        String line;
        boolean trace = log.isTraceEnabled();
        InputStream zis = cpi.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(zis));
        while ((line = br.readLine()) != null && line.length() != 0) {
        }
        String jarName = br.readLine();
        if (trace) {
            log.trace("Reading INDEX.LIST for jar: " + jarName);
        }
        while ((line = br.readLine()) != null && line.length() != 0) {
            String pkgName = line.replace('/', '.');
            ClassLoaderUtils.addPackage(pkgName, packagesMap, pkgNameSet, cl, trace);
        }
        br.close();
    }

    private static void addPackage(String pkgName, HashMap packagesMap, HashSet pkgNameSet, UnifiedClassLoader cl, boolean trace) {
        if (pkgName.startsWith("META-INF") || pkgName.startsWith("WEB-INF")) {
            return;
        }
        HashSet<UnifiedClassLoader> pkgSet = (HashSet<UnifiedClassLoader>)packagesMap.get(pkgName);
        if (pkgSet == null) {
            pkgSet = new HashSet<UnifiedClassLoader>();
            packagesMap.put(pkgName, pkgSet);
        }
        if (!pkgSet.contains(cl)) {
            pkgSet.add(cl);
            pkgNameSet.add(pkgName);
            if (pkgSet.size() > 1) {
                log.debug("Multiple class loaders found for pkg: " + pkgName);
            }
            if (trace) {
                log.trace("Indexed pkg: " + pkgName + ", UCL: " + cl);
            }
        }
    }

    private static void addClass(String jarClassName, HashMap classNamesMap, UnifiedClassLoader cl, boolean trace) {
        LinkedList<UnifiedClassLoader> ucls = (LinkedList<UnifiedClassLoader>)classNamesMap.get(jarClassName);
        if (ucls == null) {
            ucls = new LinkedList<UnifiedClassLoader>();
            ucls.add(cl);
            classNamesMap.put(jarClassName, ucls);
        } else {
            boolean uclIsMapped = ucls.contains(cl);
            if (!uclIsMapped) {
                log.debug("Multiple class loaders found for class: " + jarClassName + ", duplicate UCL: " + cl);
                ucls.add(cl);
            }
        }
        if (trace) {
            log.trace("Indexed class: " + jarClassName + ", UCL: " + ucls.get(0));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ClassPathIterator {
        ZipInputStream zis;
        FileIterator fileIter;
        File file;
        int rootLength;

        ClassPathIterator(URL url) throws IOException {
            String protocol = url.getProtocol();
            if (protocol.equals("file")) {
                File tmp = new File(url.getFile());
                if (tmp.isDirectory()) {
                    this.rootLength = tmp.getPath().length() + 1;
                    this.fileIter = new FileIterator(tmp);
                } else {
                    FileInputStream is = new FileInputStream(tmp);
                    this.zis = new ZipInputStream(is);
                }
            } else {
                InputStream is = url.openStream();
                this.zis = new ZipInputStream(is);
            }
        }

        ClassPathEntry getNextEntry() throws IOException {
            ClassPathEntry entry = null;
            if (this.zis != null) {
                ZipEntry zentry = this.zis.getNextEntry();
                if (zentry != null) {
                    entry = new ClassPathEntry(zentry);
                }
            } else {
                File fentry = this.fileIter.getNextEntry();
                if (fentry != null) {
                    entry = new ClassPathEntry(fentry, this.rootLength);
                }
                this.file = fentry;
            }
            return entry;
        }

        InputStream getInputStream() throws IOException {
            InputStream is = this.zis;
            if (this.zis == null) {
                is = new FileInputStream(this.file);
            }
            return is;
        }

        void close() throws IOException {
            if (this.zis != null) {
                this.zis.close();
            }
        }
    }

    static class ClassPathEntry {
        String name;
        ZipEntry zipEntry;
        File fileEntry;

        ClassPathEntry(ZipEntry zipEntry) {
            this.zipEntry = zipEntry;
            this.name = zipEntry.getName();
        }

        ClassPathEntry(File fileEntry, int rootLength) {
            this.fileEntry = fileEntry;
            this.name = fileEntry.getPath().substring(rootLength);
        }

        String getName() {
            return this.name;
        }

        String toPackageName() {
            String pkgName = this.name;
            char separatorChar = this.zipEntry != null ? (char)'/' : (char)File.separatorChar;
            int index = this.name.lastIndexOf(separatorChar);
            if (index > 0) {
                pkgName = this.name.substring(0, index);
                pkgName = pkgName.replace(separatorChar, '.');
            } else {
                pkgName = "";
            }
            return pkgName;
        }

        boolean isDirectory() {
            boolean isDirectory = false;
            isDirectory = this.zipEntry != null ? this.zipEntry.isDirectory() : this.fileEntry.isDirectory();
            return isDirectory;
        }
    }

    static class FileIterator {
        LinkedList subDirectories = new LinkedList();
        FileFilter filter;
        File[] currentListing;
        int index = 0;

        FileIterator(File start) {
            String name = start.getName();
            boolean isWar = name.endsWith(".war");
            this.currentListing = isWar ? new File[0] : start.listFiles();
        }

        FileIterator(File start, FileFilter filter) {
            String name = start.getName();
            boolean isWar = name.endsWith(".war");
            this.currentListing = isWar ? new File[0] : start.listFiles(filter);
            this.filter = filter;
        }

        File getNextEntry() {
            File next = null;
            if (this.index >= this.currentListing.length && this.subDirectories.size() > 0) {
                do {
                    File nextDir = (File)this.subDirectories.removeFirst();
                    this.currentListing = nextDir.listFiles(this.filter);
                } while (this.currentListing.length == 0 && this.subDirectories.size() > 0);
                this.index = 0;
            }
            if (this.index < this.currentListing.length && (next = this.currentListing[this.index++]).isDirectory()) {
                this.subDirectories.addLast(next);
            }
            return next;
        }
    }
}

