/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.interceptor;

import javax.management.Attribute;
import javax.management.Descriptor;
import javax.management.MBeanException;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.modelmbean.ModelMBeanConstants;
import org.jboss.mx.modelmbean.ModelMBeanInvoker;
import org.jboss.mx.server.Invocation;
import org.jboss.mx.server.InvocationException;

public class ModelMBeanAttributeInterceptor
extends AbstractInterceptor
implements ModelMBeanConstants {
    public ModelMBeanAttributeInterceptor() {
        super("ModelMBean Attribute Interceptor");
    }

    public Object invoke(Invocation invocation) throws InvocationException {
        Descriptor d = invocation.getDescriptor();
        if (invocation.getType().equals("setAttribute")) {
            Object value = invocation.getArgs()[0];
            Object oldValue = d.getFieldValue("value");
            String setMethod = (String)d.getFieldValue("setMethod");
            if (setMethod != null) {
                invocation.dispatch();
            }
            d.setField("value", value);
            d.setField("lastUpdatedTimeStamp", "" + System.currentTimeMillis() / 1000L);
            invocation.setDescriptor(d);
            try {
                ModelMBeanInvoker invoker = (ModelMBeanInvoker)invocation.getInvoker();
                invoker.sendAttributeChangeNotification(new Attribute(invocation.getName(), oldValue), new Attribute(invocation.getName(), value));
            }
            catch (MBeanException e) {
                throw new InvocationException(e, "attribute change notification error");
            }
        } else if (invocation.getType().equals("getAttribute")) {
            String getMethod = (String)d.getFieldValue("getMethod");
            if (getMethod != null) {
                long limit;
                String timeLimit = (String)d.getFieldValue("currencyTimeLimit");
                long l = limit = timeLimit == null ? 0L : Long.parseLong(timeLimit);
                if (limit == -1L) {
                    return d.getFieldValue("value");
                }
                if (limit > 0L) {
                    long lastUpdate;
                    String timeStamp = (String)d.getFieldValue("lastUpdatedTimeStamp");
                    long l2 = lastUpdate = timeStamp == null ? 0L : Long.parseLong(timeStamp);
                    if (System.currentTimeMillis() < lastUpdate * 1000L + limit * 1000L) {
                        return d.getFieldValue("value");
                    }
                }
                Object value = invocation.dispatch();
                d.setField("value", value);
                d.setField("lastUpdatedTimeStamp", "" + System.currentTimeMillis() / 1000L);
                invocation.setDescriptor(d);
            } else {
                Object defaultValue = d.getFieldValue("default");
                String timeStamp = (String)d.getFieldValue("lastUpdatedTimeStamp");
                if (defaultValue != null && timeStamp == null) {
                    d.setField("value", defaultValue);
                    d.setField("lastUpdatedTimeStamp", "" + System.currentTimeMillis() / 1000L);
                    invocation.setDescriptor(d);
                }
            }
        }
        return d.getFieldValue("value");
    }
}

