/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil2;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.mq.Connection;
import org.jboss.mq.ReceiveRequest;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.il.ClientIL;
import org.jboss.mq.il.ClientILService;
import org.jboss.mq.il.uil2.SocketManager;
import org.jboss.mq.il.uil2.SocketManagerHandler;
import org.jboss.mq.il.uil2.UILClientIL;
import org.jboss.mq.il.uil2.UILServerIL;
import org.jboss.mq.il.uil2.msgs.BaseMsg;
import org.jboss.mq.il.uil2.msgs.DeleteTemporaryDestMsg;
import org.jboss.mq.il.uil2.msgs.MsgTypes;
import org.jboss.mq.il.uil2.msgs.PingMsg;
import org.jboss.mq.il.uil2.msgs.ReceiveRequestMsg;

public class UILClientILService
implements ClientILService,
MsgTypes,
SocketManagerHandler {
    static Logger log = Logger.getLogger(class$org$jboss$mq$il$uil2$UILClientILService == null ? (class$org$jboss$mq$il$uil2$UILClientILService = UILClientILService.class$("org.jboss.mq.il.uil2.UILClientILService")) : class$org$jboss$mq$il$uil2$UILClientILService);
    private UILClientIL clientIL;
    private SocketManager socketMgr;
    private Connection connection;
    private boolean sendReceiveReplies = true;
    static /* synthetic */ Class class$org$jboss$mq$il$uil2$UILClientILService;

    public ClientIL getClientIL() throws Exception {
        return this.clientIL;
    }

    public void init(Connection connection, Properties props) throws Exception {
        this.connection = connection;
        this.clientIL = new UILClientIL();
        UILServerIL serverIL = (UILServerIL)connection.getServerIL();
        this.socketMgr = serverIL.getSocketMgr();
        String t = props.getProperty("UIL_BUFFERSIZE_KEY");
        if (t != null) {
            this.socketMgr.setBufferSize(Integer.parseInt(t));
        }
        if ((t = props.getProperty("UIL_CHUNKSIZE_KEY")) != null) {
            this.socketMgr.setChunkSize(Integer.parseInt(t));
        }
        if ((t = props.getProperty("UIL_RECEIVE_REPLIES_KEY")) != null) {
            this.sendReceiveReplies = false;
        }
        this.socketMgr.setHandler(this);
    }

    public void handleMsg(BaseMsg msg) throws Exception {
        boolean trace = log.isTraceEnabled();
        int msgType = msg.getMsgType();
        if (trace) {
            log.trace("Begin handleMsg, msgType: " + msgType);
        }
        switch (msgType) {
            case 1: {
                break;
            }
            case 25: {
                ReceiveRequestMsg rmsg = (ReceiveRequestMsg)msg;
                ReceiveRequest[] messages = rmsg.getMessages();
                this.connection.asynchDeliver(messages);
                if (!this.sendReceiveReplies) break;
                rmsg.trimTheMessages();
                this.socketMgr.sendReply(msg);
                break;
            }
            case 8: {
                DeleteTemporaryDestMsg dmsg = (DeleteTemporaryDestMsg)msg;
                SpyDestination dest = dmsg.getDest();
                this.connection.asynchDeleteTemporaryDestination(dest);
                this.socketMgr.sendReply(msg);
                break;
            }
            case 23: {
                this.connection.asynchClose();
                this.socketMgr.sendReply(msg);
                break;
            }
            case 24: {
                PingMsg pmsg = (PingMsg)msg;
                long time = pmsg.getTime();
                this.connection.asynchPong(time);
                break;
            }
            default: {
                this.connection.asynchFailure("UILClientILService received bad msg: " + msg, null);
            }
        }
        if (trace) {
            log.trace("End handleMsg");
        }
    }

    public void start() throws Exception {
        log.debug("Starting");
    }

    public void stop() throws Exception {
        log.debug("Stopping");
        this.socketMgr.stop();
    }

    public void onStreamNotification(Object stream, int size) {
        this.connection.asynchPong(System.currentTimeMillis());
    }

    public void asynchFailure(String error, Throwable e) {
        if (e instanceof Exception) {
            this.connection.asynchFailure(error, e);
        } else {
            this.connection.asynchFailure(error, new UndeclaredThrowableException(e));
        }
    }

    public void close() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

