/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil.multiplexor;

import java.io.IOException;
import java.io.OutputStream;
import org.jboss.mq.il.uil.multiplexor.StreamMux;

class MuxOutputStream
extends OutputStream {
    StreamMux streamMux;
    short streamId;
    byte[] buffer;
    short bufferLength;

    MuxOutputStream(StreamMux mux, short id) {
        this.streamMux = mux;
        this.streamId = id;
        this.buffer = new byte[this.streamMux.frameSize];
        this.bufferLength = 0;
    }

    public void close() throws IOException {
        this.streamMux.closeStream(this.streamId);
    }

    public void flush() throws IOException {
        if (this.bufferLength > 0) {
            this.flushBuffer();
        }
        this.streamMux.flush();
    }

    public void write(int data) throws IOException {
        byte b;
        this.buffer[this.bufferLength] = b = (byte)data;
        this.bufferLength = (short)(this.bufferLength + 1);
        if (this.bufferLength == this.streamMux.frameSize) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() throws IOException {
        this.streamMux.write(this, this.buffer, this.bufferLength);
        this.bufferLength = 0;
    }
}

