/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.connector.notification;

import java.util.Random;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.jmx.connector.RemoteMBeanServer;
import org.jboss.logging.Logger;

public abstract class ClientNotificationListener {
    protected Logger log = Logger.getLogger(this.getClass());
    private ObjectName mSender;
    private ObjectName mRemoteListener;
    protected NotificationListener mClientListener;
    protected Object mHandback;
    private Random mRandom = new Random();

    public ClientNotificationListener(ObjectName pSender, NotificationListener pClientListener, Object pHandback) {
        this.mSender = pSender;
        this.mClientListener = pClientListener;
        this.mHandback = pHandback;
    }

    public ObjectName createListener(RemoteMBeanServer pConnector, String mClass, Object[] pParameters, String[] pSignatures) throws MalformedObjectNameException, ReflectionException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        ObjectName lName = null;
        while (lName == null) {
            try {
                lName = new ObjectName("JMX:type=listener,id=" + this.mRandom.nextLong());
                ObjectInstance lInstance = pConnector.createMBean(mClass, lName, pParameters, pSignatures);
                lName = lInstance.getObjectName();
            }
            catch (InstanceAlreadyExistsException iaee) {
                lName = null;
            }
        }
        this.mRemoteListener = lName;
        return lName;
    }

    public void addNotificationListener(RemoteMBeanServer pConnector, NotificationFilter pFilter) throws InstanceNotFoundException {
        pConnector.addNotificationListener(this.mSender, this.mRemoteListener, pFilter, null);
    }

    public void removeNotificationListener(RemoteMBeanServer pConnector) throws InstanceNotFoundException {
        try {
            pConnector.removeNotificationListener(this.mSender, this.mRemoteListener);
        }
        catch (JMException jme) {
            // empty catch block
        }
        try {
            pConnector.unregisterMBean(this.mRemoteListener);
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    public ObjectName getSenderMBean() {
        return this.mSender;
    }

    public ObjectName getRemoteListenerName() {
        return this.mRemoteListener;
    }

    public boolean equals(Object pTest) {
        if (pTest instanceof ClientNotificationListener) {
            ClientNotificationListener lListener = (ClientNotificationListener)pTest;
            return this.mSender.equals(lListener.mSender) && this.mClientListener.equals(lListener.mClientListener);
        }
        return false;
    }
}

