/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.connector;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.naming.InitialContext;
import org.jboss.jmx.connector.ConnectorFactoryImpl;
import org.jboss.jmx.connector.RemoteMBeanServer;

public class TestClient {
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$org$jboss$jmx$connector$ConnectorFactoryImpl$IConnectorTester;

    public static void main(String[] args) throws Exception {
        try {
            System.out.println();
            TestClient.getUserInput("Testing JMX Connectors\n======================\n\n1. Instantiate local MBeanServer and add connector factory as first MBean to search your net\n=> hit any key to proceed");
            final MBeanServer lLocalServer = MBeanServerFactory.createMBeanServer();
            final ObjectInstance lFactoryInstance = lLocalServer.createMBean("org.jboss.jmx.connector.ConnectorFactoryService", new ObjectName(lLocalServer.getDefaultDomain(), "name", "ConnectorFactory"));
            System.out.println("Found Factory: " + lFactoryInstance.getObjectName());
            int lType = -1;
            while (lType < 1 || lType > 3) {
                lType = TestClient.getUserInput("\n2. Do you want to use RMI or JMS to transfer Notifications\n=> enter 1 from RMI, 2 for JMS or 3 for Polling and then hit enter");
                System.out.println("Type: " + lType);
            }
            switch (lType) {
                case 1: {
                    lType = 1;
                    break;
                }
                case 2: {
                    lType = 0;
                    break;
                }
                case 3: {
                    lType = 2;
                }
            }
            lLocalServer.setAttribute(lFactoryInstance.getObjectName(), new Attribute("NotificationType", new Integer(lType)));
            String lJMSName = null;
            if (lType == 0) {
                while (lJMSName == null || lJMSName.trim().length() == 0) {
                    lJMSName = TestClient.getUserInputLine("\n2.a. Enter the JMS Queue Factory Name and hit enter\n");
                }
            }
            if (lJMSName == null || lJMSName.trim().length() == 0) {
                lJMSName = null;
            }
            lLocalServer.setAttribute(lFactoryInstance.getObjectName(), new Attribute("JMSName", lJMSName));
            String lEJBAdaptorName = TestClient.getUserInputLine("\n3. When you are expecting EJB-Connectors and the EJB-Adaptor\n   and the EJB-Adaptor does not have the default JNDI-Name then\n   then specified it here and hit enter\n");
            if (lEJBAdaptorName == null || lEJBAdaptorName.trim().length() == 0) {
                lEJBAdaptorName = null;
            }
            lLocalServer.setAttribute(lFactoryInstance.getObjectName(), new Attribute("EJBAdaptorName", lEJBAdaptorName));
            lLocalServer.invoke(lFactoryInstance.getObjectName(), "create", new Object[0], new String[0]);
            lLocalServer.invoke(lFactoryInstance.getObjectName(), "start", new Object[0], new String[0]);
            TestClient.getUserInput("\n4. Lookup for all available connectors with the JNDI defined by jndi.properties\n=> hit any key to proceed");
            InitialContext lContext = null;
            try {
                lContext = new InitialContext();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Hashtable<?, ?> lProperties = lContext.getEnvironment();
            ConnectorFactoryImpl.JBossConnectorTester lTester = new ConnectorFactoryImpl.JBossConnectorTester();
            Iterator lConnectors = (Iterator)lLocalServer.invoke(lFactoryInstance.getObjectName(), "getConnectors", new Object[]{lProperties, lTester}, new String[]{(class$java$util$Hashtable == null ? (class$java$util$Hashtable = TestClient.class$("java.util.Hashtable")) : class$java$util$Hashtable).getName(), (class$org$jboss$jmx$connector$ConnectorFactoryImpl$IConnectorTester == null ? (class$org$jboss$jmx$connector$ConnectorFactoryImpl$IConnectorTester = TestClient.class$("org.jboss.jmx.connector.ConnectorFactoryImpl$IConnectorTester")) : class$org$jboss$jmx$connector$ConnectorFactoryImpl$IConnectorTester).getName()});
            int lCount = 0;
            StringBuffer lMessage = new StringBuffer();
            lMessage.append("List of all available connectors on your net\n");
            lMessage.append("=========================================\n");
            Vector<ConnectorFactoryImpl.ConnectorName> lTemp = new Vector<ConnectorFactoryImpl.ConnectorName>();
            while (lConnectors.hasNext()) {
                ConnectorFactoryImpl.ConnectorName lName = (ConnectorFactoryImpl.ConnectorName)lConnectors.next();
                lTemp.addElement(lName);
                lMessage.append(" - " + lCount++ + ". connector is: " + lName + "\n");
            }
            int lChoice = -1;
            while (lChoice < 0 || lChoice > lTemp.size()) {
                lMessage.append("\n");
                lMessage.append("5. Select your connector by entering its number\n");
                lMessage.append("=> hit any key to proceed");
                lChoice = TestClient.getUserInput(lMessage.toString());
            }
            final ConnectorFactoryImpl.ConnectorName lConnectorName = (ConnectorFactoryImpl.ConnectorName)lTemp.get(lChoice);
            lMessage.setLength(0);
            lMessage.append("\nYou selected connector: " + lConnectorName + "\n\n");
            TestClient.getUserInput(lMessage.toString() + "\n" + "6. Connect to the given connector\n" + "=> hit any key to proceed");
            lMessage.setLength(0);
            RemoteMBeanServer lConnector = (RemoteMBeanServer)lLocalServer.invoke(lFactoryInstance.getObjectName(), "createConnection", new Object[]{lConnectorName}, new String[]{lConnectorName.getClass().getName()});
            TestClient.getUserInput("\n7. List all available MBeans and its attributes\n=> hit any key to proceed");
            TestClient.listServices(lConnector);
            TestClient.getUserInput("\n8. Try to add a listener to all available MBeans.\nPlease note that this will keep this test client up and running waiting\nfor an event from the server. If there is no event comming then try\nto shutdown the JBoss server.\nTo end this test client just hit <CTRL>-C\n=> hit any key to proceed");
            TestClient.registerListeners(lConnector);
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        System.err.println("Shutdown");
                        try {
                            lLocalServer.invoke(lFactoryInstance.getObjectName(), "removeConnection", new Object[]{lConnectorName}, new String[]{lConnectorName.getClass().getName()});
                            System.err.println("Shutting done");
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                });
                System.out.println("Shutdown hook added");
            }
            catch (Throwable e) {
                System.out.println("Could not add shutdown hook");
            }
        }
        catch (RuntimeMBeanException rme) {
            System.err.println("TestClient.main(), caught: " + rme + ", target: " + rme.getTargetException());
            rme.printStackTrace();
        }
        catch (MBeanException me) {
            System.err.println("TestClient.main(), caught: " + me + ", target: " + me.getTargetException());
            me.printStackTrace();
        }
        catch (RuntimeErrorException rte) {
            System.err.println("TestClient.main(), caught: " + rte + ", target: " + rte.getTargetError());
            rte.printStackTrace();
        }
        catch (ReflectionException re) {
            System.err.println("TestClient.main(), caught: " + re + ", target: " + re.getTargetException());
            re.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("TestClient.main(), caught: " + e);
            e.printStackTrace();
        }
    }

    public static void listServices(RemoteMBeanServer pConnector) throws Exception {
        try {
            Iterator i = pConnector.queryMBeans(null, null).iterator();
            while (i.hasNext()) {
                MBeanInfo info = pConnector.getMBeanInfo(((ObjectInstance)i.next()).getObjectName());
                System.out.println("MBean: " + info.getClassName());
                MBeanAttributeInfo[] aInfos = info.getAttributes();
                for (int k = 0; k < aInfos.length; ++k) {
                    System.out.println("\t" + k + ". Attribute: " + aInfos[k].getName());
                }
                MBeanOperationInfo[] oInfos = info.getOperations();
                for (int k = 0; k < oInfos.length; ++k) {
                    System.out.println("\t" + k + ". Operation: " + oInfos[k].getName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerListeners(RemoteMBeanServer pConnector) throws Exception {
        try {
            Iterator i = pConnector.queryMBeans(null, null).iterator();
            int j = 0;
            while (i.hasNext()) {
                ObjectName lBean = ((ObjectInstance)i.next()).getObjectName();
                try {
                    if (pConnector.isInstanceOf(lBean, "javax.management.NotificationBroadcaster")) {
                        pConnector.addNotificationListener(lBean, new Listener(), (NotificationFilter)null, (Object)new NotSerializableHandback(lBean + "" + j++));
                        System.out.println("Added notification listener to: " + lBean);
                        continue;
                    }
                    System.out.println("This MBean is not a notification broadcaster: " + lBean);
                }
                catch (RuntimeOperationsException roe) {
                    System.out.println("Could not add listener to: " + lBean + ", reason could be that it is not a broadcaster");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int getUserInput(String lMessage) {
        int lReturn = -1;
        try {
            String lInput = TestClient.getUserInputLine(lMessage);
            lReturn = new Integer(lInput);
        }
        catch (NumberFormatException nfe) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lReturn;
    }

    private static String getUserInputLine(String lMessage) {
        String lReturn = "";
        try {
            System.out.println(lMessage);
            lReturn = new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lReturn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class NotSerializableHandback {
        private static int miCounter = 0;
        private String mName;

        public NotSerializableHandback(String pName) {
            this.mName = pName + "[ " + miCounter++ + " ]";
        }

        public String toString() {
            return "NotSerializableHandback[ " + this.mName + " ]";
        }
    }

    private static class Listener
    implements NotificationListener {
        private Listener() {
        }

        public void handleNotification(Notification pNotification, Object pHandback) {
            System.out.println("Got notification: " + pNotification + ", from: " + pHandback);
        }
    }
}

