/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.rmi;

import java.net.InetAddress;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.jmx.adaptor.rmi.RMIAdaptorImpl;
import org.jboss.jmx.adaptor.rmi.RMIAdaptorServiceMBean;
import org.jboss.naming.Util;
import org.jboss.system.ServiceMBeanSupport;

public class RMIAdaptorService
extends ServiceMBeanSupport
implements RMIAdaptorServiceMBean {
    public static final String JMX_NAME = "jmx";
    public static final String PROTOCOL_NAME = "rmi";
    public static final String DEFAULT_JNDI_NAME = "jmx/rmi/RMIAdaptor";
    private RMIAdaptor adaptor;
    private String host;
    private String name;
    private String jndiName = "jmx/rmi/RMIAdaptor";
    private int rmiPort = 0;
    private int backlog = 50;
    protected String serverAddress;

    public RMIAdaptorService(String name) {
        this.name = name;
    }

    public RMIAdaptorService() {
        this(null);
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setRMIObjectPort(int rmiPort) {
        this.rmiPort = rmiPort;
    }

    public int getRMIObjectPort() {
        return this.rmiPort;
    }

    public void setServerAddress(String address) {
        this.serverAddress = address;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getLegacyJndiName() {
        if (this.name != null) {
            return "jmx:" + this.host + ":" + PROTOCOL_NAME + ":" + this.name;
        }
        return "jmx:" + this.host + ":" + PROTOCOL_NAME;
    }

    protected void startService() throws Exception {
        InetAddress bindAddress = null;
        if (this.serverAddress != null && this.serverAddress.length() > 0) {
            bindAddress = InetAddress.getByName(this.serverAddress);
        }
        this.adaptor = new RMIAdaptorImpl(this.getServer(), this.rmiPort, bindAddress, this.backlog);
        this.log.debug("Created RMIAdaptorImpl: " + this.adaptor);
        InitialContext iniCtx = new InitialContext();
        Util.bind((Context)iniCtx, (String)this.jndiName, (Object)this.adaptor);
        this.host = InetAddress.getLocalHost().getHostName();
        String legacyName = this.getLegacyJndiName();
        iniCtx.bind(legacyName, (Object)this.adaptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopService() throws Exception {
        InitialContext ctx = new InitialContext();
        try {
            ctx.unbind(this.getJndiName());
            ctx.unbind(this.getLegacyJndiName());
        }
        finally {
            ctx.close();
        }
    }
}

