/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.jboss.mx.util.Serialization;

public class ModelMBeanInfoSupport
extends MBeanInfo
implements ModelMBeanInfo,
Serializable {
    private Descriptor mbeanDescriptor = null;
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$javax$management$Descriptor;

    public ModelMBeanInfoSupport(ModelMBeanInfo mbi) {
        super(mbi.getClassName(), mbi.getDescription(), mbi.getAttributes(), mbi.getConstructors(), mbi.getOperations(), mbi.getNotifications());
        try {
            this.setMBeanDescriptor(mbi.getMBeanDescriptor());
        }
        catch (MBeanException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public ModelMBeanInfoSupport(String className, String description, ModelMBeanAttributeInfo[] attributes, ModelMBeanConstructorInfo[] constructors, ModelMBeanOperationInfo[] operations, ModelMBeanNotificationInfo[] notifications) {
        super(className, description, null == attributes ? new ModelMBeanAttributeInfo[]{} : attributes, null == constructors ? new ModelMBeanConstructorInfo[]{} : constructors, null == operations ? new ModelMBeanOperationInfo[]{} : operations, null == notifications ? new ModelMBeanNotificationInfo[]{} : notifications);
        try {
            this.setMBeanDescriptor(this.createDefaultDescriptor(className));
        }
        catch (MBeanException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public ModelMBeanInfoSupport(String className, String description, ModelMBeanAttributeInfo[] attributes, ModelMBeanConstructorInfo[] constructors, ModelMBeanOperationInfo[] operations, ModelMBeanNotificationInfo[] notifications, Descriptor mbeandescriptor) {
        this(className, description, attributes, constructors, operations, notifications);
        try {
            this.setMBeanDescriptor(mbeandescriptor);
        }
        catch (MBeanException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public Descriptor[] getDescriptors(String descrType) throws MBeanException {
        if (descrType == null) {
            ArrayList<Descriptor> list = new ArrayList<Descriptor>(100);
            list.add(this.mbeanDescriptor);
            list.addAll(this.getAttributeDescriptors().values());
            list.addAll(this.getOperationDescriptors().values());
            list.addAll(this.getNotificationDescriptors().values());
            list.addAll(this.getConstructorDescriptors().values());
            return list.toArray(new Descriptor[0]);
        }
        if (descrType.equalsIgnoreCase("MBean")) {
            return new Descriptor[]{this.mbeanDescriptor};
        }
        if (descrType.equalsIgnoreCase("attribute")) {
            return this.getAttributeDescriptors().values().toArray(new Descriptor[0]);
        }
        if (descrType.equalsIgnoreCase("operation")) {
            return this.getOperationDescriptors().values().toArray(new Descriptor[0]);
        }
        if (descrType.equalsIgnoreCase("notification")) {
            return this.getNotificationDescriptors().values().toArray(new Descriptor[0]);
        }
        if (descrType.equalsIgnoreCase("constructor")) {
            return this.getConstructorDescriptors().values().toArray(new Descriptor[0]);
        }
        throw new IllegalArgumentException("unknown descriptor type: " + descrType);
    }

    public Descriptor getDescriptor(String descrName, String descrType) throws MBeanException {
        if (descrType == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("null descriptor type"));
        }
        if (descrType.equalsIgnoreCase("MBean")) {
            return this.mbeanDescriptor;
        }
        if (descrType.equalsIgnoreCase("attribute")) {
            return (Descriptor)this.getAttributeDescriptors().get(descrName);
        }
        if (descrType.equalsIgnoreCase("operation")) {
            return (Descriptor)this.getOperationDescriptors().get(descrName);
        }
        if (descrType.equalsIgnoreCase("constructor")) {
            return (Descriptor)this.getConstructorDescriptors().get(descrName);
        }
        if (descrType.equalsIgnoreCase("notification")) {
            return (Descriptor)this.getNotificationDescriptors().get(descrName);
        }
        throw new RuntimeOperationsException(new IllegalArgumentException("unknown descriptor type: " + descrType));
    }

    public void setDescriptors(Descriptor[] inDescriptors) throws MBeanException {
        for (int i = 0; i < inDescriptors.length; ++i) {
            if (inDescriptors[i] == null || !inDescriptors[i].isValid()) continue;
            this.setDescriptor(inDescriptors[i], (String)inDescriptors[i].getFieldValue("descriptortype"));
        }
    }

    public void setDescriptor(Descriptor descr, String descrType) throws MBeanException {
        if (descr == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("null descriptor"));
        }
        if (!descr.isValid()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("not a valid descriptor"));
        }
        if (descrType == null) {
            descrType = (String)descr.getFieldValue("descriptortype");
        }
        if (descrType.equalsIgnoreCase("MBean")) {
            this.setMBeanDescriptor(descr);
        } else if (descrType.equalsIgnoreCase("attribute")) {
            ModelMBeanAttributeInfo info = this.getAttribute((String)descr.getFieldValue("name"));
            info.setDescriptor(descr);
        } else if (descrType.equalsIgnoreCase("operation")) {
            ModelMBeanOperationInfo info = this.getOperation((String)descr.getFieldValue("name"));
            info.setDescriptor(descr);
        } else if (descrType.equalsIgnoreCase("constructor")) {
            ModelMBeanConstructorInfo info = this.getConstructor((String)descr.getFieldValue("name"));
            info.setDescriptor(descr);
        } else if (descrType.equalsIgnoreCase("notification")) {
            ModelMBeanNotificationInfo info = this.getNotification((String)descr.getFieldValue("name"));
            info.setDescriptor(descr);
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("unknown descriptor type: " + descrType));
        }
    }

    public ModelMBeanAttributeInfo getAttribute(String inName) throws MBeanException {
        for (int i = 0; i < this.attributes.length; ++i) {
            if (!this.attributes[i].getName().equals(inName)) continue;
            return (ModelMBeanAttributeInfo)this.attributes[i];
        }
        throw new RuntimeOperationsException(new IllegalArgumentException("MBean does not contain attribute " + inName));
    }

    public ModelMBeanOperationInfo getOperation(String inName) throws MBeanException {
        for (int i = 0; i < this.operations.length; ++i) {
            if (!this.operations[i].getName().equals(inName)) continue;
            return (ModelMBeanOperationInfo)this.operations[i];
        }
        throw new RuntimeOperationsException(new IllegalArgumentException("MBean does not contain operation " + inName));
    }

    public ModelMBeanConstructorInfo getConstructor(String inName) throws MBeanException {
        for (int i = 0; i < this.constructors.length; ++i) {
            if (!this.constructors[i].getName().equals(inName)) continue;
            return (ModelMBeanConstructorInfo)this.constructors[i];
        }
        throw new RuntimeOperationsException(new IllegalArgumentException("MBean does not contain constructor " + inName));
    }

    public ModelMBeanNotificationInfo getNotification(String inName) throws MBeanException {
        for (int i = 0; i < this.notifications.length; ++i) {
            if (!this.notifications[i].getName().equals(inName)) continue;
            return (ModelMBeanNotificationInfo)this.notifications[i];
        }
        throw new RuntimeOperationsException(new IllegalArgumentException("MBean does not contain notification " + inName));
    }

    public MBeanAttributeInfo[] getAttributes() {
        return super.getAttributes();
    }

    public MBeanOperationInfo[] getOperations() {
        return super.getOperations();
    }

    public MBeanConstructorInfo[] getConstructors() {
        return super.getConstructors();
    }

    public MBeanNotificationInfo[] getNotifications() {
        return super.getNotifications();
    }

    public Descriptor getMBeanDescriptor() throws MBeanException {
        return this.mbeanDescriptor;
    }

    public void setMBeanDescriptor(Descriptor inMBeanDescriptor) throws MBeanException {
        Descriptor descr = (Descriptor)inMBeanDescriptor.clone();
        this.addDefaultMBeanDescriptorFields(descr);
        this.mbeanDescriptor = descr;
    }

    public Descriptor getDescriptor(String descrName) throws MBeanException {
        if (descrName.equals(this.mbeanDescriptor.getFieldValue("name"))) {
            return this.mbeanDescriptor;
        }
        Descriptor descr = null;
        descr = (Descriptor)this.getAttributeDescriptors().get(descrName);
        if (descr != null) {
            return descr;
        }
        descr = (Descriptor)this.getOperationDescriptors().get(descrName);
        if (descr != null) {
            return descr;
        }
        descr = (Descriptor)this.getNotificationDescriptors().get(descrName);
        if (descr != null) {
            return descr;
        }
        descr = (Descriptor)this.getConstructorDescriptors().get(descrName);
        if (descr != null) {
            return descr;
        }
        return null;
    }

    public synchronized Object clone() {
        try {
            ModelMBeanInfoSupport clone = (ModelMBeanInfoSupport)super.clone();
            clone.mbeanDescriptor = (Descriptor)this.mbeanDescriptor.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private void addDefaultMBeanDescriptorFields(Descriptor descr) {
        if (descr.getFieldValue("name") == null || descr.getFieldValue("name").equals("")) {
            descr.setField("name", this.className);
        }
        if (descr.getFieldValue("descriptortype") == null) {
            descr.setField("descriptortype", "MBean");
        }
        if (!((String)descr.getFieldValue("descriptortype")).equalsIgnoreCase("MBean")) {
            descr.setField("descriptortype", "MBean");
        }
        if (descr.getFieldValue("displayName") == null) {
            descr.setField("displayName", this.className);
        }
        if (descr.getFieldValue("persistPolicy") == null) {
            descr.setField("persistPolicy", "never");
        }
        if (descr.getFieldValue("log") == null) {
            descr.setField("log", "F");
        }
        if (descr.getFieldValue("export") == null) {
            descr.setField("export", "F");
        }
        if (descr.getFieldValue("visibility") == null) {
            descr.setField("visibility", "1");
        }
    }

    private Descriptor createDefaultDescriptor(String className) {
        return new DescriptorSupport(new String[]{"name=" + className, "descriptortype=MBean", "displayName=" + className, "persistPolicy=never", "log=F", "export=F", "visibility=1"});
    }

    private Map getAttributeDescriptors() {
        HashMap<String, Descriptor> map = new HashMap<String, Descriptor>();
        for (int i = 0; i < this.attributes.length; ++i) {
            map.put(this.attributes[i].getName(), ((ModelMBeanAttributeInfo)this.attributes[i]).getDescriptor());
        }
        return map;
    }

    private Map getOperationDescriptors() {
        HashMap<String, Descriptor> map = new HashMap<String, Descriptor>();
        for (int i = 0; i < this.operations.length; ++i) {
            map.put(this.operations[i].getName(), ((ModelMBeanOperationInfo)this.operations[i]).getDescriptor());
        }
        return map;
    }

    private Map getConstructorDescriptors() {
        HashMap<String, Descriptor> map = new HashMap<String, Descriptor>();
        for (int i = 0; i < this.constructors.length; ++i) {
            map.put(this.constructors[i].getName(), ((ModelMBeanConstructorInfo)this.constructors[i]).getDescriptor());
        }
        return map;
    }

    private Map getNotificationDescriptors() {
        HashMap<String, Descriptor> map = new HashMap<String, Descriptor>();
        for (int i = 0; i < this.notifications.length; ++i) {
            map.put(this.notifications[i].getName(), ((ModelMBeanNotificationInfo)this.notifications[i]).getDescriptor());
        }
        return map;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        MBeanOperationInfo[] operInfo;
        MBeanNotificationInfo[] ntfyInfo;
        MBeanConstructorInfo[] consInfo;
        MBeanAttributeInfo[] attrInfo;
        ObjectInputStream.GetField getField = ois.readFields();
        switch (Serialization.version) {
            case 10: {
                attrInfo = (MBeanAttributeInfo[])getField.get("mmbAttributes", null);
                consInfo = (MBeanConstructorInfo[])getField.get("mmbConstructors", null);
                ntfyInfo = (MBeanNotificationInfo[])getField.get("mmbNotifications", null);
                operInfo = (MBeanOperationInfo[])getField.get("mmbOperations", null);
                break;
            }
            default: {
                attrInfo = (MBeanAttributeInfo[])getField.get("modelMBeanAttributes", null);
                consInfo = (MBeanConstructorInfo[])getField.get("modelMBeanConstructors", null);
                ntfyInfo = (MBeanNotificationInfo[])getField.get("modelMBeanNotifications", null);
                operInfo = (MBeanOperationInfo[])getField.get("modelMBeanOperations", null);
            }
        }
        Descriptor desc = (Descriptor)getField.get("modelMBeanDescriptor", null);
        if (desc == null) {
            throw new StreamCorruptedException("Null descriptor?");
        }
        this.attributes = null == attrInfo ? new MBeanAttributeInfo[]{} : attrInfo;
        this.constructors = null == consInfo ? new MBeanConstructorInfo[]{} : consInfo;
        this.operations = null == operInfo ? new MBeanOperationInfo[]{} : operInfo;
        this.notifications = null == ntfyInfo ? new MBeanNotificationInfo[]{} : ntfyInfo;
        try {
            this.setMBeanDescriptor(desc);
        }
        catch (MBeanException e) {
            throw new StreamCorruptedException(e.toString());
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField putField = oos.putFields();
        switch (Serialization.version) {
            case 10: {
                putField.put("mmbAttributes", this.attributes);
                putField.put("mmbConstructors", this.constructors);
                putField.put("mmbNotifications", this.notifications);
                putField.put("mmbOperations", this.operations);
                break;
            }
            default: {
                putField.put("modelMBeanAttributes", this.attributes);
                putField.put("modelMBeanConstructors", this.constructors);
                putField.put("modelMBeanNotifications", this.notifications);
                putField.put("modelMBeanOperations", this.operations);
            }
        }
        putField.put("modelMBeanDescriptor", this.mbeanDescriptor);
        oos.writeFields();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        switch (Serialization.version) {
            case 10: {
                serialVersionUID = -3944083498453227709L;
                serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("mmbAttributes", new MBeanAttributeInfo[0].getClass()), new ObjectStreamField("mmbConstructors", new MBeanConstructorInfo[0].getClass()), new ObjectStreamField("mmbNotifications", new MBeanNotificationInfo[0].getClass()), new ObjectStreamField("mmbOperations", new MBeanOperationInfo[0].getClass()), new ObjectStreamField("modelMBeanDescriptor", class$javax$management$Descriptor == null ? (class$javax$management$Descriptor = ModelMBeanInfoSupport.class$("javax.management.Descriptor")) : class$javax$management$Descriptor)};
                break;
            }
            default: {
                serialVersionUID = -1935722590756516193L;
                serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("modelMBeanAttributes", new MBeanAttributeInfo[0].getClass()), new ObjectStreamField("modelMBeanConstructors", new MBeanConstructorInfo[0].getClass()), new ObjectStreamField("modelMBeanNotifications", new MBeanNotificationInfo[0].getClass()), new ObjectStreamField("modelMBeanOperations", new MBeanOperationInfo[0].getClass()), new ObjectStreamField("modelMBeanDescriptor", class$javax$management$Descriptor == null ? (class$javax$management$Descriptor = ModelMBeanInfoSupport.class$("javax.management.Descriptor")) : class$javax$management$Descriptor)};
            }
        }
    }
}

