/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.XMLParseException;
import org.jboss.logging.Logger;
import org.jboss.mx.util.Serialization;

public class DescriptorSupport
implements Descriptor,
Cloneable,
Serializable {
    private static Logger log = Logger.getLogger(class$javax$management$modelmbean$DescriptorSupport == null ? (class$javax$management$modelmbean$DescriptorSupport = DescriptorSupport.class$("javax.management.modelmbean.DescriptorSupport")) : class$javax$management$modelmbean$DescriptorSupport);
    private Map fieldMap;
    private static final int DEFAULT_SIZE = 20;
    private static final String[] PERSIST_POLICIES = new String[]{"onupdate", "nomoreoftenthan", "never", "ontimer"};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$javax$management$modelmbean$DescriptorSupport;
    static /* synthetic */ Class class$java$util$HashMap;

    public DescriptorSupport() {
        this.fieldMap = Collections.synchronizedMap(new HashMap(20));
    }

    public DescriptorSupport(int initialSize) throws MBeanException {
        if (initialSize <= 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("initialSize <= 0"));
        }
        this.fieldMap = Collections.synchronizedMap(new HashMap(initialSize));
    }

    public DescriptorSupport(DescriptorSupport descriptor) {
        if (descriptor != null) {
            String[] fieldNames = descriptor.getFieldNames();
            this.fieldMap = Collections.synchronizedMap(new HashMap(fieldNames.length));
            this.setFields(fieldNames, descriptor.getFieldValues(fieldNames));
        } else {
            this.fieldMap = Collections.synchronizedMap(new HashMap(20));
        }
    }

    public DescriptorSupport(String[] fieldNames, Object[] fieldValues) throws RuntimeOperationsException {
        this.fieldMap = Collections.synchronizedMap(new HashMap(20));
        this.setFields(fieldNames, fieldValues);
    }

    public DescriptorSupport(String[] fields) {
        if (fields == null) {
            this.fieldMap = Collections.synchronizedMap(new HashMap(20));
            return;
        }
        int j = 0;
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] == null || fields[i].length() == 0) continue;
            ++j;
        }
        this.fieldMap = Collections.synchronizedMap(new HashMap(j));
        String[] names = new String[j];
        Object[] values = new String[j];
        j = 0;
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] == null || fields[i].length() == 0) continue;
            try {
                int index = fields[i].indexOf(61);
                if (index == -1) {
                    throw new IllegalArgumentException("Invalid field " + fields[i]);
                }
                names[j] = fields[i].substring(0, index);
                values[j] = index == fields[i].length() - 1 ? null : fields[i].substring(index + 1, fields[i].length());
                ++j;
                continue;
            }
            catch (RuntimeException e) {
                throw new RuntimeOperationsException(e, "Error in field " + i);
            }
        }
        this.setFields(names, values);
    }

    public DescriptorSupport(String xmlString) throws MBeanException, RuntimeOperationsException, XMLParseException {
        throw new RuntimeException("NYI");
    }

    public Object getFieldValue(String inFieldName) {
        try {
            this.checkFieldName(inFieldName);
            return this.fieldMap.get(inFieldName.toLowerCase());
        }
        catch (RuntimeException e) {
            throw new RuntimeOperationsException(e, e.toString());
        }
    }

    public void setField(String inFieldName, Object fieldValue) {
        try {
            this.checkFieldName(inFieldName);
            this.validateField(inFieldName, fieldValue);
            this.fieldMap.put(inFieldName.toLowerCase(), fieldValue);
        }
        catch (RuntimeException e) {
            throw new RuntimeOperationsException(e, e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getFields() {
        String[] fieldStrings = new String[this.fieldMap.size()];
        Iterator it = this.fieldMap.keySet().iterator();
        Map map = this.fieldMap;
        synchronized (map) {
            for (int i = 0; i < this.fieldMap.size(); ++i) {
                String key = (String)it.next();
                fieldStrings[i] = key + "=" + this.fieldMap.get(key.toLowerCase());
            }
        }
        return fieldStrings;
    }

    public String[] getFieldNames() {
        return this.fieldMap.keySet().toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getFieldValues(String[] fieldNames) {
        Object[] values = null;
        if (fieldNames == null) {
            values = new Object[this.fieldMap.size()];
            Iterator it = this.fieldMap.values().iterator();
            Map map = this.fieldMap;
            synchronized (map) {
                for (int i = 0; i < this.fieldMap.size(); ++i) {
                    values[i] = it.next();
                }
            }
        } else {
            values = new Object[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                values[i] = fieldNames[i] == null || fieldNames[i].equals("") ? null : this.fieldMap.get(fieldNames[i].toLowerCase());
            }
        }
        return values;
    }

    public void setFields(String[] fieldNames, Object[] fieldValues) {
        try {
            if (fieldNames == null || fieldValues == null) {
                throw new IllegalArgumentException("fieldNames or fieldValues was null.");
            }
            if (fieldNames.length == 0 || fieldValues.length == 0) {
                return;
            }
            if (fieldNames.length != fieldValues.length) {
                throw new IllegalArgumentException("fieldNames and fieldValues array size must match.");
            }
            for (int i = 0; i < fieldNames.length; ++i) {
                String name = fieldNames[i];
                this.checkFieldName(name);
                this.validateField(name, fieldValues[i]);
                this.fieldMap.put(name.toLowerCase(), fieldValues[i]);
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeOperationsException(e, e.toString());
        }
    }

    public synchronized Object clone() {
        try {
            DescriptorSupport clone = (DescriptorSupport)super.clone();
            clone.fieldMap = Collections.synchronizedMap(new HashMap(this.fieldMap));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeOperationsException(new RuntimeException(e.getMessage()), e.toString());
        }
    }

    public void removeField(String fieldName) {
        if (fieldName == null || fieldName.equals("")) {
            return;
        }
        this.fieldMap.remove(fieldName.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() throws RuntimeOperationsException {
        try {
            this.validateString("name", true);
            this.validateString("descriptortype", true);
            Map map = this.fieldMap;
            synchronized (map) {
                Iterator i = this.fieldMap.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    String name = (String)entry.getKey();
                    Object value = entry.getValue();
                    this.validateField(name, value);
                }
            }
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid descriptor", e);
            return false;
        }
        catch (RuntimeException e) {
            throw new RuntimeOperationsException(e, e.toString());
        }
        return true;
    }

    public String toXMLString() throws RuntimeOperationsException {
        throw new RuntimeException("NYI");
    }

    public String toString() {
        String[] names = this.getFieldNames();
        Object[] values = this.getFieldValues(names);
        if (names.length == 0) {
            return "<empty descriptor>";
        }
        StringBuffer sbuf = new StringBuffer(500);
        for (int i = 0; i < values.length; ++i) {
            sbuf.append(names[i]);
            sbuf.append("=");
            sbuf.append(values[i]);
            sbuf.append(",");
        }
        sbuf.deleteCharAt(sbuf.length() - 1);
        return sbuf.toString();
    }

    private void checkFieldName(String inFieldName) {
        if (inFieldName == null || inFieldName.equals("")) {
            throw new IllegalArgumentException("null or empty field name");
        }
    }

    private void validateField(String inFieldName, Object value) {
        String fieldName = inFieldName.toLowerCase();
        if (fieldName.equalsIgnoreCase("name")) {
            this.validateString(inFieldName, value, true);
        } else if (fieldName.equalsIgnoreCase("descriptortype")) {
            this.validateString(inFieldName, value, true);
        } else if (fieldName.equalsIgnoreCase("role")) {
            this.validateString(inFieldName, value, false);
        } else if (fieldName.equalsIgnoreCase("getMethod")) {
            this.validateString(inFieldName, value, false);
        } else if (fieldName.equalsIgnoreCase("setMethod")) {
            this.validateString(inFieldName, value, false);
        } else if (fieldName.equalsIgnoreCase("persistPeriod")) {
            this.validateNumeric(inFieldName, value);
        } else if (fieldName.equalsIgnoreCase("currencyTimeLimit")) {
            this.validateNumeric(inFieldName, value);
        } else if (fieldName.equalsIgnoreCase("lastUpdatedTimeStamp")) {
            this.validateNumeric(inFieldName, value);
        } else if (fieldName.equalsIgnoreCase("lastReturnedTimestamp")) {
            this.validateNumeric(inFieldName, value);
        } else if (fieldName.equalsIgnoreCase("log")) {
            this.validateBoolean(inFieldName, value);
        } else if (fieldName.equalsIgnoreCase("visibility")) {
            this.validateNumeric(inFieldName, value, 1, 4);
        } else if (fieldName.equalsIgnoreCase("severity")) {
            this.validateNumeric(inFieldName, value, 1, 6);
        } else if (fieldName.equalsIgnoreCase("persistPolicy")) {
            this.validateString(inFieldName, value, false, PERSIST_POLICIES);
        }
    }

    private void validateString(String fieldName, boolean mandatory) {
        this.validateString(fieldName, this.fieldMap.get(fieldName.toLowerCase()), mandatory);
    }

    private void validateString(String fieldName, Object value, boolean mandatory) {
        if (value == null && mandatory) {
            throw new IllegalArgumentException("Expected a value for mandatory field '" + fieldName + "'");
        }
        if (value == null) {
            throw new IllegalArgumentException("Expected a value for field '" + fieldName + "'");
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Expected a String for field '" + fieldName + "'");
        }
        String string = (String)value;
        if (string.length() == 0) {
            throw new IllegalArgumentException("Empty value for field '" + fieldName + "'");
        }
    }

    private void validateString(String fieldName, Object value, boolean mandatory, String[] validValues) {
        this.validateString(fieldName, value, mandatory);
        String string = ((String)value).toLowerCase();
        for (int i = 0; i < validValues.length; ++i) {
            if (!validValues[i].equals(string)) continue;
            return;
        }
        throw new IllegalArgumentException("Invalid value " + value + " for field '" + fieldName + "' expected one of " + Arrays.asList(validValues));
    }

    private void validateBoolean(String fieldName, Object value) {
        String string;
        if (value == null) {
            throw new IllegalArgumentException("Expected a value for field '" + fieldName + "'");
        }
        if (value instanceof String ? (string = ((String)value).toLowerCase()).equals("t") || string.equals("f") || string.equals("true") || string.equals("false") : value instanceof Boolean) {
            return;
        }
        throw new IllegalArgumentException("Invalid value " + value + " for field '" + fieldName + "'");
    }

    private long validateNumeric(String fieldName, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Expected a value for field '" + fieldName + "'");
        }
        Long number = null;
        if (value instanceof String) {
            number = new Long((String)value);
        } else if (value instanceof Number) {
            number = new Long(((Number)value).longValue());
        }
        if (number != null && number >= -1L) {
            return number;
        }
        throw new IllegalArgumentException("Invalid value " + value + " for field '" + fieldName + "'");
    }

    private void validateNumeric(String fieldName, Object value, int min, int max) {
        long result = this.validateNumeric(fieldName, value);
        if (result >= (long)min && result <= (long)max) {
            return;
        }
        throw new IllegalArgumentException("Invalid value " + value + " for field '" + fieldName + "'");
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = ois.readFields();
        HashMap descriptor = (HashMap)getField.get("descriptor", null);
        if (descriptor == null) {
            throw new StreamCorruptedException("Null descriptor?");
        }
        this.fieldMap = Collections.synchronizedMap(descriptor);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField putField = oos.putFields();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream tstOOS = new ObjectOutputStream(baos);
        HashMap serialMap = new HashMap();
        Iterator it = this.fieldMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object value = entry.getValue();
            if (!(value instanceof Serializable)) continue;
            try {
                baos.reset();
                tstOOS.writeObject(value);
                serialMap.put(entry.getKey(), value);
            }
            catch (Exception ignore) {}
        }
        baos.close();
        tstOOS.close();
        putField.put("descriptor", serialMap);
        oos.writeFields();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        switch (Serialization.version) {
            case 10: {
                serialVersionUID = 8071560848919417985L;
                break;
            }
            default: {
                serialVersionUID = -6292969195866300415L;
            }
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("descriptor", class$java$util$HashMap == null ? (class$java$util$HashMap = DescriptorSupport.class$("java.util.HashMap")) : class$java$util$HashMap)};
    }
}

