/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.vfs.spi.VFSVisitor;
import org.jboss.vfs.spi.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileScanner
implements Iterator<VirtualFile> {
    private static Logger log = Logger.getLogger(FileScanner.class);
    private ArrayList<VirtualFile> acceptedFiles = new ArrayList();
    private Iterator<VirtualFile> iter;

    FileScanner(VirtualFile root, VFSVisitor acceptVisitor) {
        if (acceptVisitor.visit(root)) {
            this.addFile(root, acceptVisitor);
        }
        this.iter = this.acceptedFiles.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public VirtualFile next() {
        VirtualFile vf = this.iter.next();
        return vf;
    }

    @Override
    public void remove() {
    }

    private void addFile(VirtualFile file, VFSVisitor acceptVisitor) {
        VirtualFile[] children;
        this.acceptedFiles.add(file);
        try {
            children = file.getChildren();
        }
        catch (IOException e) {
            log.warn("Failed to obtain children of: " + file.getName(), e);
            return;
        }
        for (VirtualFile vf : children) {
            if (!acceptVisitor.visit(vf)) continue;
            this.addFile(vf, acceptVisitor);
        }
    }
}

