/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs;

import java.io.FileInputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarTraversal {
    static String[] jarSuffixes = new String[]{".jar", ".zip", ".ear", ".war", ".sar"};
    static String jarPrefix = "+- ";
    static String entryPrefix = "|  ";
    static byte[] buffer = new byte[65535];
    static boolean showOnlyArchives = false;

    public static boolean isJar(String name) {
        String suffix;
        boolean isJar = false;
        for (int s = 0; !isJar && s < jarSuffixes.length; isJar |= name.endsWith(suffix), ++s) {
            suffix = jarSuffixes[s];
        }
        return isJar;
    }

    static void processEntry(ZipInputStream zis, ZipEntry entry, int level) throws Exception {
        String name = entry.getName();
        boolean isDirectory = entry.isDirectory();
        if (isDirectory) {
            return;
        }
        if (JarTraversal.isJar(name)) {
            System.out.print(jarPrefix.substring(0, 3 * level));
            System.out.println(name + " (archive)");
            try {
                ZipInputStream entryZIS = new ZipInputStream(zis);
                JarTraversal.processJar(entryZIS, ++level);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (name.endsWith("MANIFEST.MF")) {
            System.out.print(entryPrefix.substring(0, 3 * (level - 1)));
            System.out.print("+- ");
            System.out.print(name);
            Manifest mf = new Manifest(zis);
            Attributes main = mf.getMainAttributes();
            String cp = main.getValue(Attributes.Name.CLASS_PATH);
            if (cp != null) {
                System.out.print(" Class-Path: ");
                System.out.print(cp);
                System.out.print(' ');
            }
            System.out.println();
        } else if (!showOnlyArchives) {
            System.out.print(entryPrefix.substring(0, 3 * (level - 1)));
            System.out.print("+- ");
            System.out.println(name);
        }
    }

    static void processJar(ZipInputStream zis, int level) throws Exception {
        ZipEntry entry;
        while ((entry = zis.getNextEntry()) != null) {
            JarTraversal.processEntry(zis, entry, level);
        }
    }

    public static void main(String[] args) throws Exception {
        String name = args[0];
        FileInputStream fis = new FileInputStream(name);
        ZipInputStream zis = new ZipInputStream(fis);
        System.out.println(name);
        JarTraversal.processJar(zis, 1);
        System.out.println("Done");
    }

    static {
        for (int i = 0; i < 10; ++i) {
            jarPrefix = jarPrefix + "+- ";
            entryPrefix = entryPrefix + "|  ";
        }
    }
}

