/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice;

import java.net.URL;
import java.util.Enumeration;
import org.jboss.deployers.spi.Deployment;
import org.jboss.deployers.spi.MainDeployer;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;

public class ProfileServiceBootstrap
extends BasicBootstrap {
    public static String DEPLOYERS_XML_NAME = "deployer-beans.xml";
    protected String profileName;
    protected BasicXMLDeployer kernelDeployer;
    protected MainDeployer mainDeployer;
    protected ProfileService profileService;
    protected String deployerBeansPrefix;
    protected URL bootstrapURL;

    public ProfileServiceBootstrap() {
        this("default");
    }

    public ProfileServiceBootstrap(String name) {
        this.profileName = name;
    }

    public MainDeployer getMainDeployer() {
        return this.mainDeployer;
    }

    public ProfileService getProfileService() {
        return this.profileService;
    }

    public BasicXMLDeployer getKernelDeployer() {
        return this.kernelDeployer;
    }

    public String getDeployerBeansPrefix() {
        return this.deployerBeansPrefix;
    }

    public void setDeployerBeansPrefix(String prefix) {
        if (prefix != null && prefix.length() == 0) {
            prefix = null;
        }
        this.deployerBeansPrefix = prefix;
    }

    public URL getBootstrapURL() {
        return this.bootstrapURL;
    }

    public void setBootstrapURL(URL bootstrapURL) {
        this.bootstrapURL = bootstrapURL;
    }

    public void bootstrap() throws Throwable {
        super.bootstrap();
        this.kernelDeployer = new BasicXMLDeployer(this.getKernel());
        if (this.bootstrapURL == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            String bootstrapResName = this.deployerBeansPrefix == null ? this.profileName + "/" + DEPLOYERS_XML_NAME : this.deployerBeansPrefix + DEPLOYERS_XML_NAME;
            this.log.debug("Scanning for bootstrap resources: " + bootstrapResName);
            Enumeration<URL> descriptors = cl.getResources(bootstrapResName);
            while (descriptors.hasMoreElements()) {
                URL url = descriptors.nextElement();
                this.deploy(url);
            }
            String metaInfBootstrapResName = "META-INF/" + bootstrapResName;
            this.log.debug("Scanning for bootstrap resources: " + metaInfBootstrapResName);
            descriptors = cl.getResources(metaInfBootstrapResName);
            while (descriptors.hasMoreElements()) {
                URL url = descriptors.nextElement();
                this.deploy(url);
            }
        } else {
            this.deploy(this.bootstrapURL);
        }
        this.kernelDeployer.validate();
        KernelRegistry registry = this.getKernel().getRegistry();
        KernelRegistryEntry mdEntry = registry.getEntry("MainDeployer");
        Object target = mdEntry.getTarget();
        if (!(target instanceof MainDeployer)) {
            StringBuilder tmp = new StringBuilder("Kernel entry MainDeployer(");
            tmp.append(this.mainDeployer);
            tmp.append(") is not an instanceof ");
            tmp.append(MainDeployer.class.getName());
            throw new IllegalStateException(tmp.toString());
        }
        this.mainDeployer = (MainDeployer)target;
        this.log.debug("Using MainDeployer: " + this.mainDeployer);
        KernelRegistryEntry psEntry = registry.getEntry("ProfileService");
        target = psEntry.getTarget();
        if (!(target instanceof ProfileService)) {
            StringBuilder tmp = new StringBuilder("Kernel entry ProfileService(");
            tmp.append(this.profileService);
            tmp.append(") is not an instanceof ");
            tmp.append(ProfileService.class.getName());
            throw new IllegalStateException(tmp.toString());
        }
        this.profileService = (ProfileService)target;
        this.log.debug("Using ProfileService: " + this.profileService);
        this.loadProfile(this.profileName);
    }

    protected void deploy(URL url) throws Throwable {
        this.log.debug("Deploying bootstrap config: " + url);
        this.kernelDeployer.deploy(url);
    }

    protected void undeploy(URL url) {
        try {
            this.log.debug("Undeploying bootstrap config: " + url);
            this.kernelDeployer.undeploy(url);
        }
        catch (Throwable t) {
            this.log.warn("Error during undeployment: " + url, t);
        }
    }

    protected void loadProfile(String name) throws Throwable {
        Deployment[] profileDeployments;
        MainDeployer deployer = this.getMainDeployer();
        if (deployer == null) {
            throw new NullPointerException("MainDeployer has not been set");
        }
        ProfileService ps = this.getProfileService();
        if (ps == null) {
            throw new NullPointerException("ProfileService has not been set");
        }
        ProfileKey key = new ProfileKey(name);
        Profile profile = ps.getProfile(key);
        for (Deployment d : profileDeployments = profile.getDeployments()) {
            this.log.debug("Deploying: " + d);
            deployer.deploy(d);
        }
    }
}

