/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.metadata;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.system.metadata.AbstractMetaDataVisitorNode;
import org.jboss.system.metadata.ServiceMetaDataVisitor;
import org.jboss.system.microcontainer.LifecycleDependencyItem;
import org.jboss.system.microcontainer.ServiceControllerContext;

public class ServiceDependencyMetaData
extends AbstractMetaDataVisitorNode {
    private String iDependOn;
    private ObjectName iDependOnObjectName;

    public String getIDependOn() {
        if (this.iDependOn == null) {
            return this.iDependOnObjectName.getCanonicalName();
        }
        return this.iDependOn;
    }

    public void setIDependOn(String iDependOn) {
        if (iDependOn == null) {
            throw new IllegalArgumentException("Null iDependOn");
        }
        this.iDependOn = iDependOn;
        this.iDependOnObjectName = null;
    }

    public ObjectName getIDependOnObjectName() throws MalformedObjectNameException {
        if (this.iDependOnObjectName == null) {
            if (this.iDependOn.trim().length() == 0) {
                throw new MalformedObjectNameException("Missing object name in depends");
            }
            ObjectName objectName = new ObjectName(this.iDependOn);
            if (objectName.isPattern()) {
                throw new MalformedObjectNameException("ObjectName patterns are not allowed in depends: " + this.iDependOn);
            }
            this.iDependOnObjectName = objectName;
            this.iDependOn = null;
        }
        return this.iDependOnObjectName;
    }

    public void setIDependOnObjectName(ObjectName iDependOn) {
        if (iDependOn == null) {
            throw new IllegalArgumentException("Null iDependOn");
        }
        this.iDependOnObjectName = iDependOn;
    }

    public void visit(ServiceMetaDataVisitor visitor) {
        ServiceControllerContext context = visitor.getControllerContext();
        Object name = context.getName();
        String other = this.iDependOn;
        try {
            other = this.getIDependOnObjectName().getCanonicalName();
        }
        catch (MalformedObjectNameException ignored) {
            // empty catch block
        }
        visitor.addDependency(new LifecycleDependencyItem(name, other, ControllerState.CREATE));
        visitor.addDependency(new LifecycleDependencyItem(name, other, ControllerState.START));
        visitor.visit(this);
    }
}

