/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.DecodeAction;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

public class LdapExtLoginModule
extends UsernamePasswordLoginModule {
    private static final String ROLES_CTX_DN_OPT = "rolesCtxDN";
    private static final String ROLE_ATTRIBUTE_ID_OPT = "roleAttributeID";
    private static final String ROLE_ATTRIBUTE_IS_DN_OPT = "roleAttributeIsDN";
    private static final String ROLE_NAME_ATTRIBUTE_ID_OPT = "roleNameAttributeID";
    private static final String BIND_DN = "bindDN";
    private static final String BIND_CREDENTIAL = "bindCredential";
    private static final String BASE_CTX_DN = "baseCtxDN";
    private static final String BASE_FILTER_OPT = "baseFilter";
    private static final String ROLE_FILTER_OPT = "roleFilter";
    private static final String ROLE_RECURSION = "roleRecursion";
    private static final String DEFAULT_ROLE = "defaultRole";
    private static final String SEARCH_TIME_LIMIT_OPT = "searchTimeLimit";
    private static final String SEARCH_SCOPE_OPT = "searchScope";
    private static final String SECURITY_DOMAIN_OPT = "jaasSecurityDomain";
    protected String bindDN;
    protected String bindCredential;
    protected String baseDN;
    protected String baseFilter;
    protected String rolesCtxDN;
    protected String roleFilter;
    protected String roleAttributeID;
    protected String roleNameAttributeID;
    protected boolean roleAttributeIsDN;
    protected int recursion = 0;
    protected int searchTimeLimit = 10000;
    protected int searchScope = 2;
    protected boolean trace;
    private transient SimpleGroup userRoles = new SimpleGroup("Roles");

    protected String getUsersPassword() throws LoginException {
        return "";
    }

    protected Group[] getRoleSets() throws LoginException {
        Group[] roleSets = new Group[]{this.userRoles};
        return roleSets;
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        boolean isValid = false;
        if (inputPassword != null) {
            if (inputPassword.length() == 0) {
                boolean allowEmptyPasswords = true;
                String flag = (String)this.options.get("allowEmptyPasswords");
                if (flag != null) {
                    allowEmptyPasswords = Boolean.valueOf(flag);
                }
                if (!allowEmptyPasswords) {
                    this.log.trace("Rejecting empty password due to allowEmptyPasswords");
                    return false;
                }
            }
            try {
                String username = this.getUsername();
                isValid = this.createLdapInitContext(username, inputPassword);
                this.defaultRole();
                isValid = true;
            }
            catch (Throwable e) {
                super.setValidateError(e);
            }
        }
        return isValid;
    }

    private void defaultRole() {
        try {
            String defaultRole = (String)this.options.get(DEFAULT_ROLE);
            if (defaultRole == null || defaultRole.equals("")) {
                return;
            }
            Principal p = super.createIdentity(defaultRole);
            this.log.trace("Assign user to role " + defaultRole);
            this.userRoles.addMember(p);
        }
        catch (Exception e) {
            this.log.debug("could not add default role to user", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createLdapInitContext(String username, Object credential) throws Exception {
        String scope;
        block17: {
            this.bindDN = (String)this.options.get(BIND_DN);
            this.bindCredential = (String)this.options.get(BIND_CREDENTIAL);
            String securityDomain = (String)this.options.get(SECURITY_DOMAIN_OPT);
            if (securityDomain != null) {
                ObjectName serviceName = new ObjectName(securityDomain);
                char[] tmp = DecodeAction.decode(this.bindCredential, serviceName);
                this.bindCredential = new String(tmp);
            }
            this.baseDN = (String)this.options.get(BASE_CTX_DN);
            this.baseFilter = (String)this.options.get(BASE_FILTER_OPT);
            this.roleFilter = (String)this.options.get(ROLE_FILTER_OPT);
            this.roleAttributeID = (String)this.options.get(ROLE_ATTRIBUTE_ID_OPT);
            if (this.roleAttributeID == null) {
                this.roleAttributeID = "role";
            }
            String roleAttributeIsDNOption = (String)this.options.get(ROLE_ATTRIBUTE_IS_DN_OPT);
            this.roleAttributeIsDN = Boolean.valueOf(roleAttributeIsDNOption);
            this.roleNameAttributeID = (String)this.options.get(ROLE_NAME_ATTRIBUTE_ID_OPT);
            if (this.roleNameAttributeID == null) {
                this.roleNameAttributeID = "name";
            }
            this.rolesCtxDN = (String)this.options.get(ROLES_CTX_DN_OPT);
            String strRecursion = (String)this.options.get(ROLE_RECURSION);
            try {
                this.recursion = Integer.parseInt(strRecursion);
            }
            catch (Exception e) {
                if (this.trace) {
                    this.log.trace("Failed to parse: " + strRecursion + ", disabling recursion");
                }
                this.recursion = 0;
            }
            String timeLimit = (String)this.options.get(SEARCH_TIME_LIMIT_OPT);
            if (timeLimit != null) {
                try {
                    this.searchTimeLimit = Integer.parseInt(timeLimit);
                }
                catch (NumberFormatException e) {
                    if (!this.trace) break block17;
                    this.log.trace("Failed to parse: " + timeLimit + ", using searchTimeLimit=" + this.searchTimeLimit);
                }
            }
        }
        if ("OBJECT_SCOPE".equalsIgnoreCase(scope = (String)this.options.get(SEARCH_SCOPE_OPT))) {
            this.searchScope = 0;
        } else if ("ONELEVEL_SCOPE".equalsIgnoreCase(scope)) {
            this.searchScope = 1;
        }
        if ("SUBTREE_SCOPE".equalsIgnoreCase(scope)) {
            this.searchScope = 2;
        }
        InitialContext ctx = null;
        try {
            ctx = this.constructInitialLdapContext(this.bindDN, this.bindCredential);
            String userDN = this.bindDNAuthentication((InitialLdapContext)ctx, username, credential, this.baseDN, this.baseFilter);
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(this.searchScope);
            constraints.setReturningAttributes(new String[0]);
            constraints.setTimeLimit(this.searchTimeLimit);
            this.rolesSearch((InitialLdapContext)ctx, constraints, username, userDN, this.recursion, 0);
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
        return true;
    }

    protected String bindDNAuthentication(InitialLdapContext ctx, String user, Object credential, String baseDN, String filter) throws NamingException {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        constraints.setReturningAttributes(new String[0]);
        constraints.setTimeLimit(this.searchTimeLimit);
        NamingEnumeration<SearchResult> results = null;
        Object[] filterArgs = new Object[]{user};
        results = ctx.search(baseDN, filter, filterArgs, constraints);
        if (!results.hasMore()) {
            throw new NamingException("Search of baseDN(" + baseDN + ") found no matches");
        }
        SearchResult sr = results.next();
        String name = sr.getName();
        String userDN = null;
        if (!sr.isRelative()) {
            throw new NamingException("Can't follow referal for authentication: " + name);
        }
        userDN = name + "," + baseDN;
        results = null;
        InitialLdapContext userCtx = this.constructInitialLdapContext(userDN, credential);
        userCtx.close();
        return userDN;
    }

    protected void rolesSearch(InitialLdapContext ctx, SearchControls constraints, String user, String userDN, int recursionMax, int nesting) throws NamingException {
        Object[] filterArgs = new Object[]{user, userDN};
        NamingEnumeration<SearchResult> results = ctx.search(this.rolesCtxDN, this.roleFilter, filterArgs, constraints);
        while (results.hasMore()) {
            String[] attrNames;
            SearchResult sr = results.next();
            String dn = this.canonicalize(sr.getName());
            Attributes result = ctx.getAttributes(dn, attrNames = new String[]{this.roleAttributeID});
            if (result != null && result.size() > 0) {
                Attribute roles = result.get(this.roleAttributeID);
                for (int n = 0; n < roles.size(); ++n) {
                    String roleName = (String)roles.get(n);
                    try {
                        if (this.roleAttributeIsDN) {
                            String roleDN = roleName;
                            String[] returnAttribute = new String[]{this.roleNameAttributeID};
                            this.log.trace("Using roleDN: " + roleDN);
                            try {
                                result = ctx.getAttributes(roleDN, returnAttribute);
                                if (result.get(this.roleNameAttributeID) != null) {
                                    roleName = result.get(this.roleNameAttributeID).get().toString();
                                }
                            }
                            catch (NamingException e) {
                                this.log.trace("Failed to query roleNameAttrName", e);
                            }
                        }
                        Principal p = super.createIdentity(roleName);
                        this.log.trace("Assign user to role " + roleName);
                        this.userRoles.addMember(p);
                        continue;
                    }
                    catch (Exception e) {
                        this.log.debug("Failed to create principal: " + roleName, e);
                    }
                }
            }
            if (nesting >= recursionMax) continue;
            this.rolesSearch(ctx, constraints, user, dn, recursionMax, nesting + 1);
        }
    }

    private InitialLdapContext constructInitialLdapContext(String dn, Object credential) throws NamingException {
        String authType;
        Properties env = new Properties();
        Iterator iter = this.options.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            env.put(entry.getKey(), entry.getValue());
        }
        String factoryName = env.getProperty("java.naming.factory.initial");
        if (factoryName == null) {
            factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
            env.setProperty("java.naming.factory.initial", factoryName);
        }
        if ((authType = env.getProperty("java.naming.security.authentication")) == null) {
            env.setProperty("java.naming.security.authentication", "simple");
        }
        String protocol = env.getProperty("java.naming.security.protocol");
        String providerURL = (String)this.options.get("java.naming.provider.url");
        if (providerURL == null) {
            providerURL = "ldap://localhost:" + (protocol != null && protocol.equals("ssl") ? "636" : "389");
        }
        env.setProperty("java.naming.provider.url", providerURL);
        if (dn != null) {
            env.setProperty("java.naming.security.principal", dn);
        }
        if (credential != null) {
            env.put("java.naming.security.credentials", credential);
        }
        this.traceLdapEnv(env);
        return new InitialLdapContext(env, null);
    }

    private void traceLdapEnv(Properties env) {
        if (this.trace) {
            Properties tmp = new Properties();
            tmp.putAll((Map<?, ?>)env);
            tmp.setProperty("java.naming.security.credentials", "***");
            this.log.trace("Logging into LDAP server, env=" + tmp.toString());
        }
    }

    private String canonicalize(String searchResult) {
        String result = searchResult;
        int len = searchResult.length();
        result = searchResult.endsWith("\"") ? searchResult.substring(0, len - 1) + "," + this.rolesCtxDN + "\"" : searchResult + "," + this.rolesCtxDN;
        return result;
    }
}

