/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import java.lang.ref.SoftReference;
import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.server.BasicQueue;
import org.jboss.mq.server.MessageCache;
import org.jboss.mq.server.PersistentQueue;

public class MessageReference
implements Comparable {
    static Logger log = Logger.getLogger(MessageReference.class);
    public static final int NOT_STORED = 1;
    public static final int STORED = 2;
    public static final int REMOVED = 3;
    public long referenceId;
    public SpyMessage hardReference;
    public byte jmsPriority;
    public long messageId;
    public int jmsDeliveryMode;
    public long messageScheduledDelivery;
    public long messageExpiration;
    public boolean redelivered;
    public long redeliveryDelay;
    public int redeliveryCount;
    public BasicQueue queue;
    public MessageCache messageCache;
    public SoftReference softReference;
    public DurableSubscriptionID durableSubscriberID;
    public int stored;
    public transient Object persistData;

    MessageReference() {
    }

    void init(MessageCache messageCache, long referenceId, SpyMessage message, BasicQueue queue, DurableSubscriptionID id) throws JMSException {
        this.messageCache = messageCache;
        this.hardReference = message;
        this.referenceId = referenceId;
        this.jmsPriority = (byte)message.getJMSPriority();
        this.messageId = message.header.messageId;
        this.stored = 1;
        this.jmsDeliveryMode = message.header.jmsDeliveryMode;
        if (message.propertyExists("JMS_JBOSS_SCHEDULED_DELIVERY")) {
            this.messageScheduledDelivery = message.getLongProperty("JMS_JBOSS_SCHEDULED_DELIVERY");
        }
        if (message.propertyExists("JMS_JBOSS_REDELIVERY_DELAY")) {
            this.redeliveryDelay = message.getLongProperty("JMS_JBOSS_REDELIVERY_DELAY");
        } else if (queue.parameters.redeliveryDelay > 0L) {
            this.redeliveryDelay = queue.parameters.redeliveryDelay;
        }
        if (queue.parameters.redeliveryLimit > -1 && !message.propertyExists("JMS_JBOSS_REDELIVERY_LIMIT")) {
            message.header.jmsProperties.put("JMS_JBOSS_REDELIVERY_LIMIT", new Integer(queue.parameters.redeliveryLimit));
        }
        this.messageExpiration = message.getJMSExpiration();
        this.redelivered = message.getJMSRedelivered();
        if (message.propertyExists("JMS_JBOSS_REDELIVERY_COUNT")) {
            this.redeliveryCount = message.getIntProperty("JMS_JBOSS_REDELIVERY_COUNT");
        }
        this.durableSubscriberID = id;
        this.queue = queue;
        this.persistData = null;
    }

    void reset() {
        if (this.softReference != null && this.softReference.get() != null) {
            --this.messageCache.softRefCacheSize;
        }
        this.messageCache = null;
        this.hardReference = null;
        this.softReference = null;
        this.queue = null;
    }

    public SpyMessage getMessageForDelivery() throws JMSException {
        SpyMessage message = this.getMessage();
        if (this.queue.parameters.lateClone) {
            message = message.myClone();
            message.header.durableSubscriberID = this.durableSubscriberID;
            message.header.jmsRedelivered = this.redelivered;
            message.header.jmsProperties.put("JMS_JBOSS_REDELIVERY_COUNT", new Integer(this.redeliveryCount));
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpyMessage getMessage() throws JMSException {
        SpyMessage result = null;
        MessageReference messageReference = this;
        synchronized (messageReference) {
            if (this.hardReference == null) {
                this.makeHard();
                result = this.hardReference;
                this.messageCache.messageReferenceUsedEvent(this, false);
            } else {
                result = this.hardReference;
                ++this.messageCache.cacheHits;
                this.messageCache.messageReferenceUsedEvent(this, true);
            }
            return result;
        }
    }

    public void redelivered() throws JMSException {
        this.redelivered = true;
        if (this.redeliveryDelay != 0L) {
            log.trace("message has redelivery delay");
            this.messageScheduledDelivery = System.currentTimeMillis() + this.redeliveryDelay;
        }
        ++this.redeliveryCount;
        if (!this.isLateClone()) {
            SpyMessage message = this.getMessage();
            message.setJMSRedelivered(this.redelivered);
            message.header.jmsProperties.put("JMS_JBOSS_REDELIVERY_COUNT", new Integer(this.redeliveryCount));
        }
    }

    public boolean isExpired() {
        if (this.messageExpiration == 0L) {
            return false;
        }
        long ts = System.currentTimeMillis();
        return this.messageExpiration < ts;
    }

    public boolean isPersistent() {
        return this.queue instanceof PersistentQueue && this.jmsDeliveryMode == 2;
    }

    public boolean inMemory() {
        return this.queue.parameters.inMemory;
    }

    public String getPersistentKey() {
        return this.queue.getDescription();
    }

    public boolean isLateClone() {
        return this.queue.parameters.lateClone;
    }

    public SpyMessage.Header getHeaders() throws JMSException {
        return this.getMessage().header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() throws JMSException {
        MessageReference messageReference = this;
        synchronized (messageReference) {
            if (this.stored == 2) {
                this.messageCache.removeFromStorage(this);
            }
            this.stored = 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() throws JMSException {
        MessageReference messageReference = this;
        synchronized (messageReference) {
            if (this.stored == 2) {
                if (this.hardReference == null) {
                    this.makeHard();
                    this.messageCache.messageReferenceUsedEvent(this, false);
                }
                this.messageCache.removeFromStorage(this);
            }
        }
    }

    public void removeDelayed() throws JMSException {
        this.messageCache.removeDelayed(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void makeSoft() throws JMSException {
        boolean trace = log.isTraceEnabled();
        MessageReference messageReference = this;
        synchronized (messageReference) {
            if (this.stored == 3) {
                throw new JMSException("CACHE ERROR: makeSoft() on a removed message " + this);
            }
            if (this.softReference != null) {
                if (this.stored == 1) {
                    throw new JMSException("CACHE ERROR: soft reference to unstored message " + this);
                }
                return;
            }
            if (this.stored == 1) {
                this.messageCache.saveToStorage(this, this.hardReference);
            }
            if (this.stored != 2) {
                if (trace) {
                    log.trace("saveToStorage rejected by cache " + this.toString());
                }
                return;
            }
            if (this.messageCache.getMakeSoftReferences()) {
                this.softReference = new SoftReference<SpyMessage>(this.hardReference, this.messageCache.referenceQueue);
            }
            this.messageCache.soften(this);
            this.hardReference = null;
        }
    }

    public void setStored(int stored) {
        this.stored = stored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void makeHard() throws JMSException {
        MessageReference messageReference = this;
        synchronized (messageReference) {
            if (this.stored == 3) {
                throw new JMSException("CACHE ERROR: makeHard() on a removed message " + this);
            }
            if (this.hardReference != null) {
                return;
            }
            if (this.softReference != null) {
                this.hardReference = (SpyMessage)this.softReference.get();
            }
            if (this.hardReference == null) {
                this.hardReference = this.messageCache.loadFromStorage(this);
                ++this.messageCache.cacheMisses;
            } else {
                ++this.messageCache.cacheHits;
            }
            if (this.softReference != null && this.softReference.get() != null) {
                --this.messageCache.softRefCacheSize;
            }
            this.softReference = null;
        }
    }

    public boolean equals(Object o) {
        try {
            return this.referenceId == ((MessageReference)o).referenceId;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public int compareTo(Object o) {
        MessageReference sm = (MessageReference)o;
        if (this.jmsPriority > sm.jmsPriority) {
            return -1;
        }
        if (this.jmsPriority < sm.jmsPriority) {
            return 1;
        }
        return (int)(this.messageId - sm.messageId);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        if (this.messageCache == null) {
            buffer.append(" NOT IN CACHE hashCode=").append(this.hashCode());
        } else {
            buffer.append(this.referenceId);
            buffer.append(" msg=").append(this.messageId);
            if (this.hardReference != null) {
                buffer.append(" hard");
            }
            if (this.softReference != null) {
                buffer.append(" soft");
            }
            switch (this.stored) {
                case 1: {
                    buffer.append(" NOT_STORED");
                    break;
                }
                case 2: {
                    buffer.append(" STORED");
                    break;
                }
                case 3: {
                    buffer.append(" REMOVED");
                }
            }
            switch (this.jmsDeliveryMode) {
                case 1: {
                    buffer.append(" NON_PERSISTENT");
                    break;
                }
                case 2: {
                    buffer.append(" PERSISTENT");
                }
            }
            if (this.persistData != null) {
                buffer.append(" persistData=").append(this.persistData);
            }
            if (this.queue != null) {
                buffer.append(" queue=").append(this.queue.getDescription());
            } else {
                buffer.append(" NO_QUEUE");
            }
            buffer.append(" priority=").append(this.jmsPriority);
            buffer.append(" lateClone=").append(this.isLateClone());
            buffer.append(" hashCode=").append(this.hashCode());
        }
        return buffer.toString();
    }
}

