/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.ClusterConfigMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.mx.util.ObjectNameFactory;
import org.w3c.dom.Element;

public class ConfigurationMetaData
extends MetaData {
    public static final String CMP_2x_13 = "Standard CMP 2.x EntityBean";
    public static final String CMP_1x_13 = "Standard CMP EntityBean";
    public static final String BMP_13 = "Standard BMP EntityBean";
    public static final String STATELESS_13 = "Standard Stateless SessionBean";
    public static final String STATEFUL_13 = "Standard Stateful SessionBean";
    public static final String MESSAGE_DRIVEN_13 = "Standard Message Driven Bean";
    public static final String MESSAGE_INFLOW_DRIVEN = "Standard Message Inflow Driven Bean";
    public static final String CLUSTERED_CMP_2x_13 = "Clustered CMP 2.x EntityBean";
    public static final String CLUSTERED_CMP_1x_13 = "Clustered CMP EntityBean";
    public static final String CLUSTERED_BMP_13 = "Clustered BMP EntityBean";
    public static final String CLUSTERED_STATEFUL_13 = "Clustered Stateful SessionBean";
    public static final String CLUSTERED_STATELESS_13 = "Clustered Stateless SessionBean";
    public static final byte A_COMMIT_OPTION = 0;
    public static final byte B_COMMIT_OPTION = 1;
    public static final byte C_COMMIT_OPTION = 2;
    public static final byte D_COMMIT_OPTION = 3;
    public static final String[] commitOptionStrings = new String[]{"A", "B", "C", "D"};
    private String name;
    private String instancePool;
    private String instanceCache;
    private String persistenceManager;
    private String webClassLoader = "org.jboss.web.WebClassLoader";
    private String lockClass = "org.jboss.ejb.plugins.lock.QueuedPessimisticEJBLock";
    private byte commitOption;
    private long optionDRefreshRate = 30000L;
    private boolean callLogging;
    private boolean syncOnCommitOnly = false;
    private boolean insertAfterEjbPostCreate = false;
    private String securityDomain;
    private String[] invokerNames;
    private Element containerPoolConf;
    private Element containerCacheConf;
    private Element containerInterceptorsConf;
    private Collection depends = new LinkedList();
    private ClusterConfigMetaData clusterConfig = null;
    private boolean ejbStoreForClean;
    private boolean storeNotFlushed = true;

    public ConfigurationMetaData(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getInstancePool() {
        return this.instancePool;
    }

    public String getInstanceCache() {
        return this.instanceCache;
    }

    public String getPersistenceManager() {
        return this.persistenceManager;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public String[] getInvokers() {
        return this.invokerNames;
    }

    public String getWebClassLoader() {
        return this.webClassLoader;
    }

    public String getLockClass() {
        return this.lockClass;
    }

    public Element getContainerPoolConf() {
        return this.containerPoolConf;
    }

    public Element getContainerCacheConf() {
        return this.containerCacheConf;
    }

    public String getDefaultInvokerName() {
        if (this.invokerNames.length == 0) {
            throw new IllegalStateException("No invokers defined");
        }
        return this.invokerNames[0];
    }

    public Element getContainerInterceptorsConf() {
        return this.containerInterceptorsConf;
    }

    public boolean getCallLogging() {
        return this.callLogging;
    }

    public boolean getSyncOnCommitOnly() {
        return this.syncOnCommitOnly;
    }

    public boolean isInsertAfterEjbPostCreate() {
        return this.insertAfterEjbPostCreate;
    }

    public boolean isEjbStoreForClean() {
        return this.ejbStoreForClean;
    }

    public boolean isStoreNotFlushed() {
        return this.storeNotFlushed;
    }

    public byte getCommitOption() {
        return this.commitOption;
    }

    public long getOptionDRefreshRate() {
        return this.optionDRefreshRate;
    }

    public ClusterConfigMetaData getClusterConfigMetaData() {
        return this.clusterConfig;
    }

    public Collection getDepends() {
        return this.depends;
    }

    public void importJbossXml(Element element) throws DeploymentException {
        this.callLogging = Boolean.valueOf(ConfigurationMetaData.getElementContent(ConfigurationMetaData.getOptionalChild(element, "call-logging"), String.valueOf(this.callLogging)));
        this.syncOnCommitOnly = Boolean.valueOf(ConfigurationMetaData.getElementContent(ConfigurationMetaData.getOptionalChild(element, "sync-on-commit-only"), String.valueOf(this.syncOnCommitOnly)));
        this.insertAfterEjbPostCreate = Boolean.valueOf(ConfigurationMetaData.getElementContent(ConfigurationMetaData.getOptionalChild(element, "insert-after-ejb-post-create"), String.valueOf(this.insertAfterEjbPostCreate)));
        this.ejbStoreForClean = Boolean.valueOf(ConfigurationMetaData.getElementContent(ConfigurationMetaData.getOptionalChild(element, "call-ejb-store-on-clean"), String.valueOf(this.ejbStoreForClean)));
        this.storeNotFlushed = Boolean.valueOf(ConfigurationMetaData.getElementContent(ConfigurationMetaData.getOptionalChild(element, "store-not-flushed"), String.valueOf(this.storeNotFlushed)));
        this.instancePool = ConfigurationMetaData.getElementContent(ConfigurationMetaData.getOptionalChild(element, "instance-pool"), this.instancePool);
        this.instanceCache = ConfigurationMetaData.getElementContent(ConfigurationMetaData.getOptionalChild(element, "instance-cache"), this.instanceCache);
        this.persistenceManager = ConfigurationMetaData.getElementContent(ConfigurationMetaData.getOptionalChild(element, "persistence-manager"), this.persistenceManager);
        this.webClassLoader = ConfigurationMetaData.getElementContent(ConfigurationMetaData.getOptionalChild(element, "web-class-loader"), this.webClassLoader);
        this.lockClass = ConfigurationMetaData.getElementContent(ConfigurationMetaData.getOptionalChild(element, "locking-policy"), this.lockClass);
        this.securityDomain = ConfigurationMetaData.getElementContent(ConfigurationMetaData.getOptionalChild(element, "security-domain"), this.securityDomain);
        ArrayList<String> invokers = new ArrayList<String>();
        Iterator invokerElements = ConfigurationMetaData.getChildrenByTagName(element, "invoker-proxy-binding-name");
        while (invokerElements.hasNext()) {
            Element invokerElement = (Element)invokerElements.next();
            String invokerName = ConfigurationMetaData.getElementContent(invokerElement);
            invokers.add(invokerName);
        }
        this.invokerNames = invokers.toArray(new String[invokers.size()]);
        String commit = ConfigurationMetaData.getElementContent(ConfigurationMetaData.getOptionalChild(element, "commit-option"), ConfigurationMetaData.commitOptionToString(this.commitOption));
        this.commitOption = ConfigurationMetaData.stringToCommitOption(commit);
        String refresh = ConfigurationMetaData.getElementContent(ConfigurationMetaData.getOptionalChild(element, "optiond-refresh-rate"), Long.toString(this.optionDRefreshRate / 1000L));
        this.optionDRefreshRate = ConfigurationMetaData.stringToRefreshRate(refresh);
        this.containerInterceptorsConf = ConfigurationMetaData.getOptionalChild(element, "container-interceptors", this.containerInterceptorsConf);
        this.containerPoolConf = ConfigurationMetaData.getOptionalChild(element, "container-pool-conf", this.containerPoolConf);
        this.containerCacheConf = ConfigurationMetaData.getOptionalChild(element, "container-cache-conf", this.containerCacheConf);
        Iterator dependsElements = ConfigurationMetaData.getChildrenByTagName(element, "depends");
        while (dependsElements.hasNext()) {
            Element dependsElement = (Element)dependsElements.next();
            String dependsName = ConfigurationMetaData.getElementContent(dependsElement);
            this.depends.add(ObjectNameFactory.create(dependsName));
        }
        Element clusterConfigElement = ConfigurationMetaData.getOptionalChild(element, "cluster-config");
        if (clusterConfigElement != null) {
            this.clusterConfig = new ClusterConfigMetaData();
            this.clusterConfig.importJbossXml(clusterConfigElement);
        }
    }

    private static String commitOptionToString(byte commitOption) throws DeploymentException {
        try {
            return commitOptionStrings[commitOption];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DeploymentException("Invalid commit option: " + commitOption);
        }
    }

    private static byte stringToCommitOption(String commitOption) throws DeploymentException {
        for (byte i = 0; i < commitOptionStrings.length; i = (byte)(i + 1)) {
            if (!commitOptionStrings[i].equals(commitOption)) continue;
            return i;
        }
        throw new DeploymentException("Invalid commit option: '" + commitOption + "'");
    }

    private static long stringToRefreshRate(String refreshRate) throws DeploymentException {
        try {
            long rate = Long.parseLong(refreshRate);
            return rate *= 1000L;
        }
        catch (Exception e) {
            throw new DeploymentException("Invalid optiond-refresh-rate '" + refreshRate + "'. Should be a number");
        }
    }
}

