/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;

public class KernelPermission
extends BasicPermission {
    private static final long serialVersionUID = 5661980843569388590L;
    private transient boolean allNames;

    public KernelPermission(String name) {
        this(name, null);
    }

    public KernelPermission(String name, String actions) {
        super(name, actions);
        this.init(name, actions);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(this.getClass().getName()).append(":");
        buffer.append(" name=").append(this.getName());
        buffer.append(" actions=").append(this.getActions());
        return buffer.toString();
    }

    public boolean implies(Permission p) {
        String n1;
        String n0;
        boolean implies;
        if (!(p instanceof KernelPermission)) {
            return false;
        }
        boolean bl = implies = this.allNames;
        if (!implies && !(implies = (n0 = this.getName()).equals(n1 = p.getName()))) {
            implies = n0.equals("configure") && n1.equals("access");
        }
        return implies;
    }

    public PermissionCollection newPermissionCollection() {
        return new KernelPermissionCollection();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.init(this.getName(), this.getActions());
    }

    private void init(String name, String actions) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (actions != null && actions.length() > 0) {
            throw new IllegalArgumentException("actions must be null or empty");
        }
        if (!(name.equals("*") || name.equals("access") || name.equals("configure"))) {
            throw new IllegalArgumentException("Unknown name: " + name);
        }
        this.allNames = name.equals("*");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KernelPermissionCollection
    extends PermissionCollection {
        private static final long serialVersionUID = 3256442516797665329L;
        private HashSet<Permission> permissions = new HashSet();
        private boolean hasAll;

        KernelPermissionCollection() {
        }

        @Override
        public void add(Permission p) {
            if (this.isReadOnly()) {
                throw new SecurityException("Collection is read-only");
            }
            if (p instanceof KernelPermission) {
                this.permissions.add(p);
            }
            if (p.getName().equals("configure")) {
                this.permissions.add(new KernelPermission("access"));
            } else if (p.getName().equals("*")) {
                this.hasAll = true;
            }
        }

        @Override
        public boolean implies(Permission p) {
            boolean implies = false;
            if (p instanceof KernelPermission && !(implies = this.hasAll)) {
                implies = this.permissions.contains(p);
            }
            return implies;
        }

        @Override
        public Enumeration<Permission> elements() {
            final Iterator<Permission> iter = this.permissions.iterator();
            Enumeration<Permission> enumerator = new Enumeration<Permission>(){

                @Override
                public boolean hasMoreElements() {
                    return iter.hasNext();
                }

                @Override
                public Permission nextElement() {
                    return (Permission)iter.next();
                }
            };
            return enumerator;
        }
    }
}

