/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionHandler;
import org.jboss.injection.InjectionUtil;
import org.jboss.injection.Injector;
import org.jboss.injection.JndiFieldInjector;
import org.jboss.injection.JndiMethodInjector;
import org.jboss.injection.LinkRefEncInjector;
import org.jboss.logging.Logger;
import org.jboss.metamodel.descriptor.EnvironmentRefGroup;
import org.jboss.metamodel.descriptor.WebServiceRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceHandler
implements InjectionHandler {
    private static final Logger log = Logger.getLogger(WebServiceHandler.class);

    @Override
    public void loadXml(EnvironmentRefGroup xml, InjectionContainer container) {
        if (xml == null) {
            return;
        }
        if (xml.getWebServiceRefs() == null) {
            return;
        }
        for (WebServiceRef wsRef : xml.getWebServiceRefs()) {
            if (wsRef.getMappedName() == null || wsRef.getMappedName().equals("")) {
                throw new RuntimeException("mapped-name is required for <service-ref> " + wsRef.getServiceRefName() + " of " + container.getIdentifier());
            }
            String encName = "env/" + wsRef.getServiceRefName();
            if (!container.getEncInjectors().containsKey(encName)) {
                container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, wsRef.getMappedName(), "jndi ref"));
            }
            InjectionUtil.injectionTarget(encName, wsRef, container, container.getEncInjections());
        }
    }

    @Override
    public void handleClassAnnotations(Class clazz, InjectionContainer container) {
        javax.xml.ws.WebServiceRef ref = container.getAnnotation(javax.xml.ws.WebServiceRef.class, clazz);
        if (ref == null) {
            return;
        }
        String encName = ref.name();
        if (encName == null || encName.equals("")) {
            throw new RuntimeException("JBoss requires name() for class level @WebServiceRef");
        }
        encName = "env/" + ref.name();
        if (container.getEncInjectors().containsKey(encName)) {
            return;
        }
        String mappedName = ref.mappedName();
        if (mappedName == null || mappedName.equals("")) {
            throw new RuntimeException("You did not specify a @WebServiceRef.mappedName() on " + clazz.getName() + " and there is no binding for that enc name in XML");
        }
        container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, ref.mappedName(), "@WebServiceRef"));
    }

    @Override
    public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        javax.xml.ws.WebServiceRef ref = method.getAnnotation(javax.xml.ws.WebServiceRef.class);
        if (ref == null) {
            return;
        }
        if (!method.getName().startsWith("set")) {
            throw new RuntimeException("@ javax.xml.ws.WebServiceRef can only be used with a set method: " + method);
        }
        String encName = ref.name();
        encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(method) : "env/" + encName;
        if (!container.getEncInjectors().containsKey(encName)) {
            container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, ref.mappedName(), "@ javax.xml.ws.WebServiceRef"));
        }
        injectors.put(method, new JndiMethodInjector(method, encName, container.getEnc()));
    }

    @Override
    public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        javax.xml.ws.WebServiceRef ref = field.getAnnotation(javax.xml.ws.WebServiceRef.class);
        if (ref == null) {
            return;
        }
        String encName = ref.name();
        encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(field) : "env/" + encName;
        if (!container.getEncInjectors().containsKey(encName)) {
            container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, ref.mappedName(), "@ javax.xml.ws.WebServiceRef"));
        }
        injectors.put(field, new JndiFieldInjector(field, encName, container.getEnc()));
    }
}

