/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.ejb3.embedded.EJB3StandaloneDeployer;
import org.jboss.ejb3.embedded.KernelErrors;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BeanXMLDeployer;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;

public class ServletBootstrapListener
implements ServletContextListener {
    private static final Logger log = Logger.getLogger(ServletBootstrapListener.class);
    protected Kernel kernel;
    protected List<KernelDeployment> deployments = new ArrayList<KernelDeployment>();
    protected List<URL> aopDeployments = new ArrayList<URL>();
    public static HashSet ignoredJars = new HashSet();
    private EJB3StandaloneDeployer deployer;

    protected void createKernel() throws Exception {
        BasicBootstrap bootstrap1 = new BasicBootstrap();
        bootstrap1.run();
        this.kernel = bootstrap1.getKernel();
    }

    protected void deployXmlResource(String resource) {
        try {
            BeanXMLDeployer deployer = new BeanXMLDeployer(this.kernel);
            URL bootstrap = Thread.currentThread().getContextClassLoader().getResource(resource);
            if (bootstrap == null) {
                throw new RuntimeException("Cannot find " + resource);
            }
            KernelDeployment deployment = deployer.deploy(bootstrap);
            deployer.validate();
            this.deployments.add(0, deployment);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException(throwable);
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            this.createKernel();
            ServletContext servletContext = servletContextEvent.getServletContext();
            String aop = servletContext.getInitParameter("jboss-aop-deployments");
            if (aop == null) {
                aop = "ejb3-interceptors-aop.xml";
            }
            StringTokenizer tokenizer = new StringTokenizer(aop, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                log.debug("deploying aop xml: " + token);
                URL url = Thread.currentThread().getContextClassLoader().getResource(token);
                try {
                    AspectXmlLoader.deployXML(url);
                    this.aopDeployments.add(0, url);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            String deployments = servletContext.getInitParameter("jboss-kernel-deployments");
            if (deployments == null) {
                deployments = "embedded-jboss-beans.xml";
            }
            tokenizer = new StringTokenizer(deployments, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                log.debug("deploying kernel xml: " + token);
                this.deployXmlResource(token);
            }
            String scan = servletContext.getInitParameter("automatic-scan");
            if (scan != null && !scan.equals("false")) {
                return;
            }
            Set libJars = servletContext.getResourcePaths("/WEB-INF/lib");
            this.deployer = new EJB3StandaloneDeployer();
            this.deployer.setJndiProperties(this.getInitialContextProperties());
            this.deployer.setKernel(this.kernel);
            for (Object jar : libJars) {
                if (ignoredJars.contains(jar)) continue;
                URL archive = servletContext.getResource((String)jar);
                this.deployer.getArchives().add(archive);
            }
            if (this.deployer.getArchives().size() == 0) {
                this.deployer = null;
                return;
            }
            this.deployer.create();
            this.deployer.start();
        }
        catch (Exception e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        if (!KernelErrors.validate(this.kernel)) {
            throw new RuntimeException("Problems scanning ServletContext.getResourcePaths");
        }
    }

    protected Hashtable getInitialContextProperties() {
        Hashtable hash = null;
        ControllerContext context = this.kernel.getController().getInstalledContext("InitialContextProperties");
        if (context != null) {
            hash = (Hashtable)context.getTarget();
        } else {
            log.warn("could not find an configured InitialContextProperties, this is ok if your already have a correct jndi.properties file");
        }
        return hash;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            if (this.deployer != null) {
                this.deployer.stop();
                this.deployer.destroy();
            }
            BeanXMLDeployer deployer = new BeanXMLDeployer(this.kernel);
            for (KernelDeployment deployment : this.deployments) {
                deployer.undeploy(deployment);
            }
            for (URL url : this.aopDeployments) {
                AspectXmlLoader.undeployXML(url);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException(throwable);
        }
    }

    static {
        ignoredJars.add("/WEB-INF/lib/antlr-2.7.5H3.jar");
        ignoredJars.add("/WEB-INF/lib/asm-attrs.jar");
        ignoredJars.add("/WEB-INF/lib/asm.jar");
        ignoredJars.add("/WEB-INF/lib/cglib-2.1.1.jar");
        ignoredJars.add("/WEB-INF/lib/commons-collections.jar");
        ignoredJars.add("/WEB-INF/lib/commons-logging-api.jar");
        ignoredJars.add("/WEB-INF/lib/commons-logging.jar");
        ignoredJars.add("/WEB-INF/lib/concurrent.jar");
        ignoredJars.add("/WEB-INF/lib/dom4j.jar");
        ignoredJars.add("/WEB-INF/lib/ejb3-persistence.jar");
        ignoredJars.add("/WEB-INF/lib/hibernate3.jar");
        ignoredJars.add("/WEB-INF/lib/hibernate-annotations.jar");
        ignoredJars.add("/WEB-INF/lib/hibernate-entitymanager.jar");
        ignoredJars.add("/WEB-INF/lib/hsqldb.jar");
        ignoredJars.add("/WEB-INF/lib/javassist.jar");
        ignoredJars.add("/WEB-INF/lib/jboss-annotations-ejb3.jar");
        ignoredJars.add("/WEB-INF/lib/jboss-aop-jdk50.jar");
        ignoredJars.add("/WEB-INF/lib/jboss-aspect-library-jdk50.jar");
        ignoredJars.add("/WEB-INF/lib/jboss-common.jar");
        ignoredJars.add("/WEB-INF/lib/jboss-common-jdbc-wrapper.jar");
        ignoredJars.add("/WEB-INF/lib/jboss-container.jar");
        ignoredJars.add("/WEB-INF/lib/jboss-dependency.jar");
        ignoredJars.add("/WEB-INF/lib/jboss-ejb3.jar");
        ignoredJars.add("/WEB-INF/lib/jboss-ejb3x.jar");
        ignoredJars.add("/WEB-INF/lib/jboss-j2ee.jar");
        ignoredJars.add("/WEB-INF/lib/jboss-j2se.jar");
        ignoredJars.add("/WEB-INF/lib/jboss.jar");
        ignoredJars.add("/WEB-INF/lib/jboss-jca.jar");
        ignoredJars.add("/WEB-INF/lib/jboss-local-jdbc.jar");
        ignoredJars.add("/WEB-INF/lib/jboss-microcontainer.jar");
        ignoredJars.add("/WEB-INF/lib/jbossmq.jar");
        ignoredJars.add("/WEB-INF/lib/jboss-remoting.jar");
        ignoredJars.add("/WEB-INF/lib/jbosssx.jar");
        ignoredJars.add("/WEB-INF/lib/jboss-system.jar");
        ignoredJars.add("/WEB-INF/lib/jboss-transaction.jar");
        ignoredJars.add("/WEB-INF/lib/jboss-xa-jdbc.jar");
        ignoredJars.add("/WEB-INF/lib/jnpserver.jar");
        ignoredJars.add("/WEB-INF/lib/log4j.jar");
        ignoredJars.add("/WEB-INF/lib/resolver.jar");
        ignoredJars.add("/WEB-INF/lib/trove.jar");
        ignoredJars.add("/WEB-INF/lib/xercesImpl.jar");
        ignoredJars.add("/WEB-INF/lib/xml-apis.jar");
    }
}

