/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.classloading;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.deployers.plugins.AbstractAspectDeployer;
import org.jboss.deployers.spi.DeploymentContext;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.vfs.spi.VirtualFile;

public class ClassLoadingDeployer
extends AbstractAspectDeployer {
    public ClassLoadingDeployer() {
        super(ClassLoadingDeployer.class.getName(), null, 10);
    }

    public String getType() {
        return "classloading";
    }

    public boolean analyze(DeploymentContext ctx) throws DeploymentException {
        boolean hasManifest = false;
        VirtualFile vf = ctx.getFile();
        try {
            vf.findChild("META-INF/MANIFEST.MF");
            InputStream is = vf.openStream();
            Manifest mf = new Manifest(is);
            String path = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            is.close();
            if (path != null) {
                String[] cp = path.split("\\s");
                for (int n = 0; n < cp.length; ++n) {
                    String entry = cp[n];
                    ctx.addClasspathEntry(entry);
                }
                hasManifest = true;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return hasManifest;
    }

    public Object getManagedObject(DeploymentContext ctx) {
        return null;
    }

    public void deploy(DeploymentContext ctx) throws DeploymentException {
    }

    public void redeploy(DeploymentContext comp) throws DeploymentException {
    }

    public void undeploy(DeploymentContext comp) throws DeploymentException {
    }
}

