/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jboss.deployers.plugins.DefaultGraphBuilder;
import org.jboss.deployers.plugins.DeploymentGraphVisitor;
import org.jboss.deployers.plugins.DeploymentImpl;
import org.jboss.deployers.plugins.SuffixSorter;
import org.jboss.deployers.spi.AspectDeployer;
import org.jboss.deployers.spi.Deployment;
import org.jboss.deployers.spi.DeploymentContext;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.DeploymentGraphBuilder;
import org.jboss.deployers.spi.MainDeployer;
import org.jboss.util.JBossObject;
import org.jboss.util.collection.CollectionsFactory;
import org.jboss.util.graph.Graph;
import org.jboss.util.graph.Vertex;
import org.jboss.vfs.VFSFactory;
import org.jboss.vfs.spi.ReadOnlyVFS;
import org.jboss.vfs.spi.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainDeployerImpl
extends JBossObject
implements MainDeployer {
    private VFSFactory factory;
    private final List<AspectDeployer> deployers = CollectionsFactory.createLazyList();
    private final Map deploymentMap = Collections.synchronizedMap(new LinkedHashMap());
    private DeploymentGraphBuilder graphBuilder;
    private final SuffixSorter suffixSorter = new SuffixSorter();

    @Override
    public VFSFactory getVFSFactory() {
        return this.factory;
    }

    @Override
    public void setVFSFactory(VFSFactory factory) {
        this.factory = factory;
    }

    @Override
    public DeploymentGraphBuilder getGraphBuilder() {
        return this.graphBuilder;
    }

    @Override
    public void setGraphBuilder(DeploymentGraphBuilder builder) {
        this.graphBuilder = builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(AspectDeployer deployer) {
        this.log.debug("Registering aspect deployer: " + deployer);
        if (deployer == null) {
            throw new IllegalArgumentException("null deployer");
        }
        List<AspectDeployer> list = this.deployers;
        synchronized (list) {
            AspectDeployer d;
            if (this.deployers.contains(deployer)) {
                throw new IllegalArgumentException("Aspect deployer already registered" + deployer);
            }
            ListIterator<AspectDeployer> li = this.deployers.listIterator(this.deployers.size());
            int relativeOrder = deployer.getRelativeOrder();
            while (li.hasPrevious() && relativeOrder < (d = li.previous()).getRelativeOrder()) {
            }
            this.deployers.add(li.nextIndex(), deployer);
            this.suffixSorter.addEnhancedSuffixes(deployer.getEnhancedSuffixes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(AspectDeployer deployer) {
        this.log.debug("Unregistering aspect deployer: " + deployer);
        if (deployer == null) {
            throw new IllegalArgumentException("null deployer");
        }
        List<AspectDeployer> list = this.deployers;
        synchronized (list) {
            if (this.deployers.remove(deployer)) {
                this.suffixSorter.removeEnhancedSuffixes(deployer.getEnhancedSuffixes());
            }
        }
    }

    @Override
    public List<AspectDeployer> listDeployers() {
        return new ArrayList<AspectDeployer>(this.deployers);
    }

    @Override
    public String[] getSuffixes() {
        return this.suffixSorter.getSuffixes();
    }

    public void start() {
        if (this.graphBuilder == null) {
            this.graphBuilder = new DefaultGraphBuilder();
        }
    }

    @Override
    public Deployment parse(URI deployURI) throws DeploymentException {
        URL deployURL = null;
        try {
            deployURL = deployURI.toURL();
            if (deployURL == null) {
                throw new DeploymentException("Failed to covert URI to URL: " + deployURI);
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Failed to covert URI to URL: " + deployURI, e);
        }
        return this.parse(deployURL);
    }

    @Override
    public Deployment parse(URL deployURL) throws DeploymentException {
        ReadOnlyVFS vfs = null;
        try {
            vfs = this.factory.getVFS(deployURL);
            if (vfs == null) {
                throw new DeploymentException("Failed to load VFS for deployURL: " + deployURL);
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Failed to load VFS for deployURL: " + deployURL, e);
        }
        VirtualFile root = null;
        try {
            root = vfs.resolveFile("");
        }
        catch (IOException e) {
            throw new DeploymentException("Failed to resolve root file", e);
        }
        DeploymentImpl rootDeployment = new DeploymentImpl(root.getName());
        try {
            if (!this.parse(root, rootDeployment, null)) {
                throw new DeploymentException("Failed to parse deployment");
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Failed to parse deployment", e);
        }
        return rootDeployment;
    }

    @Override
    public void deploy(Deployment comp) throws DeploymentException {
        Graph<DeploymentContext> deployGraph = this.graphBuilder.build(comp);
        DeploymentGraphVisitor visitor = new DeploymentGraphVisitor(this.deployers, DeploymentGraphVisitor.MODE.Deploy);
        Vertex<DeploymentContext> root = deployGraph.getVertex(0);
        deployGraph.depthFirstSearch(root, visitor);
    }

    @Override
    public void redeploy(Deployment comp) throws DeploymentException {
        Graph<DeploymentContext> deployGraph = this.graphBuilder.build(comp);
        DeploymentGraphVisitor visitor = new DeploymentGraphVisitor(this.deployers, DeploymentGraphVisitor.MODE.Redeploy);
        Vertex<DeploymentContext> root = deployGraph.getVertex(0);
        deployGraph.depthFirstSearch(root, visitor);
    }

    @Override
    public void undeploy(Deployment comp) throws DeploymentException {
        Graph<DeploymentContext> deployGraph = this.graphBuilder.build(comp);
        DeploymentGraphVisitor visitor = new DeploymentGraphVisitor(this.deployers, DeploymentGraphVisitor.MODE.Undeploy);
        Vertex<DeploymentContext> root = deployGraph.getVertex(0);
        deployGraph.depthFirstSearch(root, visitor);
    }

    @Override
    public boolean isDeployed(Deployment comp) {
        DeploymentContext ctx = (DeploymentContext)this.deploymentMap.get(comp);
        return ctx != null;
    }

    @Override
    public void shutdown() throws DeploymentException {
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException("clone not supported");
    }

    @Override
    public String toShortString() {
        return this.getClassShortName();
    }

    public void toShortString(StringBuffer buffer) {
        buffer.append(this.toShortString());
    }

    protected void toString(StringBuffer buffer) {
        buffer.append(this.toShortString());
    }

    private boolean parse(VirtualFile file, DeploymentImpl rootDeployment, DeploymentContext parent) throws DeploymentException, IOException {
        DeploymentContext ctx = new DeploymentContext(file, parent);
        ListIterator<AspectDeployer> iter = this.deployers.listIterator();
        boolean accepted = false;
        while (iter.hasNext()) {
            AspectDeployer deployer = (AspectDeployer)iter.next();
            boolean deployerIsInterested = deployer.analyze(ctx);
            if (deployerIsInterested) {
                ctx.addDeploymentType(deployer.getType());
            }
            accepted |= deployerIsInterested;
        }
        if (accepted) {
            if (parent != null) {
                parent.addSubDeployment(ctx);
            } else {
                rootDeployment.setRootContext(ctx);
            }
            VirtualFile[] children = file.getChildren();
            if (children != null) {
                for (VirtualFile vf : children) {
                    if (ctx.isInClasspath(vf.getName())) continue;
                    accepted |= this.parse(vf, rootDeployment, ctx);
                }
            }
        }
        return accepted;
    }
}

