/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins;

import org.jboss.deployers.plugins.SuffixSorter;
import org.jboss.deployers.spi.AspectDeployer;
import org.jboss.deployers.spi.DeploymentContext;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.MainDeployer;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.util.JBossObject;

public abstract class AbstractAspectDeployer
extends JBossObject
implements AspectDeployer,
KernelControllerContextAware {
    protected static final String[] NULL_SUFFIXES = new String[0];
    protected String deployerName;
    protected MainDeployer mainDeployer;
    protected String[] suffixes = NULL_SUFFIXES;
    protected String[] enhancedSuffixes = NULL_SUFFIXES;
    protected int relativeOrder = 50;
    protected KernelControllerContext context;

    public AbstractAspectDeployer(String deployerName) {
        if (deployerName == null) {
            throw new IllegalArgumentException("null deployerName");
        }
        this.deployerName = deployerName;
    }

    public AbstractAspectDeployer(String deployerName, String[] enhancedSuffixes, int relativeOrder) {
        this(deployerName);
        this.setEnhancedSuffixes(enhancedSuffixes);
        this.setRelativeOrder(relativeOrder);
    }

    public String getAspectDeployerName() {
        return this.deployerName;
    }

    public void setMainDeployer(MainDeployer mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public MainDeployer getMainDeployer() {
        return this.mainDeployer;
    }

    public void setEnhancedSuffixes(String[] enhancedSuffixes) {
        if (enhancedSuffixes != null) {
            this.enhancedSuffixes = enhancedSuffixes;
            this.suffixes = SuffixSorter.stripOrder(enhancedSuffixes);
        }
    }

    public String[] getEnhancedSuffixes() {
        return this.enhancedSuffixes;
    }

    public void setRelativeOrder(int relativeOrder) {
        if (relativeOrder >= 0) {
            this.relativeOrder = relativeOrder;
        }
    }

    public int getRelativeOrder() {
        return this.relativeOrder;
    }

    public boolean analyze(DeploymentContext ctx) throws DeploymentException {
        return false;
    }

    public void setKernelControllerContext(KernelControllerContext context) throws Exception {
        this.log.debug("Setting kernel context " + context);
        this.context = context;
    }

    public void unsetKernelControllerContext(KernelControllerContext context) throws Exception {
        this.log.debug("Unsetting kernel context " + context);
        this.context = null;
    }

    public KernelControllerContext getKernelContext() {
        return this.context;
    }

    public void create() throws Exception {
    }

    public void start() throws Exception {
        this.mainDeployer.register(this);
    }

    public void stop() {
        this.mainDeployer.unregister(this);
    }

    public void destroy() {
    }

    public void toShortString(StringBuffer buffer) {
        buffer.append(super.getClassShortName());
    }

    protected void toString(StringBuffer buffer) {
        buffer.append(this.deployerName);
    }

    protected int getHashCode() {
        return this.deployerName.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof AbstractAspectDeployer) {
            return ((AbstractAspectDeployer)other).deployerName.equals(this.deployerName);
        }
        return false;
    }

    protected boolean endsWithOneOfTheSuffixes(String s) {
        for (int i = 0; i < this.suffixes.length; ++i) {
            if (!s.endsWith(this.suffixes[i])) continue;
            return true;
        }
        return false;
    }
}

