/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.reflect.Method;
import org.jboss.aop.Advisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodJoinpoint;
import org.jboss.aop.util.MethodHashing;

public class MethodInfo
extends JoinPointInfo {
    private Method advisedMethod;
    private Method unadvisedMethod;
    private long hash;

    public MethodInfo() {
    }

    public MethodInfo(Class clazz, long hash, long unadvisedHash, Advisor advisor) {
        super(advisor);
        try {
            this.hash = hash;
            this.advisedMethod = MethodHashing.findMethodByHash(clazz, hash);
            this.unadvisedMethod = MethodHashing.findMethodByHash(clazz, unadvisedHash);
            this.setAdvisor(advisor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private MethodInfo(MethodInfo other) {
        super(other);
        this.advisedMethod = other.advisedMethod;
        this.unadvisedMethod = other.unadvisedMethod;
        this.hash = other.hash;
    }

    protected Joinpoint internalGetJoinpoint() {
        return new MethodJoinpoint(this.advisedMethod);
    }

    public JoinPointInfo copy() {
        return new MethodInfo(this);
    }

    public Method getAdvisedMethod() {
        return this.advisedMethod;
    }

    public void setAdvisedMethod(Method advisedMethod) {
        this.advisedMethod = advisedMethod;
    }

    public long getHash() {
        return this.hash;
    }

    public void setHash(long hash) {
        this.hash = hash;
    }

    public Method getUnadvisedMethod() {
        return this.unadvisedMethod;
    }

    public void setUnadvisedMethod(Method unadvisedMethod) {
        this.unadvisedMethod = unadvisedMethod;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Method");
        sb.append("[");
        sb.append("method=" + this.advisedMethod);
        sb.append("]");
        return sb.toString();
    }
}

