/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.util.collection.CollectionsFactory;

public abstract class WeakClassCache {
    protected Map cache = new WeakHashMap();

    public Object get(Class clazz) {
        Object result;
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        Map classLoaderCache = this.getClassLoaderCache(clazz.getClassLoader());
        WeakReference weak = (WeakReference)classLoaderCache.get(clazz.getName());
        if (weak != null && (result = weak.get()) != null) {
            return result;
        }
        result = this.instantiate(clazz);
        weak = new WeakReference(result);
        classLoaderCache.put(clazz.getName(), weak);
        this.generate(clazz, result);
        return result;
    }

    public Object get(String name, ClassLoader cl) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (cl == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        Class<?> clazz = cl.loadClass(name);
        return this.get(clazz);
    }

    protected abstract Object instantiate(Class var1);

    protected abstract void generate(Class var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getClassLoaderCache(ClassLoader cl) {
        Map map = this.cache;
        synchronized (map) {
            Map result = (Map)this.cache.get(cl);
            if (result == null) {
                result = CollectionsFactory.createConcurrentReaderMap();
                this.cache.put(cl, result);
            }
            return result;
        }
    }
}

