/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.buddyreplication.GravitateResult;
import org.jboss.cache.marshall.AbstractMarshaller;
import org.jboss.cache.marshall.InactiveRegionException;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.marshall.NodeDataExceptionMarker;
import org.jboss.cache.marshall.NodeDataMarker;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.util.MapCopy;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheMarshaller200
extends AbstractMarshaller {
    private Log log = LogFactory.getLog(CacheMarshaller200.class);
    protected static final int MAGICNUMBER_METHODCALL = 1;
    protected static final int MAGICNUMBER_FQN = 2;
    protected static final int MAGICNUMBER_GTX = 3;
    protected static final int MAGICNUMBER_IPADDRESS = 4;
    protected static final int MAGICNUMBER_ARRAY_LIST = 5;
    protected static final int MAGICNUMBER_INTEGER = 6;
    protected static final int MAGICNUMBER_LONG = 7;
    protected static final int MAGICNUMBER_BOOLEAN = 8;
    protected static final int MAGICNUMBER_STRING = 9;
    protected static final int MAGICNUMBER_DEFAULT_DATA_VERSION = 10;
    protected static final int MAGICNUMBER_LINKED_LIST = 11;
    protected static final int MAGICNUMBER_HASH_MAP = 12;
    protected static final int MAGICNUMBER_TREE_MAP = 13;
    protected static final int MAGICNUMBER_HASH_SET = 14;
    protected static final int MAGICNUMBER_TREE_SET = 15;
    protected static final int MAGICNUMBER_NODEDATA_MARKER = 16;
    protected static final int MAGICNUMBER_NODEDATA_EXCEPTION_MARKER = 17;
    protected static final int MAGICNUMBER_NODEDATA = 18;
    protected static final int MAGICNUMBER_GRAVITATERESULT = 19;
    protected static final int MAGICNUMBER_SHORT = 20;
    protected static final int MAGICNUMBER_MAPCOPY = 21;
    protected static final int MAGICNUMBER_NULL = 99;
    protected static final int MAGICNUMBER_SERIALIZABLE = 100;
    protected static final int MAGICNUMBER_REF = 101;
    protected static final InactiveRegionException IRE = new InactiveRegionException("Cannot unmarshall to an inactive region");
    protected final ThreadLocal<Fqn> regionForCall = new ThreadLocal();

    public CacheMarshaller200(RegionManager manager, boolean defaultInactive, boolean useRegionBasedMarshalling) {
        this.init(manager, defaultInactive, useRegionBasedMarshalling);
        if (useRegionBasedMarshalling) {
            this.log.debug((Object)"Using region based marshalling logic : marshalling Fqn as a String first for every call.");
        }
    }

    protected boolean isReturnValue(Object o) {
        return !(o instanceof MethodCall);
    }

    @Override
    public void objectToObjectStream(Object o, ObjectOutputStream out) throws Exception {
        if (this.useRegionBasedMarshalling) {
            Fqn region;
            if (o == null) {
                region = null;
            } else if (this.isReturnValue(o)) {
                region = this.regionForCall.get();
            } else {
                MethodCall call = (MethodCall)((Object)o);
                region = this.extractFqnRegion(call);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Region based call.  Using region " + region));
            }
            this.objectToObjectStream(o, out, region);
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Marshalling object " + o));
            }
            HashMap<Object, Integer> refMap = new HashMap<Object, Integer>();
            this.marshallObject(o, out, refMap);
        }
    }

    @Override
    public Object objectFromObjectStream(ObjectInputStream in) throws Exception {
        if (this.useRegionBasedMarshalling) {
            return this.objectFromObjectStreamRegionBased(in);
        }
        HashMap<Integer, Object> refMap = new HashMap<Integer, Object>();
        Object retValue = this.unmarshallObject(in, refMap);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Unmarshalled object " + retValue));
        }
        return retValue;
    }

    @Override
    public void objectToObjectStream(Object o, ObjectOutputStream out, Fqn region) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Marshalling object " + o));
        }
        HashMap<Object, Integer> refMap = new HashMap<Object, Integer>();
        if (this.useRegionBasedMarshalling) {
            this.log.trace((Object)("Writing region " + region + " to stream"));
            this.marshallObject(region, out, refMap);
        }
        this.marshallObject(o, out, refMap);
    }

    protected Object objectFromObjectStreamRegionBased(ObjectInputStream in) throws Exception {
        Object retValue;
        HashMap<Integer, Object> refMap = new HashMap<Integer, Object>();
        Object o = this.unmarshallObject(in, refMap);
        Fqn regionFqn = null;
        if (o == null) {
            this.log.trace((Object)"Unmarshalled region as null.  Not using a context class loader to unmarshall.");
        } else {
            regionFqn = (Fqn)o;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Unmarshalled regionFqn " + regionFqn + " from stream"));
        }
        Region region = null;
        if (regionFqn != null) {
            region = this.findRegion(regionFqn);
        }
        if (region == null) {
            retValue = this.unmarshallObject(in, refMap);
        } else {
            retValue = this.unmarshallObject(in, region.getClassLoader(), refMap);
            if (!this.isReturnValue(retValue)) {
                this.regionForCall.set(regionFqn);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Unmarshalled object " + retValue));
        }
        return retValue;
    }

    private Region findRegion(Fqn fqn) throws InactiveRegionException {
        Region region = this.getRegion(fqn);
        if (region != null) {
            if (!region.isActive()) {
                if (this.log.isDebugEnabled()) {
                    throw new InactiveRegionException("Cannot unmarshall message for region " + fqn + ". This region is inactive.");
                }
                throw IRE;
            }
        } else if (this.defaultInactive) {
            if (this.log.isDebugEnabled()) {
                throw new InactiveRegionException("Cannot unmarshall message for region " + fqn + ". By default region " + fqn + " is inactive.");
            }
            throw IRE;
        }
        return region;
    }

    private Fqn extractFqnRegion(MethodCall call) throws Exception {
        Fqn fqn = call.getMethod().equals(MethodDeclarations.replicateMethod) ? this.extractFqnFromMethodCall(call) : (call.getMethod().equals(MethodDeclarations.replicateAllMethod) ? this.extractFqnFromListOfMethodCall(call) : this.extractFqn(call));
        Region r = this.getRegion(fqn);
        return r == null ? null : r.getFqn();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void marshallObject(Object o, ObjectOutputStream out, Map<Object, Integer> refMap) throws Exception {
        if (o == null) {
            out.writeByte(99);
            return;
        } else if (refMap.containsKey(o)) {
            out.writeByte(101);
            out.writeShort(refMap.get(o));
            return;
        } else if (o instanceof MethodCall) {
            MethodCall call = (MethodCall)((Object)o);
            if (call.getMethodId() <= -1) throw new IllegalArgumentException("MethodCall does not have a valid method id.  Was this method call created with MethodCallFactory?");
            out.writeByte(1);
            this.marshallMethodCall(call, out, refMap);
            return;
        } else if (o instanceof Fqn) {
            int refId = this.createReference(o, refMap);
            out.writeByte(2);
            out.writeShort(refId);
            this.marshallFqn((Fqn)o, out, refMap);
            return;
        } else if (o instanceof GlobalTransaction) {
            int refId = this.createReference(o, refMap);
            out.writeByte(3);
            out.writeShort(refId);
            this.marshallGlobalTransaction((GlobalTransaction)o, out, refMap);
            return;
        } else if (o instanceof IpAddress) {
            out.writeByte(4);
            this.marshallIpAddress((IpAddress)o, out);
            return;
        } else if (o instanceof DefaultDataVersion) {
            out.writeByte(10);
            out.writeLong(((DefaultDataVersion)o).getRawVersion());
            return;
        } else if (o.getClass().equals(ArrayList.class)) {
            out.writeByte(5);
            this.marshallCollection((Collection)o, out, refMap);
            return;
        } else if (o.getClass().equals(LinkedList.class)) {
            out.writeByte(11);
            this.marshallCollection((Collection)o, out, refMap);
            return;
        } else if (o.getClass().equals(HashMap.class)) {
            out.writeByte(12);
            this.marshallMap((Map)o, out, refMap);
            return;
        } else if (o.getClass().equals(TreeMap.class)) {
            out.writeByte(13);
            this.marshallMap((Map)o, out, refMap);
            return;
        } else if (o.getClass().equals(MapCopy.class)) {
            out.writeByte(21);
            this.marshallMap((Map)o, out, refMap);
            return;
        } else if (o.getClass().equals(HashSet.class)) {
            out.writeByte(14);
            this.marshallCollection((Collection)o, out, refMap);
            return;
        } else if (o.getClass().equals(TreeSet.class)) {
            out.writeByte(15);
            this.marshallCollection((Collection)o, out, refMap);
            return;
        } else if (o instanceof Boolean) {
            out.writeByte(8);
            out.writeBoolean((Boolean)o);
            return;
        } else if (o instanceof Integer) {
            out.writeByte(6);
            out.writeInt((Integer)o);
            return;
        } else if (o instanceof Long) {
            out.writeByte(7);
            out.writeLong((Long)o);
            return;
        } else if (o instanceof Short) {
            out.writeByte(20);
            out.writeShort(((Short)o).shortValue());
            return;
        } else if (o instanceof String) {
            int refId = this.createReference(o, refMap);
            out.writeByte(9);
            out.writeShort(refId);
            this.marshallString((String)o, out);
            return;
        } else if (o instanceof NodeDataMarker) {
            out.writeByte(16);
            ((Externalizable)o).writeExternal(out);
            return;
        } else if (o instanceof NodeDataExceptionMarker) {
            out.writeByte(17);
            ((Externalizable)o).writeExternal(out);
            return;
        } else if (o instanceof NodeData) {
            out.writeByte(18);
            ((Externalizable)o).writeExternal(out);
            return;
        } else if (o instanceof GravitateResult) {
            out.writeByte(19);
            this.marshallGravitateResult((GravitateResult)o, out, refMap);
            return;
        } else {
            if (!(o instanceof Serializable)) throw new Exception("Don't know how to marshall object of type " + o.getClass());
            int refId = this.createReference(o, refMap);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Warning: using object serialization for " + o.getClass()));
            }
            out.writeByte(100);
            out.writeShort(refId);
            out.writeObject(o);
        }
    }

    private void marshallGravitateResult(GravitateResult gravitateResult, ObjectOutputStream out, Map<Object, Integer> refMap) throws Exception {
        this.marshallObject(gravitateResult.isDataFound(), out, refMap);
        if (gravitateResult.isDataFound()) {
            this.marshallObject(gravitateResult.getNodeData(), out, refMap);
            this.marshallObject(gravitateResult.getBuddyBackupFqn(), out, refMap);
        }
    }

    private int createReference(Object o, Map<Object, Integer> refMap) {
        int reference = refMap.size();
        refMap.put(o, reference);
        return reference;
    }

    private void marshallString(String s, ObjectOutputStream out) throws Exception {
        out.writeObject(s);
    }

    private void marshallMethodCall(MethodCall methodCall, ObjectOutputStream out, Map<Object, Integer> refMap) throws Exception {
        out.writeShort(methodCall.getMethodId());
        Object[] args = methodCall.getArgs();
        int numArgs = args == null ? 0 : args.length;
        out.writeByte(numArgs);
        for (int i = 0; i < numArgs; ++i) {
            this.marshallObject(args[i], out, refMap);
        }
    }

    private void marshallGlobalTransaction(GlobalTransaction globalTransaction, ObjectOutputStream out, Map<Object, Integer> refMap) throws Exception {
        out.writeLong(globalTransaction.getId());
        this.marshallObject(globalTransaction.getAddress(), out, refMap);
    }

    private void marshallFqn(Fqn fqn, ObjectOutputStream out, Map<Object, Integer> refMap) throws Exception {
        boolean isRoot = fqn.isRoot();
        out.writeBoolean(isRoot);
        if (!isRoot) {
            out.writeShort(fqn.size());
            for (int i = 0; i < fqn.size(); ++i) {
                this.marshallObject(fqn.get(i), out, refMap);
            }
        }
    }

    private void marshallIpAddress(IpAddress ipAddress, ObjectOutputStream out) throws Exception {
        ipAddress.writeExternal((ObjectOutput)out);
    }

    private void marshallCollection(Collection c, ObjectOutputStream out, Map refMap) throws Exception {
        out.writeInt(c.size());
        for (Object o : c) {
            this.marshallObject(o, out, refMap);
        }
    }

    private void marshallMap(Map map, ObjectOutputStream out, Map<Object, Integer> refMap) throws Exception {
        int mapSize = map.size();
        out.writeInt(mapSize);
        if (mapSize == 0) {
            return;
        }
        for (Map.Entry me : map.entrySet()) {
            this.marshallObject(me.getKey(), out, refMap);
            this.marshallObject(me.getValue(), out, refMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object unmarshallObject(ObjectInputStream in, ClassLoader loader, Map<Integer, Object> refMap) throws Exception {
        if (loader == null) {
            return this.unmarshallObject(in, refMap);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader old = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(loader);
            Object object = this.unmarshallObject(in, refMap);
            return object;
        }
        finally {
            currentThread.setContextClassLoader(old);
        }
    }

    private Object unmarshallObject(ObjectInputStream in, Map<Integer, Object> refMap) throws Exception {
        byte magicNumber = in.readByte();
        switch (magicNumber) {
            case 99: {
                return null;
            }
            case 101: {
                Integer reference = in.readShort();
                if (!refMap.containsKey(reference)) {
                    throw new IOException("Unable to locate object reference " + reference + " in byte stream!");
                }
                return refMap.get(reference);
            }
            case 100: {
                Integer reference = in.readShort();
                Object retVal = in.readObject();
                refMap.put(reference, retVal);
                return retVal;
            }
            case 1: {
                MethodCall retVal = this.unmarshallMethodCall(in, refMap);
                return retVal;
            }
            case 2: {
                Integer reference = in.readShort();
                Fqn retVal = this.unmarshallFqn(in, refMap);
                refMap.put(reference, retVal);
                return retVal;
            }
            case 3: {
                Integer reference = in.readShort();
                GlobalTransaction retVal = this.unmarshallGlobalTransaction(in, refMap);
                refMap.put(reference, retVal);
                return retVal;
            }
            case 4: {
                IpAddress retVal = this.unmarshallIpAddress(in);
                return retVal;
            }
            case 10: {
                DefaultDataVersion retVal = new DefaultDataVersion(in.readLong());
                return retVal;
            }
            case 5: {
                return this.unmarshallArrayList(in, refMap);
            }
            case 11: {
                return this.unmarshallLinkedList(in, refMap);
            }
            case 12: {
                return this.unmarshallHashMap(in, refMap);
            }
            case 13: {
                return this.unmarshallTreeMap(in, refMap);
            }
            case 14: {
                return this.unmarshallHashSet(in, refMap);
            }
            case 15: {
                return this.unmarshallTreeSet(in, refMap);
            }
            case 21: {
                return this.unmarshallMapCopy(in, refMap);
            }
            case 8: {
                return in.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return in.readInt();
            }
            case 7: {
                return in.readLong();
            }
            case 20: {
                return in.readShort();
            }
            case 9: {
                Integer reference = in.readShort();
                String retVal = this.unmarshallString(in);
                refMap.put(reference, retVal);
                return retVal;
            }
            case 16: {
                NodeDataMarker retVal = new NodeDataMarker();
                retVal.readExternal(in);
                return retVal;
            }
            case 17: {
                NodeDataExceptionMarker retVal = new NodeDataExceptionMarker();
                retVal.readExternal(in);
                return retVal;
            }
            case 18: {
                NodeData retVal = new NodeData();
                retVal.readExternal(in);
                return retVal;
            }
            case 19: {
                return this.unmarshallGravitateResult(in, refMap);
            }
        }
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)("Unknown Magic Number " + magicNumber));
        }
        throw new Exception("Unknown magic number " + magicNumber);
    }

    private GravitateResult unmarshallGravitateResult(ObjectInputStream in, Map<Integer, Object> refMap) throws Exception {
        Boolean found = (Boolean)this.unmarshallObject(in, refMap);
        if (found.booleanValue()) {
            List stuff = (List)this.unmarshallObject(in, refMap);
            Fqn fqn = (Fqn)this.unmarshallObject(in, refMap);
            return GravitateResult.subtreeResult(stuff, fqn);
        }
        return GravitateResult.noDataFound();
    }

    private String unmarshallString(ObjectInputStream in) throws Exception {
        return (String)in.readObject();
    }

    private MethodCall unmarshallMethodCall(ObjectInputStream in, Map<Integer, Object> refMap) throws Exception {
        short methodId = in.readShort();
        int numArgs = in.readByte();
        Object[] args = null;
        if (numArgs > 0) {
            args = new Object[numArgs];
            for (int i = 0; i < numArgs; ++i) {
                args[i] = this.unmarshallObject(in, refMap);
            }
        }
        return MethodCallFactory.create(MethodDeclarations.lookupMethod(methodId), args);
    }

    private GlobalTransaction unmarshallGlobalTransaction(ObjectInputStream in, Map<Integer, Object> refMap) throws Exception {
        GlobalTransaction gtx = new GlobalTransaction();
        long id = in.readLong();
        Object address = this.unmarshallObject(in, refMap);
        gtx.setId(id);
        gtx.setAddress((Address)address);
        return gtx;
    }

    private Fqn unmarshallFqn(ObjectInputStream in, Map<Integer, Object> refMap) throws Exception {
        Fqn fqn;
        boolean isRoot = in.readBoolean();
        if (!isRoot) {
            int numElements = in.readShort();
            ArrayList<Object> elements = new ArrayList<Object>(numElements);
            for (int i = 0; i < numElements; ++i) {
                elements.add(this.unmarshallObject(in, refMap));
            }
            fqn = new Fqn(elements);
        } else {
            fqn = Fqn.ROOT;
        }
        return fqn;
    }

    private IpAddress unmarshallIpAddress(ObjectInputStream in) throws Exception {
        IpAddress ipAddress = new IpAddress();
        ipAddress.readExternal((ObjectInput)in);
        return ipAddress;
    }

    private List unmarshallArrayList(ObjectInputStream in, Map refMap) throws Exception {
        int listSize = in.readInt();
        ArrayList list = new ArrayList(listSize);
        this.populateFromStream(in, refMap, list, listSize);
        return list;
    }

    private List unmarshallLinkedList(ObjectInputStream in, Map refMap) throws Exception {
        LinkedList list = new LinkedList();
        this.populateFromStream(in, refMap, list, in.readInt());
        return list;
    }

    private Map unmarshallHashMap(ObjectInputStream in, Map refMap) throws Exception {
        HashMap map = new HashMap();
        this.populateFromStream(in, refMap, map);
        return map;
    }

    private Map unmarshallMapCopy(ObjectInputStream in, Map<Integer, Object> refMap) throws Exception {
        Map m = this.unmarshallHashMap(in, refMap);
        MapCopy mc = new MapCopy(m);
        return mc;
    }

    private Map unmarshallTreeMap(ObjectInputStream in, Map refMap) throws Exception {
        TreeMap map = new TreeMap();
        this.populateFromStream(in, refMap, map);
        return map;
    }

    private Set unmarshallHashSet(ObjectInputStream in, Map refMap) throws Exception {
        HashSet set = new HashSet();
        this.populateFromStream(in, refMap, set);
        return set;
    }

    private Set unmarshallTreeSet(ObjectInputStream in, Map refMap) throws Exception {
        TreeSet set = new TreeSet();
        this.populateFromStream(in, refMap, set);
        return set;
    }

    private void populateFromStream(ObjectInputStream in, Map refMap, Map mapToPopulate) throws Exception {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            mapToPopulate.put(this.unmarshallObject(in, refMap), this.unmarshallObject(in, refMap));
        }
    }

    private void populateFromStream(ObjectInputStream in, Map refMap, Set setToPopulate) throws Exception {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            setToPopulate.add(this.unmarshallObject(in, refMap));
        }
    }

    private void populateFromStream(ObjectInputStream in, Map refMap, List listToPopulate, int listSize) throws Exception {
        for (int i = 0; i < listSize; ++i) {
            listToPopulate.add(this.unmarshallObject(in, refMap));
        }
    }
}

