/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractCacheLoader;
import org.jboss.cache.loader.ClusteredCacheLoaderConfig;
import org.jboss.cache.lock.StripedLock;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ClusteredCacheLoader
extends AbstractCacheLoader {
    private static Log log = LogFactory.getLog(ClusteredCacheLoader.class);
    private StripedLock lock = new StripedLock();
    private ClusteredCacheLoaderConfig config;

    @Override
    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.config = base instanceof ClusteredCacheLoaderConfig ? (ClusteredCacheLoaderConfig)base : new ClusteredCacheLoaderConfig(base);
    }

    @Override
    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getChildrenNames(Fqn fqn) throws Exception {
        if (!this.cache.getInvocationContext().isOriginLocal()) {
            return Collections.emptySet();
        }
        this.lock.acquireLock(fqn, true);
        try {
            MethodCall call = MethodCallFactory.create(MethodDeclarations.getChildrenNamesMethodLocal, fqn);
            Object resp = this.callRemote(call);
            Set set = (Set)resp;
            return set;
        }
        finally {
            this.lock.releaseLock(fqn);
        }
    }

    private Object callRemote(MethodCall call) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("cache=" + this.cache.getLocalAddress() + "; calling with " + (Object)((Object)call)));
        }
        List<Address> mbrs = this.cache.getMembers();
        MethodCall clusteredGet = MethodCallFactory.create(MethodDeclarations.clusteredGetMethod, new Object[]{call, false});
        List resps = this.cache.getRPCManager().callRemoteMethods(mbrs, clusteredGet, 1, true, this.config.getTimeout());
        if (resps == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No replies to call " + (Object)((Object)call) + ".  Perhaps we're alone in the cluster?"));
            }
            return null;
        }
        Iterator i = resps.iterator();
        Object result = null;
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof Exception) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Found remote exception among responses - removing from responses list", (Throwable)((Exception)o));
                continue;
            }
            if (o != null) {
                List clusteredGetResp = (List)o;
                if (!((Boolean)clusteredGetResp.get(0)).booleanValue()) continue;
                result = clusteredGetResp.get(1);
                break;
            }
            if (this.cache.getConfiguration().isUseRegionBasedMarshalling()) continue;
            throw new IllegalStateException("Received unexpected null response to " + (Object)((Object)clusteredGet));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("got responses " + resps));
        }
        return result;
    }

    public Map get(Fqn name) throws Exception {
        return this.get0(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map get0(Fqn name) throws Exception {
        if (!this.cache.getInvocationContext().isOriginLocal()) {
            return Collections.emptyMap();
        }
        this.lock.acquireLock(name, true);
        try {
            MethodCall call = MethodCallFactory.create(MethodDeclarations.getDataMapMethodLocal, name);
            Object resp = this.callRemote(call);
            Map map = (Map)resp;
            return map;
        }
        finally {
            this.lock.releaseLock(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(Fqn name) throws Exception {
        if (!this.cache.getInvocationContext().isOriginLocal()) {
            return false;
        }
        this.lock.acquireLock(name, false);
        try {
            MethodCall call = MethodCallFactory.create(MethodDeclarations.existsMethod, name);
            Object resp = this.callRemote(call);
            boolean bl = resp != null && (Boolean)resp != false;
            return bl;
        }
        finally {
            this.lock.releaseLock(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Fqn name, Object key, Object value) throws Exception {
        if (this.cache.getInvocationContext().isOriginLocal()) {
            this.lock.acquireLock(name, true);
            try {
                NodeSPI n = this.cache.peek(name, false);
                if (n == null) {
                    MethodCall call = MethodCallFactory.create(MethodDeclarations.getKeyValueMethodLocal, name, key, true);
                    Object object = this.callRemote(call);
                    return object;
                }
                Object v = n.getDirect(key);
                return v;
            }
            finally {
                this.lock.releaseLock(name);
            }
        }
        log.trace((Object)"Call originated remotely.  Not bothering to try and do a clustered get() for this put().  Returning null.");
        return null;
    }

    public void put(Fqn name, Map attributes) throws Exception {
    }

    @Override
    public void put(List<Modification> modifications) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Fqn name, Object key) throws Exception {
        if (this.cache.getInvocationContext().isOriginLocal()) {
            this.lock.acquireLock(name, true);
            try {
                NodeSPI n = this.cache.peek(name, true);
                if (n == null) {
                    MethodCall call = MethodCallFactory.create(MethodDeclarations.getKeyValueMethodLocal, name, key, true);
                    Object object = this.callRemote(call);
                    return object;
                }
                Object v = n.getDirect(key);
                return v;
            }
            finally {
                this.lock.releaseLock(name);
            }
        }
        log.trace((Object)"Call originated remotely.  Not bothering to try and do a clustered get() for this remove().  Returning null.");
        return null;
    }

    @Override
    public void remove(Fqn name) throws Exception {
    }

    @Override
    public void removeData(Fqn name) throws Exception {
    }

    public void prepare(Object tx, List modifications, boolean one_phase) throws Exception {
    }

    @Override
    public void commit(Object tx) throws Exception {
    }

    @Override
    public void rollback(Object tx) {
    }

    @Override
    public void loadEntireState(ObjectOutputStream os) throws Exception {
    }

    @Override
    public void loadState(Fqn subtree, ObjectOutputStream os) throws Exception {
    }

    @Override
    public void storeEntireState(ObjectInputStream is) throws Exception {
    }

    @Override
    public void storeState(Fqn subtree, ObjectInputStream is) throws Exception {
    }

    @Override
    public void setRegionManager(RegionManager manager) {
    }
}

