/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.transaction.Transaction;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.cache.marshall.MethodCall;

public class UnlockInterceptor
extends Interceptor {
    Map lock_table = null;
    boolean trace = this.log.isTraceEnabled();

    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.lock_table = cache.getLockTable();
    }

    public Object invoke(InvocationContext ctx) throws Throwable {
        Transaction tx2;
        Object object;
        MethodCall m = ctx.getMethodCall();
        try {
            object = super.invoke(ctx);
            Object var5_5 = null;
        }
        catch (Throwable th) {
            try {
                throw th;
            }
            catch (Throwable throwable) {
                block9: {
                    Transaction tx2;
                    Object var5_6 = null;
                    if (ctx.getOptionOverrides() != null && ctx.getOptionOverrides().isSuppressLocking() || (tx2 = ctx.getTransaction()) != null && this.isValid(tx2)) break block9;
                    Thread currentThread = Thread.currentThread();
                    List locks = (List)this.lock_table.get(currentThread);
                    if (this.trace) {
                        this.log.trace((Object)("Attempting to release locks on current thread.  Lock table is " + this.lock_table));
                    }
                    if (locks != null && locks.size() > 0) {
                        this.releaseLocks(locks, currentThread);
                        this.lock_table.remove(currentThread);
                    }
                }
                throw throwable;
            }
        }
        if (!(ctx.getOptionOverrides() != null && ctx.getOptionOverrides().isSuppressLocking() || (tx2 = ctx.getTransaction()) != null && this.isValid(tx2))) {
            Thread currentThread = Thread.currentThread();
            List locks = (List)this.lock_table.get(currentThread);
            if (this.trace) {
                this.log.trace((Object)("Attempting to release locks on current thread.  Lock table is " + this.lock_table));
            }
            if (locks != null && locks.size() > 0) {
                this.releaseLocks(locks, currentThread);
                this.lock_table.remove(currentThread);
            }
        }
        return object;
    }

    private void releaseLocks(List locks, Thread currentThread) {
        ListIterator it = locks.listIterator(locks.size());
        while (it.hasPrevious()) {
            IdentityLock lock = (IdentityLock)it.previous();
            if (this.trace) {
                this.log.trace((Object)("releasing lock for " + lock.getFqn() + ": " + lock));
            }
            lock.release(currentThread);
        }
    }
}

