/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import org.jboss.cache.InvocationContext;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.transaction.GlobalTransaction;

public class ReplicationInterceptor
extends BaseRpcInterceptor {
    public Object invoke(InvocationContext ctx) throws Throwable {
        boolean isLocalCommitOrRollback;
        MethodCall m = ctx.getMethodCall();
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        if (MethodDeclarations.isBuddyGroupOrganisationMethod(m.getMethodId())) {
            return super.invoke(ctx);
        }
        boolean bl = isLocalCommitOrRollback = gtx != null && !gtx.isRemote() && (m.getMethodId() == 11 || m.getMethodId() == 12);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("isLocalCommitOrRollback? " + isLocalCommitOrRollback + "; gtx = " + gtx));
        }
        Object o = isLocalCommitOrRollback ? null : super.invoke(ctx);
        Option optionOverride = ctx.getOptionOverrides();
        if (optionOverride != null && optionOverride.isCacheModeLocal() && ctx.getTransaction() == null) {
            this.log.trace((Object)"skip replication");
            return isLocalCommitOrRollback ? super.invoke(ctx) : o;
        }
        if (ctx.getTransaction() != null) {
            if (gtx != null && !gtx.isRemote()) {
                switch (m.getMethodId()) {
                    case 11: {
                        if (this.containsModifications(ctx)) {
                            this.replicateCall(m, this.configuration.isSyncCommitPhase());
                        }
                        o = super.invoke(ctx);
                        break;
                    }
                    case 10: {
                        if (!this.containsModifications(ctx)) break;
                        this.runPreparePhase(m, gtx);
                        break;
                    }
                    case 12: {
                        if (this.containsModifications(ctx) && !ctx.isLocalRollbackOnly()) {
                            this.replicateCall(m, this.configuration.isSyncRollbackPhase());
                        }
                        o = super.invoke(ctx);
                        break;
                    }
                    case 45: {
                        this.cache.getTransactionTable().get(gtx).setForceAsyncReplication(true);
                    }
                }
            }
        } else if (MethodDeclarations.isCrudMethod(m.getMethodId())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Non-tx crud meth");
            }
            if (ctx.isOriginLocal()) {
                this.handleReplicatedMethod(m, this.configuration.getCacheMode());
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Non-tx and non crud meth");
        }
        return o;
    }

    void handleReplicatedMethod(MethodCall m, Configuration.CacheMode mode) throws Throwable {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("invoking method " + (Object)((Object)m) + ", members=" + this.cache.getMembers() + ", mode=" + (Object)((Object)this.configuration.getCacheMode()) + ", exclude_self=" + true + ", timeout=" + this.configuration.getSyncReplTimeout()));
        }
        if (mode == Configuration.CacheMode.REPL_ASYNC || m.getMethodId() == 45) {
            this.replicateCall(m, false);
        } else {
            this.replicateCall(m, true);
        }
    }

    protected void runPreparePhase(MethodCall prepareMethod, GlobalTransaction gtx) throws Throwable {
        boolean async;
        boolean bl = async = this.configuration.getCacheMode() == Configuration.CacheMode.REPL_ASYNC;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("(" + this.cache.getLocalAddress() + "): running remote prepare for global tx " + gtx + " with async mode=" + async));
        }
        this.replicateCall(prepareMethod, !async);
    }
}

